/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.dashboard.web.util;

import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.dashboard.web.util.ConfirmAjaxCallListener;

public abstract class AjaxConfirmLink<T>
extends AjaxLink<T> {
    private static final long serialVersionUID = 1L;
    private String confirmMessage;

    public AjaxConfirmLink(String id) {
        super(id);
    }

    public AjaxConfirmLink(String id, IModel<T> model) {
        super(id, model);
    }

    public AjaxConfirmLink(String id, String confirmMessage) {
        super(id);
        this.confirmMessage = confirmMessage;
    }

    public AjaxConfirmLink(String id, IModel<T> model, String confirmMessage) {
        super(id, model);
        this.confirmMessage = confirmMessage;
    }

    public void setConfirmMessage(String confirmMessage) {
        this.confirmMessage = confirmMessage;
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        if (!Strings.isEmpty((CharSequence)this.confirmMessage)) {
            attributes.getAjaxCallListeners().add(new ConfirmAjaxCallListener(this.confirmMessage));
        }
    }
}

