/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.notifier;

import javax.annotation.PostConstruct;
import org.apache.openmeetings.core.notifier.INotifier;
import org.apache.openmeetings.core.notifier.NotifierService;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class TextNotifier
implements INotifier {
    private static final Logger log = LoggerFactory.getLogger(TextNotifier.class);
    @Autowired
    private NotifierService notifier;
    @Autowired
    protected TaskExecutor taskExecutor;
    @Autowired
    protected ConfigurationDao cfgDao;

    @PostConstruct
    private void register() {
        this.notifier.addNotifier((INotifier)this);
    }

    public void notify(User u, Appointment a, Invitation inv) throws Exception {
        if (u.getAddress() == null || Strings.isEmpty((CharSequence)u.getAddress().getPhone())) {
            log.debug("User has no Phone, skip sending notification");
            return;
        }
        String phone = u.getAddress().getPhone();
        String msg = this.cfgDao.getString("reminder.message", null);
        if (Strings.isEmpty((CharSequence)msg)) {
            msg = String.format("%s %s", LabelDao.getString((String)"1158", (long)u.getLanguageId()), a.getTitle());
        }
        String reminderMsg = msg;
        this.taskExecutor.execute(() -> log.debug("Sending Text to: {}, msg is: {}", (Object)phone, (Object)reminderMsg));
    }
}

