/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.calendar.caldav.handler;

import com.github.caldav4j.methods.HttpCalDAVReportMethod;
import com.github.caldav4j.methods.HttpDeleteMethod;
import com.github.caldav4j.methods.HttpPutMethod;
import com.github.caldav4j.model.request.CalDAVReportRequest;
import com.github.caldav4j.model.request.CalendarData;
import com.github.caldav4j.model.request.CalendarQuery;
import com.github.caldav4j.model.request.CalendarRequest;
import com.github.caldav4j.model.request.CompFilter;
import com.github.caldav4j.model.response.CalendarDataProperty;
import com.github.caldav4j.util.UrlUtils;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.service.calendar.caldav.IcalUtils;
import org.apache.openmeetings.service.calendar.caldav.handler.AbstractCalendarHandler;
import org.apache.openmeetings.service.calendar.caldav.handler.MultigetHandler;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtagsHandler
extends AbstractCalendarHandler {
    private static final Logger log = LoggerFactory.getLogger(EtagsHandler.class);

    private static String getFullPath(URI uri, String path) {
        return uri.getScheme() + "://" + uri.getAuthority() + path;
    }

    public EtagsHandler(String path, OmCalendar calendar, HttpClient client, HttpClientContext context, AppointmentDao appointmentDao, IcalUtils utils) {
        super(path, calendar, client, context, appointmentDao, utils);
    }

    @Override
    BaseDavRequest internalSyncItems() throws IOException, DavException {
        Long ownerId = this.calendar.getOwner().getId();
        Map<String, Appointment> map = EtagsHandler.listToMap(this.appointmentDao.getbyCalendar(this.calendar.getId()));
        DavPropertyNameSet properties = new DavPropertyNameSet();
        properties.add(DavPropertyName.GETETAG);
        CompFilter vcalendar = new CompFilter("VCALENDAR");
        vcalendar.addCompFilter(new CompFilter("VEVENT"));
        CalendarQuery query = new CalendarQuery(properties, vcalendar, new CalendarData(), false, false);
        HttpCalDAVReportMethod method = new HttpCalDAVReportMethod(this.path, (CalDAVReportRequest)query, 1);
        HttpResponse httpResponse = this.client.execute((HttpUriRequest)method, (HttpContext)this.context);
        if (method.succeeded(httpResponse)) {
            MultiStatusResponse[] multiStatusResponses = method.getResponseBodyAsMultiStatus(httpResponse).getResponses();
            if (map.isEmpty()) {
                for (MultiStatusResponse response : multiStatusResponses) {
                    if (response.getStatus()[0].getStatusCode() != 200) continue;
                    String etag = CalendarDataProperty.getEtagfromResponse((MultiStatusResponse)response);
                    Calendar ical = CalendarDataProperty.getCalendarfromResponse((MultiStatusResponse)response);
                    Appointment appointments = this.utils.parseCalendartoAppointment(ical, response.getHref(), etag, this.calendar);
                    this.appointmentDao.update(appointments, ownerId);
                }
            } else {
                for (MultiStatusResponse response : multiStatusResponses) {
                    if (response.getStatus()[0].getStatusCode() != 200) continue;
                    Appointment appointment = map.get(response.getHref());
                    if (appointment != null) {
                        String origetag = appointment.getEtag();
                        String currentetag = CalendarDataProperty.getEtagfromResponse((MultiStatusResponse)response);
                        if (!currentetag.equals(origetag)) {
                            Calendar calendar = CalendarDataProperty.getCalendarfromResponse((MultiStatusResponse)response);
                            appointment = this.utils.parseCalendartoAppointment(appointment, calendar, currentetag);
                            this.appointmentDao.update(appointment, ownerId);
                        }
                        map.remove(response.getHref());
                        continue;
                    }
                    String etag = CalendarDataProperty.getEtagfromResponse((MultiStatusResponse)response);
                    Calendar ical = CalendarDataProperty.getCalendarfromResponse((MultiStatusResponse)response);
                    Appointment appointments = this.utils.parseCalendartoAppointment(ical, response.getHref(), etag, this.calendar);
                    this.appointmentDao.update(appointments, ownerId);
                }
                for (Map.Entry entry : map.entrySet()) {
                    this.appointmentDao.delete((Appointment)entry.getValue(), ownerId);
                }
            }
        } else {
            log.error("Report Method return Status: {} for calId {} ", (Object)httpResponse.getStatusLine().getStatusCode(), (Object)this.calendar.getId());
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean updateItem(Appointment appointment) {
        block15: {
            OmCalendar calendar = appointment.getCalendar();
            if (calendar != null && calendar.getSyncType() != OmCalendar.SyncType.NONE) {
                boolean bl;
                HttpPutMethod putMethod = null;
                try {
                    List<String> hrefs = null;
                    CalendarOutputter calendarOutputter = new CalendarOutputter();
                    Object temp = null;
                    Calendar ical = this.utils.parseAppointmenttoCalendar(appointment);
                    CalendarRequest cr = new CalendarRequest(ical);
                    if (Strings.isEmpty((CharSequence)appointment.getHref())) {
                        temp = this.path + appointment.getIcalId() + ".ics";
                        temp = UrlUtils.removeDoubleSlashes((String)temp);
                        cr.setIfNoneMatch(true);
                        cr.setAllEtags(true);
                    } else {
                        temp = EtagsHandler.getFullPath(URI.create(this.path), appointment.getHref());
                        cr.setIfMatch(true);
                        cr.addEtag(appointment.getEtag());
                    }
                    putMethod = new HttpPutMethod((String)temp, cr, calendarOutputter);
                    HttpResponse httpResponse = this.client.execute((HttpUriRequest)putMethod, (HttpContext)this.context);
                    if (putMethod.succeeded(httpResponse)) {
                        String href = putMethod.getURI().getPath();
                        appointment.setHref(href);
                        Header etagh = putMethod.getFirstHeader("ETag");
                        if (etagh == null) {
                            hrefs = Collections.singletonList(appointment.getHref());
                        } else {
                            appointment.setEtag(etagh.getValue());
                            this.appointmentDao.update(appointment, appointment.getOwner().getId());
                        }
                    } else {
                        boolean etagh = false;
                        this.releaseConnection((HttpRequestBase)putMethod);
                        return etagh;
                    }
                    MultigetHandler multigetHandler = new MultigetHandler(hrefs, true, this.path, calendar, this.client, this.context, this.appointmentDao, this.utils);
                    multigetHandler.syncItems();
                    bl = true;
                    this.releaseConnection((HttpRequestBase)putMethod);
                }
                catch (IOException e) {
                    log.error("Error executing OptionsMethod during testConnection.", (Throwable)e);
                    break block15;
                }
                catch (Exception e2) {
                    log.error("Severe Error in executing OptionsMethod during testConnection.", (Throwable)e2);
                    break block15;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.releaseConnection((HttpRequestBase)putMethod);
                }
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean deleteItem(Appointment appointment) {
        block9: {
            if (this.calendar != null && this.calendar.getSyncType() != OmCalendar.SyncType.NONE) {
                HttpDeleteMethod deleteMethod = null;
                try {
                    Object fullPath = Strings.isEmpty((CharSequence)appointment.getHref()) ? this.path + appointment.getIcalId() + ".ics" : EtagsHandler.getFullPath(URI.create(this.path), appointment.getHref());
                    deleteMethod = new HttpDeleteMethod((String)fullPath, appointment.getEtag());
                    log.info("Deleting at location: {} with ETag: {}", fullPath, (Object)appointment.getEtag());
                    HttpResponse response = this.client.execute((HttpUriRequest)deleteMethod, (HttpContext)this.context);
                    int status = response.getStatusLine().getStatusCode();
                    if (status == 204 || status == 200 || status == 404) {
                        log.info("Successfully deleted appointment with id: {}", (Object)appointment.getId());
                        boolean bl = true;
                        this.releaseConnection((HttpRequestBase)deleteMethod);
                        return bl;
                    }
                    this.releaseConnection((HttpRequestBase)deleteMethod);
                }
                catch (IOException e) {
                    log.error("Error executing OptionsMethod during testConnection.", (Throwable)e);
                }
                catch (Exception e2) {
                    log.error("Severe Error in executing OptionsMethod during testConnection.", (Throwable)e2);
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.releaseConnection((HttpRequestBase)deleteMethod);
                }
            }
        }
        return false;
    }
}

