/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.calendar.caldav;

import java.net.URI;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.UUID;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IcalUtils {
    private static final Logger log = LoggerFactory.getLogger(IcalUtils.class);
    public static final String PROD_ID = "-//Events Calendar//Apache Openmeetings//EN";
    @Autowired
    private UserDao userDao;

    public Appointment parseCalendartoAppointment(net.fortuna.ical4j.model.Calendar calendar, String href, String etag, OmCalendar omCalendar) {
        Appointment a = new Appointment();
        a.setId(null);
        a.setDeleted(false);
        a.setHref(href);
        a.setCalendar(omCalendar);
        a.setOwner(omCalendar.getOwner());
        a.setRoom(IcalUtils.createDefaultRoom());
        a.setReminder(Appointment.Reminder.NONE);
        return this.parseCalendartoAppointment(a, calendar, etag);
    }

    public List<Appointment> parseCalendartoAppointments(net.fortuna.ical4j.model.Calendar calendar, Long ownerId) {
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        ComponentList events = calendar.getComponents("VEVENT");
        User owner = this.userDao.get(ownerId);
        for (CalendarComponent event : events) {
            Appointment a = new Appointment();
            a.setOwner(owner);
            a.setDeleted(false);
            a.setRoom(IcalUtils.createDefaultRoom());
            a.setReminder(Appointment.Reminder.NONE);
            a = this.addVEventPropertiestoAppointment(a, event);
            appointments.add(a);
        }
        return appointments;
    }

    public Appointment parseCalendartoAppointment(Appointment a, net.fortuna.ical4j.model.Calendar calendar, String etag) {
        if (calendar == null) {
            return a;
        }
        CalendarComponent event = calendar.getComponent("VEVENT");
        if (event != null) {
            a.setEtag(etag);
            a = this.addVEventPropertiestoAppointment(a, event);
        }
        return a;
    }

    private Appointment addVEventPropertiestoAppointment(Appointment a, CalendarComponent event) {
        URI uri;
        Parameter freq;
        DateProperty dtstart = (DateProperty)event.getProperty("DTSTART");
        DateProperty dtend = (DateProperty)event.getProperty("DTEND");
        DateProperty dtstamp = (DateProperty)event.getProperty("DTSTAMP");
        DateProperty lastmod = (DateProperty)event.getProperty("LAST-MODIFIED");
        Property uid = event.getProperty("UID");
        Property description = event.getProperty("DESCRIPTION");
        Property summary = event.getProperty("SUMMARY");
        Property location = event.getProperty("LOCATION");
        Property organizer = event.getProperty("ORGANIZER");
        Property recur = event.getProperty("RRULE");
        PropertyList attendees = event.getProperties("ATTENDEE");
        if (uid != null) {
            a.setIcalId(uid.getValue());
        }
        Date d = dtstart.getDate();
        a.setStart((java.util.Date)d);
        if (dtend == null) {
            a.setEnd(this.addTimetoDate((java.util.Date)d, 11, 1));
        } else {
            a.setEnd((java.util.Date)dtend.getDate());
        }
        a.setInserted((java.util.Date)dtstamp.getDate());
        if (lastmod != null) {
            a.setUpdated((java.util.Date)lastmod.getDate());
        }
        if (description != null) {
            a.setDescription(description.getValue());
        }
        if (summary != null) {
            a.setTitle(summary.getValue());
        }
        if (location != null) {
            a.setLocation(location.getValue());
        }
        if (recur != null && (freq = recur.getParameter("FREQ")) != null) {
            if (freq.getValue().equals(Recur.Frequency.DAILY.name())) {
                a.setIsDaily(Boolean.valueOf(true));
            } else if (freq.getValue().equals(Recur.Frequency.WEEKLY.name())) {
                a.setIsWeekly(Boolean.valueOf(true));
            } else if (freq.getValue().equals(Recur.Frequency.MONTHLY.name())) {
                a.setIsMonthly(Boolean.valueOf(true));
            } else if (freq.getValue().equals(Recur.Frequency.YEARLY.name())) {
                a.setIsYearly(Boolean.valueOf(true));
            }
        }
        HashSet<MeetingMember> attList = a.getMeetingMembers() == null ? new HashSet<MeetingMember>() : new HashSet(a.getMeetingMembers());
        String organizerEmail = null;
        if (organizer != null && "mailto".equals((uri = URI.create(organizer.getValue())).getScheme())) {
            String email;
            organizerEmail = email = uri.getSchemeSpecificPart();
            if (!email.equals(a.getOwner().getAddress().getEmail())) {
                User org = this.userDao.getByEmail(email);
                if (org == null) {
                    org = this.userDao.getContact(email, a.getOwner());
                    attList.add(IcalUtils.createMeetingMember(a, org));
                } else if (!org.getId().equals(a.getOwner().getId())) {
                    attList.add(IcalUtils.createMeetingMember(a, org));
                }
            }
        }
        if (attendees != null && !attendees.isEmpty()) {
            for (Property attendee : attendees) {
                URI uri2 = URI.create(attendee.getValue());
                if (!"mailto".equals(uri2.getScheme())) continue;
                String email = uri2.getSchemeSpecificPart();
                Role role = (Role)attendee.getParameter(Role.CHAIR.getName());
                if (role != null && role.getValue().equals(Role.CHAIR.getValue()) && email.equals(organizerEmail)) continue;
                User u = this.userDao.getByEmail(email);
                if (u == null) {
                    u = this.userDao.getContact(email, a.getOwner());
                }
                attList.add(IcalUtils.createMeetingMember(a, u));
            }
        }
        a.setMeetingMembers((List)(attList.isEmpty() ? null : new ArrayList(attList)));
        return a;
    }

    private static MeetingMember createMeetingMember(Appointment a, User u) {
        MeetingMember mm = new MeetingMember();
        mm.setUser(u);
        mm.setDeleted(false);
        mm.setInserted(a.getInserted());
        mm.setUpdated(a.getUpdated());
        mm.setAppointment(a);
        return mm;
    }

    private static Room createDefaultRoom() {
        Room r = new Room();
        r.setAppointment(true);
        if (r.getType() == null) {
            r.setType(Room.Type.CONFERENCE);
        }
        return r;
    }

    public TimeZone parseTimeZone(net.fortuna.ical4j.model.Calendar calendar, User owner) {
        Property tzid;
        CalendarComponent timezone;
        if (calendar != null && (timezone = calendar.getComponent("VTIMEZONE")) != null && (tzid = timezone.getProperty("TZID")) != null) {
            return TimezoneUtil.getTimeZone((String)tzid.getValue());
        }
        return TimezoneUtil.getTimeZone((User)owner);
    }

    public java.util.Date parseDate(Property dt, TimeZone timeZone) {
        if (dt == null || Strings.isEmpty((CharSequence)dt.getValue())) {
            return null;
        }
        String[] acceptedFormats = new String[]{"yyyyMMdd'T'HHmmss", "yyyyMMdd'T'HHmmss'Z'", "yyyyMMdd"};
        Parameter tzid = dt.getParameter("TZID");
        if (tzid == null) {
            return this.parseDate(dt.getValue(), acceptedFormats, timeZone);
        }
        return this.parseDate(dt.getValue(), acceptedFormats, TimezoneUtil.getTimeZone((String)tzid.getValue()));
    }

    public java.util.Date parseDate(String str, String[] patterns, TimeZone inTimeZone) {
        Locale locale = WebSession.get().getLocale();
        TimeZone timeZone = str.endsWith("Z") ? TimeZone.getTimeZone("UTC") : inTimeZone;
        ParsePosition pos = new ParsePosition(0);
        for (String pattern : patterns) {
            FastDateFormat parser = FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone, (Locale)locale);
            pos.setIndex(0);
            java.util.Date date = parser.parse(str, pos);
            if (date == null || pos.getIndex() != str.length()) continue;
            return date;
        }
        log.error("Unable to parse the date: {} at {}", (Object)str, (Object)-1);
        return null;
    }

    public java.util.Date addTimetoDate(java.util.Date date, int field, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(field, amount);
        return c.getTime();
    }

    public net.fortuna.ical4j.model.Calendar parseAppointmenttoCalendar(Appointment appointment) {
        String tzid = this.parseTimeZone(null, appointment.getOwner()).getID();
        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        net.fortuna.ical4j.model.TimeZone timeZone = registry.getTimeZone(tzid);
        if (timeZone == null) {
            throw new NoSuchElementException("Unable to get time zone by id provided: " + tzid);
        }
        net.fortuna.ical4j.model.Calendar icsCalendar = new net.fortuna.ical4j.model.Calendar();
        icsCalendar.getProperties().add((Property)new ProdId(PROD_ID));
        icsCalendar.getProperties().add((Property)Version.VERSION_2_0);
        icsCalendar.getProperties().add((Property)CalScale.GREGORIAN);
        icsCalendar.getComponents().add((Object)timeZone.getVTimeZone());
        DateTime start = new DateTime(appointment.getStart());
        DateTime end = new DateTime(appointment.getEnd());
        VEvent meeting = new VEvent((Date)start, (Date)end, appointment.getTitle());
        IcalUtils.addVEventpropsfromAppointment(appointment, meeting);
        icsCalendar.getComponents().add((Object)meeting);
        return icsCalendar;
    }

    private static void addVEventpropsfromAppointment(Appointment appointment, VEvent meeting) {
        Uid ui;
        if (appointment.getLocation() != null) {
            meeting.getProperties().add((Property)new Location(appointment.getLocation()));
        }
        meeting.getProperties().add((Property)new Description(appointment.getDescription()));
        meeting.getProperties().add((Property)new Sequence(0));
        meeting.getProperties().add((Property)Transp.OPAQUE);
        String uid = appointment.getIcalId();
        if (uid == null || uid.length() < 1) {
            UUID uuid = UUID.randomUUID();
            appointment.setIcalId(uuid.toString());
            ui = new Uid(uuid.toString());
        } else {
            ui = new Uid(uid);
        }
        meeting.getProperties().add((Property)ui);
        if (appointment.getMeetingMembers() != null) {
            for (MeetingMember meetingMember : appointment.getMeetingMembers()) {
                Attendee attendee = new Attendee(URI.create("mailto:" + meetingMember.getUser().getAddress().getEmail()));
                attendee.getParameters().add((Parameter)Role.REQ_PARTICIPANT);
                attendee.getParameters().add((Parameter)new Cn(meetingMember.getUser().getLogin()));
                meeting.getProperties().add((Property)attendee);
            }
        }
        URI orgUri = URI.create("mailto:" + appointment.getOwner().getAddress().getEmail());
        Attendee orgAtt = new Attendee(orgUri);
        orgAtt.getParameters().add((Parameter)Role.CHAIR);
        Cn orgCn = new Cn(appointment.getOwner().getLogin());
        orgAtt.getParameters().add((Parameter)orgCn);
        meeting.getProperties().add((Property)orgAtt);
        Organizer organizer = new Organizer(orgUri);
        organizer.getParameters().add((Parameter)orgCn);
        meeting.getProperties().add((Property)organizer);
    }

    public net.fortuna.ical4j.model.Calendar parseAppointmentstoCalendar(List<Appointment> appointments, Long ownerId) {
        String tzid = this.parseTimeZone(null, this.userDao.get(ownerId)).getID();
        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        net.fortuna.ical4j.model.TimeZone timeZone = registry.getTimeZone(tzid);
        if (timeZone == null) {
            throw new NoSuchElementException("Unable to get time zone by id provided: " + tzid);
        }
        net.fortuna.ical4j.model.Calendar icsCalendar = new net.fortuna.ical4j.model.Calendar();
        icsCalendar.getProperties().add((Property)new ProdId(PROD_ID));
        icsCalendar.getProperties().add((Property)Version.VERSION_2_0);
        icsCalendar.getProperties().add((Property)CalScale.GREGORIAN);
        icsCalendar.getComponents().add((Object)timeZone.getVTimeZone());
        for (Appointment appointment : appointments) {
            DateTime start = new DateTime(appointment.getStart());
            DateTime end = new DateTime(appointment.getEnd());
            VEvent meeting = new VEvent((Date)start, (Date)end, appointment.getTitle());
            IcalUtils.addVEventpropsfromAppointment(appointment, meeting);
            icsCalendar.getComponents().add((Object)meeting);
        }
        return icsCalendar;
    }
}

