/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.jdom;

import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMImport;
import org.aspectj.org.eclipse.jdt.internal.core.jdom.DOMNode;
import org.aspectj.org.eclipse.jdt.internal.core.util.CharArrayBuffer;
import org.aspectj.org.eclipse.jdt.internal.core.util.Messages;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;

class DOMImport
extends DOMNode
implements IDOMImport {
    protected boolean fOnDemand;
    protected int fFlags = 0;

    DOMImport() {
        this.fName = "java.lang.*";
        this.setMask(2048, true);
    }

    DOMImport(char[] document, int[] sourceRange, String name, int[] nameRange, boolean onDemand, int modifiers) {
        super(document, sourceRange, name, nameRange);
        this.fOnDemand = onDemand;
        this.fFlags = modifiers;
        this.setMask(2048, true);
    }

    DOMImport(char[] document, int[] sourceRange, String name, boolean onDemand, int modifiers) {
        this(document, sourceRange, name, new int[]{-1, -1}, onDemand, modifiers);
        this.fOnDemand = onDemand;
        this.setMask(2048, false);
    }

    @Override
    protected void appendFragmentedContents(CharArrayBuffer buffer) {
        if (this.fNameRange[0] < 0) {
            buffer.append("import ").append(this.fName).append(';').append(Util.getLineSeparator(buffer.toString(), null));
        } else {
            buffer.append(this.fDocument, this.fSourceRange[0], this.fNameRange[0] - this.fSourceRange[0]);
            buffer.append(this.fName);
            buffer.append(this.fDocument, this.fNameRange[1] + 1, this.fSourceRange[1] - this.fNameRange[1]);
        }
    }

    @Override
    public String getContents() {
        if (this.fName == null) {
            return null;
        }
        return super.getContents();
    }

    @Override
    protected DOMNode getDetailedNode() {
        return (DOMNode)((Object)this.getFactory().createImport(this.getContents()));
    }

    @Override
    public IJavaElement getJavaElement(IJavaElement parent) throws IllegalArgumentException {
        if (parent.getElementType() == 5) {
            return ((ICompilationUnit)parent).getImport(this.getName());
        }
        throw new IllegalArgumentException(Messages.element_illegalParent);
    }

    @Override
    public int getNodeType() {
        return 3;
    }

    @Override
    public boolean isOnDemand() {
        return this.fOnDemand;
    }

    @Override
    protected DOMNode newDOMNode() {
        return new DOMImport();
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(Messages.element_nullName);
        }
        this.becomeDetailed();
        super.setName(name);
        this.fOnDemand = name.endsWith(".*");
    }

    @Override
    public String toString() {
        return "IMPORT: " + this.getName();
    }

    @Override
    public int getFlags() {
        return this.fFlags;
    }

    @Override
    public void setFlags(int flags) {
        this.fFlags = flags;
    }
}

