/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.mapper;

import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.dto.user.GroupDTO;
import org.apache.openmeetings.db.dto.user.UserDTO;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.wicket.util.string.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserMapper {
    @Autowired
    private UserDao userDao;
    @Autowired
    private GroupDao groupDao;

    public User get(UserDTO dto) {
        User u = dto.getId() == null ? new User() : this.userDao.get(dto.getId());
        u.setLogin(dto.getLogin());
        u.setFirstname(dto.getFirstname());
        u.setLastname(dto.getLastname());
        u.setRights(dto.getRights());
        u.setLanguageId(dto.getLanguageId());
        u.setAddress(dto.getAddress());
        u.setTimeZoneId(dto.getTimeZoneId());
        String externalId = dto.getExternalId();
        String externalType = dto.getExternalType();
        User.Type type = dto.getType();
        if (User.Type.EXTERNAL == type || !Strings.isEmpty((CharSequence)externalId) && !Strings.isEmpty((CharSequence)externalType)) {
            type = User.Type.EXTERNAL;
            if (u.getGroupUsers().stream().filter(gu -> gu.getGroup().isExternal() && gu.getGroup().getName().equals(externalType)).count() == 0L) {
                u.addGroup(this.groupDao.getExternal(externalType));
            }
            u.setExternalId(externalId);
        }
        u.setType(type == null ? User.Type.USER : type);
        u.setPictureUri(dto.getPictureUri());
        return u;
    }

    public Group get(GroupDTO dto) {
        Group g = dto.getId() == null ? new Group() : this.groupDao.get(dto.getId());
        g.setName(dto.getName());
        g.setTag(dto.getTag());
        return g;
    }
}

