/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.mapper;

import java.util.ArrayList;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.dto.calendar.AppointmentDTO;
import org.apache.openmeetings.db.dto.calendar.MeetingMemberDTO;
import org.apache.openmeetings.db.dto.user.UserDTO;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.mapper.RoomMapper;
import org.apache.openmeetings.db.mapper.UserMapper;
import org.apache.wicket.util.string.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarMapper {
    @Autowired
    private UserDao userDao;
    @Autowired
    private AppointmentDao appointmentDao;
    @Autowired
    private UserMapper uMapper;
    @Autowired
    private RoomMapper rMapper;

    public Appointment get(AppointmentDTO dto, User u) {
        Appointment a = dto.getId() == null ? new Appointment() : this.appointmentDao.get(dto.getId());
        a.setId(dto.getId());
        a.setTitle(dto.getTitle());
        a.setLocation(dto.getLocation());
        a.setStart(dto.getStart().getTime());
        a.setEnd(dto.getEnd().getTime());
        a.setDescription(dto.getDescription());
        a.setOwner(dto.getOwner() == null ? u : this.userDao.get(dto.getOwner().getId()));
        a.setInserted(dto.getInserted());
        a.setUpdated(dto.getUpdated());
        a.setDeleted(dto.isDeleted());
        a.setReminder(dto.getReminder());
        a.setRoom(this.rMapper.get(dto.getRoom()));
        a.setIcalId(dto.getIcalId());
        ArrayList<MeetingMember> mml = new ArrayList<MeetingMember>();
        for (MeetingMemberDTO mm : dto.getMeetingMembers()) {
            MeetingMember m = null;
            if (mm.getId() != null) {
                for (MeetingMember m1 : a.getMeetingMembers()) {
                    if (!m1.getId().equals(mm.getId())) continue;
                    m = m1;
                    break;
                }
                if (m == null) {
                    throw new RuntimeException("Weird guest from different appointment is passed");
                }
            } else {
                m = this.get(mm, u);
                m.setAppointment(a);
            }
            mml.add(m);
        }
        a.setMeetingMembers(mml);
        a.setLanguageId(dto.getLanguageId());
        a.setPasswordProtected(dto.isPasswordProtected());
        a.setConnectedEvent(dto.isConnectedEvent());
        a.setReminderEmailSend(dto.isReminderEmailSend());
        return a;
    }

    public MeetingMember get(MeetingMemberDTO dto, User owner) {
        MeetingMember mm = new MeetingMember();
        mm.setId(dto.getId());
        if (dto.getUser().getId() != null) {
            mm.setUser(this.userDao.get(dto.getUser().getId()));
        } else {
            User u = null;
            UserDTO user = dto.getUser();
            if (User.Type.EXTERNAL == user.getType()) {
                u = this.userDao.getExternalUser(user.getExternalId(), user.getExternalType());
            }
            if (u == null && user.getAddress() != null) {
                u = this.userDao.getContact(user.getAddress().getEmail(), user.getFirstname(), user.getLastname(), user.getLanguageId(), user.getTimeZoneId(), owner);
            }
            if (u == null) {
                user.setType(User.Type.CONTACT);
                u = this.uMapper.get(user);
                u.getRights().clear();
            }
            if (Strings.isEmpty((CharSequence)u.getTimeZoneId())) {
                u.setTimeZoneId(owner.getTimeZoneId());
            }
            mm.setUser(u);
        }
        return mm;
    }
}

