/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.user;

import com.github.openjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.openmeetings.db.entity.user.Address;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.DtoHelper;

@XmlRootElement
public class UserDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String login;
    private String password;
    private String firstname;
    private String lastname;
    private Set<User.Right> rights = new HashSet<User.Right>();
    private Long languageId;
    private Address address = new Address();
    private String timeZoneId;
    private String externalId;
    private String externalType;
    private String pictureUri;
    private User.Type type = User.Type.USER;

    public UserDTO() {
    }

    public UserDTO(User u) {
        this.id = u.getId();
        this.firstname = u.getFirstname();
        this.lastname = u.getLastname();
        this.rights = u.getRights();
        this.login = u.getLogin();
        this.languageId = u.getLanguageId();
        this.address = u.getAddress();
        this.timeZoneId = u.getTimeZoneId();
        this.type = u.getType();
        this.externalId = u.getExternalId();
        this.externalType = u.externalType();
        this.pictureUri = u.getPictureUri();
    }

    public static List<UserDTO> list(List<User> l) {
        ArrayList<UserDTO> uList = new ArrayList<UserDTO>();
        if (l != null) {
            for (User u : l) {
                uList.add(new UserDTO(u));
            }
        }
        return uList;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public Set<User.Right> getRights() {
        return this.rights;
    }

    public void setRights(Set<User.Right> rights) {
        this.rights = rights;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public Long getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Long languageId) {
        this.languageId = languageId;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public User.Type getType() {
        return this.type;
    }

    public void setType(User.Type type) {
        this.type = type;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalType() {
        return this.externalType;
    }

    public void setExternalType(String externalType) {
        this.externalType = externalType;
    }

    public String getPictureUri() {
        return this.pictureUri;
    }

    public void setPictureUri(String pictureUri) {
        this.pictureUri = pictureUri;
    }

    public static UserDTO fromString(String s) {
        return UserDTO.get(new JSONObject(s));
    }

    public static UserDTO get(JSONObject o) {
        if (o == null) {
            return null;
        }
        UserDTO u = new UserDTO();
        u.id = DtoHelper.optLong(o, "id");
        u.login = o.optString("login");
        u.password = o.optString("password");
        u.firstname = o.optString("firstname");
        u.lastname = o.optString("lastname");
        u.rights.addAll(DtoHelper.optEnumList(User.Right.class, o.optJSONArray("rights")));
        u.languageId = o.optLong("languageId");
        JSONObject a = o.optJSONObject("address");
        if (a != null) {
            u.address.setId(DtoHelper.optLong(a, "id"));
            u.address.setCountry(a.optString("country"));
            u.address.setEmail(a.optString("email"));
        }
        u.timeZoneId = o.optString("timeZoneId");
        u.externalId = o.optString("externalId", null);
        u.externalType = o.optString("externalType", null);
        u.type = DtoHelper.optEnum(User.Type.class, o, "type");
        u.pictureUri = o.optString("pictureUri", null);
        return u;
    }

    public String toString() {
        return new JSONObject((Object)this).toString();
    }
}

