/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.openmeetings.db.util.LocaleHelper;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;

public class CountryDropDown
extends DropDownChoice<String> {
    private static final long serialVersionUID = 1L;

    public CountryDropDown(String id) {
        this(id, null);
    }

    public CountryDropDown(String id, IModel<String> model) {
        super(id);
        this.setDefaultModel(model);
        ArrayList countries = new ArrayList(LocaleHelper.getCountries());
        countries.sort((c1, c2) -> LocaleHelper.getCountryName((String)c1, (Locale)this.getLocale()).compareTo(LocaleHelper.getCountryName((String)c2, (Locale)this.getLocale())));
        this.setChoices(countries);
        this.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(){
            private static final long serialVersionUID = 1L;

            public String getIdValue(String code, int index) {
                return code;
            }

            public Object getDisplayValue(String code) {
                return LocaleHelper.getCountryName((String)code, (Locale)CountryDropDown.this.getLocale());
            }

            public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                for (String code : (List)choices.getObject()) {
                    if (!code.equals(id)) continue;
                    return code;
                }
                return null;
            }
        });
    }
}

