/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.rooms;

import java.io.Serializable;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.UserBasePanel;
import org.apache.openmeetings.web.user.rooms.RoomsPanel;
import org.apache.openmeetings.web.user.rooms.RoomsTabbedPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class RoomsSelectorPanel
extends UserBasePanel {
    private static final long serialVersionUID = 1L;
    private static final String PANEL_ID = "rooms";
    private final String type;
    @SpringBean
    private RoomDao roomDao;

    public RoomsSelectorPanel(String id, String type) {
        super(id);
        this.type = type;
    }

    protected void onInitialize() {
        String desc;
        String title;
        if ("group".equals(this.type)) {
            title = "779";
            desc = "780";
            this.add(new Component[]{new RoomsTabbedPanel(PANEL_ID)});
        } else if (OpenmeetingsVariables.isMyRoomsEnabled() && "my".equals(this.type)) {
            title = "781";
            desc = "782";
            this.add(new Component[]{new RoomsPanel(PANEL_ID, this.roomDao.getMyRooms(WebSession.getUserId(), Application.getString("my.room.conference"), Application.getString("my.room.presentation")))});
        } else {
            title = "777";
            desc = "778";
            this.add(new Component[]{new RoomsPanel(PANEL_ID, this.roomDao.getPublicRooms())});
        }
        this.add(new Component[]{new Label("title", (Serializable)((Object)this.getString(title)))});
        this.add(new Component[]{new Label("desc", (Serializable)((Object)this.getString(desc))).setRenderBodyOnly(true)});
        super.onInitialize();
    }
}

