/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.profile;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import java.io.Serializable;
import java.time.Duration;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.ComunityUserForm;
import org.apache.openmeetings.web.common.FormActionsPanel;
import org.apache.openmeetings.web.common.GeneralUserForm;
import org.apache.openmeetings.web.common.UploadableProfileImagePanel;
import org.apache.openmeetings.web.pages.PrivacyPage;
import org.apache.openmeetings.web.user.profile.ChangePasswordDialog;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormValidatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditProfileForm
extends Form<User> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(EditProfileForm.class);
    private final PasswordTextField passwd = new PasswordTextField("passwd", (IModel)new Model());
    private final GeneralUserForm userForm;
    private final ChangePasswordDialog chPwdDlg;
    private boolean checkPassword;
    private FormActionsPanel<User> actions;
    @SpringBean
    private UserDao userDao;

    public EditProfileForm(String id, ChangePasswordDialog chPwdDlg) {
        super(id);
        this.setModel((IModel)new CompoundPropertyModel((Object)this.userDao.get(WebSession.getUserId())));
        this.userForm = new GeneralUserForm("general", (IModel<User>)this.getModel(), false);
        this.chPwdDlg = chPwdDlg;
        this.checkPassword = User.Type.OAUTH != ((User)this.getModelObject()).getType();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.passwd.setLabel((IModel)new ResourceModel("current.password")).setRequired(true).setVisible(this.checkPassword)});
        Component[] componentArray = new Component[1];
        this.actions = new FormActionsPanel<User>("buttons", (Form)this){
            private static final long serialVersionUID = 1L;

            private void refreshUser() {
                User u = (User)EditProfileForm.this.getModelObject();
                u = u.getId() != null ? EditProfileForm.this.userDao.get(u.getId()) : new User();
                EditProfileForm.this.setModelObject(u);
            }

            @Override
            protected void onSaveSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    EditProfileForm.this.userDao.update((User)EditProfileForm.this.getModelObject(), null, WebSession.getUserId());
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)e.getMessage()));
                }
                this.refreshUser();
                target.add(new Component[]{EditProfileForm.this});
            }

            @Override
            protected void onRefreshSubmit(AjaxRequestTarget target, Form<?> form) {
                this.refreshUser();
                target.add(new Component[]{EditProfileForm.this});
            }

            @Override
            protected void onPurgeSubmit(AjaxRequestTarget target, Form<?> form) {
                EditProfileForm.this.userDao.purge((User)EditProfileForm.this.getModelObject(), WebSession.getUserId());
                WebSession.get().invalidateNow();
                this.setResponsePage(Application.get().getSignInPageClass());
            }
        };
        componentArray[0] = this.actions;
        this.add(componentArray);
        this.add(new Component[]{new BootstrapAjaxLink<String>("changePwd", (IModel)Model.of((Serializable)((Object)"")), Buttons.Type.Outline_Danger, (IModel)new ResourceModel("327")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                EditProfileForm.this.chPwdDlg.show((IPartialPageRequestHandler)target);
            }
        }.setVisible(this.checkPassword)});
        this.add(new Component[]{this.userForm});
        this.add(new Component[]{new UploadableProfileImagePanel("img", WebSession.getUserId())});
        this.add(new Component[]{new ComunityUserForm("comunity", (IModel<User>)this.getModel())});
        this.add(new Behavior[]{new AjaxFormValidatingBehavior("keydown", Duration.ofSeconds(1L))});
        this.add(new Component[]{new BookmarkablePageLink("link", PrivacyPage.class)});
    }

    protected void onConfigure() {
        super.onConfigure();
        this.actions.setPurgeVisible(true);
    }

    protected void onValidate() {
        String p;
        if (this.checkPassword && !Strings.isEmpty((CharSequence)(p = (String)this.passwd.getConvertedInput())) && !this.userDao.verifyPassword(((User)this.getModelObject()).getId(), p)) {
            this.error((Serializable)((Object)this.getString("231")));
            try {
                Thread.sleep(6L + (long)(10.0 * Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                log.error("Unexpected exception while sleeping", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        super.onValidate();
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(false);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("$('.profile-edit-form .my-info').off().click(function() {showUserInfo(" + WebSession.getUserId() + ");});")));
    }
}

