/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.sidebar;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.room.sidebar.RoomFilePanel;
import org.apache.openmeetings.web.room.sidebar.RoomFileUploadResourceReference;
import org.apache.openmeetings.web.util.upload.BootstrapFileUploadBehavior;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Bytes;

public class UploadDialog
extends Modal<String> {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer form = new WebMarkupContainer("form");
    private final RoomFilePanel roomFiles;
    private final RoomPanel room;
    private final WebMarkupContainer lastSelectedId = new WebMarkupContainer("lastSelectedId");
    private final WebMarkupContainer lastSelectedRoom = new WebMarkupContainer("lastSelectedRoom");
    private final WebMarkupContainer lastSelectedOwner = new WebMarkupContainer("lastSelectedOwner");
    private final WebMarkupContainer lastSelectedGroup = new WebMarkupContainer("lastSelectedGroup");

    public UploadDialog(String id, RoomPanel room, RoomFilePanel roomFiles) {
        super(id);
        this.roomFiles = roomFiles;
        this.room = room;
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("upload.dlg.choose.title"));
        this.setCloseOnEscapeKey(false);
        this.setBackdrop(Modal.Backdrop.STATIC);
        this.add(new Component[]{this.form.add(new Behavior[]{AttributeModifier.append((String)"data-max-size", (Serializable)Long.valueOf(OpenmeetingsVariables.getMaxUploadSize()))}).add(new Behavior[]{AttributeModifier.append((String)"data-max-size-lbl", (Serializable)((Object)Bytes.bytes((long)OpenmeetingsVariables.getMaxUploadSize()).toString(WebSession.get().getLocale())))}).add(new Behavior[]{AttributeModifier.append((String)"data-upload-lbl", (Serializable)((Object)this.getString("593")))}).add(new Behavior[]{AttributeModifier.append((String)"data-max-upload-lbl", (Serializable)((Object)this.getString("1491")))}).add(new Behavior[]{AttributeModifier.append((String)"action", (Serializable)((Object)("" + this.urlFor(new RoomFileUploadResourceReference(), new PageParameters()))))}).setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
        this.form.add(new Component[]{new WebMarkupContainer("sid").add(new Behavior[]{AttributeModifier.append((String)"value", (Serializable)((Object)this.room.getClient().getSid()))}).setMarkupId("room-upload-sid").setOutputMarkupId(true)});
        this.form.add(new Component[]{this.lastSelectedId.setMarkupId("room-upload-last-selected-id").setOutputMarkupId(true)});
        this.form.add(new Component[]{this.lastSelectedRoom.setMarkupId("room-upload-last-selected-room").setOutputMarkupId(true)});
        this.form.add(new Component[]{this.lastSelectedOwner.setMarkupId("room-upload-last-selected-pwner").setOutputMarkupId(true)});
        this.form.add(new Component[]{this.lastSelectedGroup.setMarkupId("room-upload-last-selected-group").setOutputMarkupId(true)});
        this.add(new Behavior[]{BootstrapFileUploadBehavior.INSTANCE});
        this.addButton((Component)OmModalCloseButton.of("85"));
        super.onInitialize();
    }

    public Modal<String> show(IPartialPageRequestHandler handler) {
        BaseFileItem last = this.roomFiles.getLastSelected();
        if (last.getId() == null) {
            this.lastSelectedRoom.add(new Behavior[]{AttributeModifier.replace((String)"value", (Serializable)last.getRoomId())});
            this.lastSelectedOwner.add(new Behavior[]{AttributeModifier.replace((String)"value", (Serializable)last.getOwnerId())});
            this.lastSelectedGroup.add(new Behavior[]{AttributeModifier.replace((String)"value", (Serializable)last.getGroupId())});
        } else {
            this.lastSelectedId.add(new Behavior[]{AttributeModifier.replace((String)"value", (Serializable)last.getId())});
        }
        handler.add(new Component[]{this.form.setVisible(true)});
        handler.appendJavaScript((CharSequence)"Upload.bindUpload();");
        return super.show(handler);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(UploadDialog.class, "upload.js"))));
    }
}

