/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.sidebar;

import com.github.openjson.JSONObject;
import org.apache.openmeetings.core.remote.StreamProcessor;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.common.NameDialog;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.room.VideoSettings;
import org.apache.openmeetings.web.room.activities.ActivitiesPanel;
import org.apache.openmeetings.web.room.activities.Activity;
import org.apache.openmeetings.web.room.sidebar.RoomFilePanel;
import org.apache.openmeetings.web.room.sidebar.UploadDialog;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoomSidebar
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RoomSidebar.class);
    public static final String FUNC_SETTINGS = "avSettings";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_RIGHT = "right";
    public static final String PARAM_UID = "uid";
    public static final String PARAM_SETTINGS = "s";
    private final RoomPanel room;
    private UploadDialog upload;
    private RoomFilePanel roomFiles;
    private final WebMarkupContainer fileTab = new WebMarkupContainer("file-tab");
    private boolean showFiles;
    private VideoSettings settings = new VideoSettings("settings");
    private ActivitiesPanel activities;
    @SpringBean
    private ClientManager cm;
    @SpringBean
    private StreamProcessor streamProcessor;

    public RoomSidebar(String id, RoomPanel room) {
        super(id);
        this.room = room;
    }

    protected void onInitialize() {
        super.onInitialize();
        NameDialog addFolder = new NameDialog("addFolder", this.getString("712")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                RoomSidebar.this.roomFiles.createFolder(target, (String)this.getModelObject());
                super.onSubmit(target);
            }
        };
        this.roomFiles = new RoomFilePanel("tree", this.room, addFolder);
        this.add(new Component[]{this.fileTab.setVisible(!this.room.isInterview()), this.roomFiles.setVisible(!this.room.isInterview())});
        this.add(new Component[]{addFolder, this.settings});
        Component[] componentArray = new Component[1];
        this.upload = new UploadDialog("upload", this.room, this.roomFiles);
        componentArray[0] = this.upload;
        this.add(componentArray);
        this.updateShowFiles(null);
        Component[] componentArray2 = new Component[1];
        this.activities = new ActivitiesPanel("activities", this.room);
        componentArray2[0] = this.activities;
        this.add(componentArray2);
    }

    private void updateShowFiles(IPartialPageRequestHandler handler) {
        if (this.room.isInterview()) {
            return;
        }
        this.showFiles = !this.room.getRoom().isHidden(Room.RoomElement.FILES) && this.room.getClient().hasRight(Room.Right.PRESENTER);
        this.roomFiles.setReadOnly(!this.showFiles, handler);
    }

    public void update(IPartialPageRequestHandler handler) {
        if (this.room.getRoom() == null || this.room.getClient() == null) {
            return;
        }
        this.updateShowFiles(handler);
    }

    public void updateFiles(IPartialPageRequestHandler handler) {
        this.roomFiles.update(handler);
    }

    public RoomFilePanel getFilesPanel() {
        return this.roomFiles;
    }

    public boolean isShowFiles() {
        return this.showFiles;
    }

    public void showUpload(IPartialPageRequestHandler handler) {
        this.upload.show(handler);
    }

    public void setFilesActive(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)"$('#room-sidebar-files-tab').tab('show');");
    }

    public void addActivity(Activity a, IPartialPageRequestHandler handler) {
        this.activities.add(a, handler);
    }

    public void removeActivity(String uid, IPartialPageRequestHandler handler) {
        this.activities.remove(handler, uid);
    }

    public void roomAction(IPartialPageRequestHandler handler, JSONObject o) {
        try {
            String uid = o.getString(PARAM_UID);
            if (Strings.isEmpty((CharSequence)uid)) {
                return;
            }
            Client self = this.room.getClient();
            RoomPanel.Action a = RoomPanel.Action.of(o.getString(PARAM_ACTION));
            switch (a) {
                case KICK: {
                    if (!self.hasRight(Room.Right.MODERATOR)) break;
                    Client kickedClient = this.cm.get(uid);
                    if (kickedClient == null) {
                        return;
                    }
                    if (!kickedClient.hasRight(Room.Right.SUPER_MODERATOR) && !self.getUid().equals(kickedClient.getUid())) {
                        Application.kickUser(kickedClient);
                    }
                    break;
                }
                case MUTE_OTHERS: {
                    if (!this.room.getClient().hasRight(Room.Right.MUTE_OTHERS)) break;
                    WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(this.room.getRoom().getId(), self, RoomMessage.Type.MUTE_OTHERS, uid));
                    break;
                }
                case MUTE: {
                    this.muteRoomAction(uid, self, o);
                    break;
                }
                case TOGGLE_RIGHT: {
                    this.toggleRight(handler, self, uid, o);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Unexpected exception while toggle 'roomAction'", (Throwable)e);
        }
    }

    private void muteRoomAction(String uid, Client self, JSONObject o) {
        Client c = this.cm.get(uid);
        if (c == null || !c.hasActivity(Client.Activity.AUDIO)) {
            return;
        }
        if (self.hasRight(Room.Right.MODERATOR) || self.getUid().equals(c.getUid())) {
            WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(this.room.getRoom().getId(), self, RoomMessage.Type.MUTE, new JSONObject().put("sid", (Object)self.getSid()).put(PARAM_UID, (Object)uid).put("mute", o.getBoolean("mute")).toString()));
        }
    }

    private void toggleRight(IPartialPageRequestHandler handler, Client self, String uid, JSONObject o) {
        try {
            Room.Right right = Room.Right.valueOf((String)o.getString(PARAM_RIGHT));
            if (self.hasRight(Room.Right.MODERATOR)) {
                Client client = this.cm.get(uid);
                if (client == null) {
                    return;
                }
                if (client.hasRight(right)) {
                    this.room.denyRight(client, right);
                } else if (Room.Right.VIDEO == right) {
                    this.room.allowRight(client, Room.Right.AUDIO, right);
                } else {
                    this.room.allowRight(client, right);
                }
            } else {
                this.room.requestRight(right, handler);
            }
        }
        catch (Exception e) {
            log.error("Unexpected exception while toggle 'right'", (Throwable)e);
        }
    }
}

