/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room;

import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.room.IconTextModal;
import org.apache.openmeetings.web.room.OmTimerBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.flow.RedirectToUrlException;
import org.apache.wicket.util.string.Strings;

public class RedirectMessageDialog
extends IconTextModal {
    private static final long serialVersionUID = 1L;
    private static final int DELAY = 5;
    private final String labelId;
    private final String url;
    private final boolean autoOpen;

    public RedirectMessageDialog(String id, String labelId, boolean autoOpen, String url) {
        super(id);
        this.labelId = labelId;
        this.url = url;
        this.autoOpen = autoOpen;
    }

    @Override
    protected void onInitialize() {
        this.header((IModel)new ResourceModel("204"));
        this.setCloseOnEscapeKey(false);
        this.show(this.autoOpen);
        this.withLabel((IModel<String>)new ResourceModel(this.labelId));
        this.getLabel().setOutputMarkupId(true);
        this.withErrorIcon();
        super.onInitialize();
        if (this.autoOpen) {
            this.startTimer(null);
        }
    }

    private void startTimer(IPartialPageRequestHandler handler) {
        this.getLabel().add(new Behavior[]{new OmTimerBehavior(5, this.labelId){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onFinish(AjaxRequestTarget target) {
                if (Strings.isEmpty((CharSequence)RedirectMessageDialog.this.url)) {
                    throw new RestartResponseException(Application.get().getHomePage());
                }
                throw new RedirectToUrlException(RedirectMessageDialog.this.url);
            }
        }});
        if (handler != null) {
            handler.add(new Component[]{this.getLabel()});
        }
    }

    public RedirectMessageDialog show(IPartialPageRequestHandler handler) {
        super.show(handler);
        this.startTimer(handler);
        return this;
    }

    protected Component createHeaderCloseButton(String id) {
        return super.createHeaderCloseButton(id).setVisible(false);
    }
}

