/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room;

import java.io.File;
import java.io.IOException;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.resource.FileSystemResource;
import org.apache.wicket.resource.FileSystemResourceReference;
import org.apache.wicket.util.string.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCustomCssResourceReference
extends FileSystemResourceReference {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "group-custom-css";
    private static final Logger log = LoggerFactory.getLogger(GroupCustomCssResourceReference.class);

    public GroupCustomCssResourceReference() {
        super(DEFAULT_NAME);
    }

    public GroupCustomCssResourceReference(String name) {
        super(name);
    }

    public IResource getResource() {
        return new FileSystemResource(){
            private static final long serialVersionUID = 1L;

            protected String getMimeType() throws IOException {
                return "text/css";
            }

            protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attr) {
                PageParameters params = attr.getParameters();
                StringValue idStr = params.get("id");
                Long id = null;
                try {
                    id = idStr.toOptionalLong();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                File file = OmFileHelper.getGroupCss((Long)id, (boolean)true);
                if (file != null) {
                    AbstractResource.ResourceResponse rr = this.createResourceResponse(attr, file.toPath());
                    rr.setFileName(file.getName());
                    return rr;
                }
                log.debug("Custom CSS was not found");
                return null;
            }
        };
    }
}

