/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.pages.auth;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.apache.openmeetings.core.mail.MailHandler;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.service.mail.template.ResetPasswordTemplate;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.common.Captcha;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.pages.ResetPage;
import org.apache.openmeetings.web.pages.auth.SignInDialog;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.validation.validator.RfcCompliantEmailAddressValidator;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.Validatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForgetPasswordDialog
extends Modal<String> {
    private static final Logger log = LoggerFactory.getLogger(ForgetPasswordDialog.class);
    private static final long serialVersionUID = 1L;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final IValidator<String> emailValidator = RfcCompliantEmailAddressValidator.getInstance();
    private final RequiredTextField<String> name = new RequiredTextField("name", (IModel)Model.of((Serializable)((Object)((String)null))));
    private final RadioGroup<Type> rg = new RadioGroup("type", (IModel)Model.of((Serializable)((Object)Type.email)));
    private final WebMarkupContainer label = new WebMarkupContainer("label");
    private final Captcha captcha = new Captcha("captcha");
    private ForgetPasswordForm form = new ForgetPasswordForm("form");
    private SignInDialog s;
    private final Modal<String> forgetInfoDialog;
    private boolean wasReset = false;
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private MailHandler mailHandler;

    public ForgetPasswordDialog(String id, Modal<String> forgetInfoDialog) {
        super(id);
        this.forgetInfoDialog = forgetInfoDialog;
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("312"));
        this.setUseCloseHandler(true);
        this.addButton((Component)new BootstrapAjaxButton("button", (IModel)new ResourceModel("317"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;
        });
        this.addButton((Component)OmModalCloseButton.of());
        this.add(new Component[]{this.form});
        super.onInitialize();
    }

    private void updateLabel(IPartialPageRequestHandler handler) {
        ResourceModel lbl = new ResourceModel(this.rg.getModelObject() == Type.email ? "315" : "316");
        this.name.setLabel((IModel)lbl);
        this.name.add(new Behavior[]{AttributeModifier.replace((String)"type", (Serializable)((Object)(this.rg.getModelObject() == Type.email ? "email" : "text")))});
        this.name.add(new Behavior[]{AttributeModifier.replace((String)"title", (IModel)lbl)});
        this.name.add(new Behavior[]{AttributeModifier.replace((String)"placeholder", (IModel)lbl)});
        this.label.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(this.rg.getModelObject() == Type.email ? "fa fa-at" : "fa fa-user")))});
        if (handler != null) {
            handler.add(new Component[]{this.name, this.label});
        }
    }

    public Modal<String> show(IPartialPageRequestHandler handler) {
        this.name.setModelObject(null);
        this.rg.setModelObject((Object)Type.email);
        this.captcha.refresh(handler);
        handler.add(new Component[]{this.rg});
        this.updateLabel(handler);
        this.wasReset = false;
        return super.show(handler);
    }

    public void onClose(IPartialPageRequestHandler handler) {
        if (this.wasReset) {
            this.forgetInfoDialog.show(handler);
        } else {
            this.s.show(handler);
        }
    }

    public void setSignInDialog(SignInDialog s) {
        this.s = s;
    }

    private boolean resetUser(String email, String username) {
        try {
            User us;
            log.debug("resetUser {}", (Object)email);
            if (!Strings.isEmpty((CharSequence)email)) {
                User us2 = this.userDao.getByEmail(email);
                if (us2 != null) {
                    this.sendHashByUser(us2);
                    return true;
                }
            } else if (!Strings.isEmpty((CharSequence)username) && (us = this.userDao.getByLogin(username, User.Type.USER, null)) != null) {
                this.sendHashByUser(us);
                return true;
            }
        }
        catch (Exception e) {
            log.error("[resetUser]", (Throwable)e);
        }
        return false;
    }

    private void sendHashByUser(User us) {
        log.debug("User: {}", (Object)us.getLogin());
        us.setResethash(UUID.randomUUID().toString());
        us.setResetDate(new Date());
        this.userDao.update(us, null);
        String resetLink = Application.urlForPage(ResetPage.class, new PageParameters().add("hash", (Object)us.getResethash()), OpenmeetingsVariables.getBaseUrl());
        String email = us.getAddress().getEmail();
        String template = ResetPasswordTemplate.getEmail((String)resetLink);
        this.mailHandler.send(email, Application.getString("517"), template);
    }

    private class ForgetPasswordForm
    extends Form<String> {
        private static final long serialVersionUID = 1L;

        public ForgetPasswordForm(String id) {
            super(id);
        }

        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{ForgetPasswordDialog.this.feedback.setOutputMarkupId(true)});
            this.add(new Component[]{ForgetPasswordDialog.this.label.setOutputMarkupId(true)});
            this.add(new Component[]{ForgetPasswordDialog.this.name.setOutputMarkupId(true)});
            this.add(new Component[]{ForgetPasswordDialog.this.captcha});
            this.add(new Component[]{ForgetPasswordDialog.this.rg.add(new Component[]{new Radio("email", (IModel)Model.of((Serializable)((Object)Type.email)))}).add(new Component[]{new Radio("login", (IModel)Model.of((Serializable)((Object)Type.login)))}).setOutputMarkupId(true)});
            ForgetPasswordDialog.this.rg.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    ForgetPasswordDialog.this.updateLabel((IPartialPageRequestHandler)target);
                }
            }});
            this.add(new Component[]{new AjaxButton("submit"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    ForgetPasswordForm.this.onSubmit(target);
                }

                protected void onError(AjaxRequestTarget target) {
                    ForgetPasswordForm.this.onError(target);
                }
            }});
            ForgetPasswordDialog.this.updateLabel(null);
        }

        protected void onValidate() {
            String n = (String)ForgetPasswordDialog.this.name.getConvertedInput();
            if (n != null) {
                Validatable val = new Validatable((Object)n);
                Type type = (Type)((Object)ForgetPasswordDialog.this.rg.getConvertedInput());
                if (type == Type.email) {
                    ForgetPasswordDialog.this.emailValidator.validate((IValidatable)val);
                    if (!val.isValid()) {
                        this.error((Serializable)((Object)this.getString("234")));
                    }
                }
                if (type == Type.login && n.length() < OpenmeetingsVariables.getMinLoginLength()) {
                    this.error((Serializable)((Object)this.getString("104")));
                }
            }
        }

        protected void onError() {
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(this::onError);
        }

        private void onError(AjaxRequestTarget target) {
            target.add(new Component[]{ForgetPasswordDialog.this.feedback});
        }

        protected void onSubmit() {
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(this::onSubmit);
        }

        private void onSubmit(AjaxRequestTarget target) {
            String nm = (String)ForgetPasswordDialog.this.name.getModelObject();
            Type type = (Type)((Object)ForgetPasswordDialog.this.rg.getModelObject());
            ForgetPasswordDialog.this.resetUser(type == Type.email ? nm : "", type == Type.login ? nm : "");
            ForgetPasswordDialog.this.wasReset = true;
            ForgetPasswordDialog.this.close((IPartialPageRequestHandler)target);
        }
    }

    static enum Type {
        email,
        login;

    }
}

