/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.pages;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5CssReference;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.common.HeaderPanel;
import org.apache.openmeetings.web.pages.NotInitedPage;
import org.apache.openmeetings.web.pages.install.InstallWizardPage;
import org.apache.openmeetings.web.util.OmUrlFragment;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.head.filter.FilteredHeaderItem;
import org.apache.wicket.markup.head.filter.HeaderResponseContainer;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.urlfragment.AsyncUrlFragmentAwarePage;

public abstract class BasePage
extends AsyncUrlFragmentAwarePage {
    private static final long serialVersionUID = 1L;
    public static final String ALIGN_LEFT = "align-left ";
    public static final String ALIGN_RIGHT = "align-right ";
    public static final String CUSTOM_CSS_FILTER = "customCSS";
    private final Map<String, String> options = new HashMap<String, String>();
    private HeaderPanel header;
    private final WebMarkupContainer loader = new WebMarkupContainer("main-loader"){
        private static final long serialVersionUID = 1L;

        public void renderHead(IHeaderResponse response) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(BasePage.class, "loader.css")));
        }
    };

    protected BasePage() {
        if (OpenmeetingsVariables.isInitComplete()) {
            if (!Application.isInstalled() && !(this instanceof InstallWizardPage)) {
                throw new RestartResponseException(InstallWizardPage.class);
            }
        } else {
            throw new RestartResponseException(NotInitedPage.class);
        }
        this.options.put("fragmentIdentifierSuffix", "");
        this.options.put("keyValueDelimiter", "/");
    }

    protected void onInitialize() {
        super.onInitialize();
        String appName = OpenmeetingsVariables.getApplicationName();
        String code = this.getLanguageCode();
        this.add(new Component[]{new TransparentWebMarkupContainer("html").add(new Behavior[]{AttributeModifier.replace((String)"xml:lang", (Serializable)((Object)code))}).add(new Behavior[]{AttributeModifier.replace((String)"lang", (Serializable)((Object)code))}).add(new Behavior[]{AttributeModifier.replace((String)"dir", (Serializable)((Object)(this.isRtl() ? "rtl" : "ltr")))})});
        this.add(new Component[]{new Label("pageTitle", (Serializable)((Object)appName))});
        Component[] componentArray = new Component[1];
        this.header = new HeaderPanel("header", appName);
        componentArray[0] = this.header;
        this.add(componentArray);
        this.add(new Component[]{this.loader.setVisible(this.isMainPage()).setOutputMarkupPlaceholderTag(true).setOutputMarkupId(true)});
        this.add(new Component[]{new HeaderResponseContainer(CUSTOM_CSS_FILTER, CUSTOM_CSS_FILTER)});
    }

    public abstract boolean isRtl();

    protected abstract String getLanguageCode();

    protected OmUrlFragment getUrlFragment(IRequestParameters params) {
        for (OmUrlFragment.AreaKeys key : OmUrlFragment.AreaKeys.values()) {
            StringValue type = params.getParameterValue(key.name());
            if (type.isEmpty()) continue;
            return new OmUrlFragment(key, type.toString());
        }
        return null;
    }

    public HeaderPanel getHeader() {
        return this.header;
    }

    protected Map<String, String> getOptions() {
        return this.options;
    }

    protected boolean isMainPage() {
        return false;
    }

    protected void internalRenderHead(IHeaderResponse response) {
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Application.get().getJavaScriptLibrarySettings().getJQueryReference())));
        super.renderHead(response);
        String suffix = RuntimeConfigurationType.DEVELOPMENT == this.getApplication().getConfigurationType() ? "" : ".min";
        response.render((HeaderItem)CssHeaderItem.forUrl((String)String.format("css/theme_om/jquery-ui%s.css", suffix)));
        response.render((HeaderItem)CssHeaderItem.forUrl((String)"css/theme.css"));
        if (!Strings.isEmpty((CharSequence)OpenmeetingsVariables.getGaCode())) {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(BasePage.class, "om-ga.js"){
                private static final long serialVersionUID = 1L;

                public List<HeaderItem> getDependencies() {
                    return List.of(new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forUrl((String)("https://www.googletagmanager.com/gtag/js?id=" + OpenmeetingsVariables.getGaCode())).setAsync(true)));
                }
            })));
            StringBuilder script = new StringBuilder("initGA('").append(OpenmeetingsVariables.getGaCode()).append("', ").append(this.isMainPage()).append(");");
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)script));
        }
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)FontAwesome5CssReference.instance()));
        response.render((HeaderItem)new FilteredHeaderItem((HeaderItem)CssHeaderItem.forUrl((String)"css/custom.css"), CUSTOM_CSS_FILTER));
    }

    public void renderHead(IHeaderResponse response) {
        this.internalRenderHead(response);
    }

    public WebMarkupContainer getLoader() {
        return this.loader;
    }
}

