/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common.tree;

import com.github.openjson.JSONObject;
import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.interaction.draggable.DraggableBehavior;
import com.googlecode.wicket.jquery.ui.interaction.draggable.IDraggableListener;
import com.googlecode.wicket.jquery.ui.interaction.droppable.DroppableBehavior;
import com.googlecode.wicket.jquery.ui.interaction.droppable.IDroppableListener;
import java.io.Serializable;
import java.util.Map;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.web.common.tree.FileTreePanel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxEditableLabel;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;

public class FolderPanel
extends Panel
implements IDraggableListener,
IDroppableListener {
    private static final long serialVersionUID = 1L;
    private static final String CSS_CLASS_FILE = "file ";
    private static final String PARAM_MOD = "mod";
    private static final String PARAM_SHIFT = "s";
    private static final String PARAM_CTRL = "c";
    private final StyleBehavior styleClass;
    private final FileTreePanel treePanel;
    @SpringBean
    private RecordingDao recDao;
    @SpringBean
    private FileItemDao fileDao;

    public FolderPanel(String id, IModel<BaseFileItem> model, FileTreePanel treePanel) {
        super(id, model);
        this.treePanel = treePanel;
        this.styleClass = new StyleBehavior();
    }

    protected void onInitialize() {
        super.onInitialize();
        final BaseFileItem f = (BaseFileItem)this.getDefaultModelObject();
        boolean editable = this.treePanel.isEditable() && !f.isReadOnly();
        String selector = IJQueryWidget.JQueryWidget.getSelector((Component)this);
        if (f.getType() == BaseFileItem.Type.FOLDER && editable) {
            this.add(new Behavior[]{new DroppableBehavior(selector, new Options().set("hoverClass", (Object)Options.asString((String)"bg-light")).set("accept", (Object)Options.asString((String)(this.getDefaultModelObject() instanceof Recording ? ".recorditem" : ".fileitem"))), (IDroppableListener)this)});
        }
        if (f.getId() != null && this.treePanel.isEditable()) {
            this.add(new Behavior[]{new DraggableBehavior(selector, new Options().set("revert", (Object)"OmFileTree.treeRevert").set("cursor", (Object)Options.asString((String)"move")).set("helper", (Object)"OmFileTree.dragHelper").set("cursorAt", (Object)"{left: 40, top: 18}").set("containment", (Object)Options.asString((String)this.treePanel.getContainment())), (IDraggableListener)this)});
        }
        Object name = f.getId() == null || !editable ? new Label("name", (Serializable)((Object)f.getName())) : new AjaxEditableLabel<String>("name", (IModel)Model.of((Serializable)((Object)f.getName()))){
            private static final long serialVersionUID = 1L;

            protected String getLabelAjaxEvent() {
                return "dblclick";
            }

            protected void onSubmit(AjaxRequestTarget target) {
                super.onSubmit(target);
                f.setName((String)this.getEditor().getModelObject());
                if (f instanceof Recording) {
                    FolderPanel.this.recDao.update((Recording)f);
                } else {
                    FolderPanel.this.fileDao.update((FileItem)f);
                }
            }
        };
        this.add(new Component[]{name});
        this.add(new Behavior[]{AttributeModifier.append((String)"title", (Serializable)((Object)f.getName()))});
        this.add(new Behavior[]{this.styleClass});
        this.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            public void onEvent(AjaxRequestTarget target) {
                FolderPanel.this.onClick(target, f);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getDynamicExtraParameters().add(String.format("return {%s: JSON.stringify({%s: attrs.event.shiftKey, %s: attrs.event.ctrlKey})};", FolderPanel.PARAM_MOD, FolderPanel.PARAM_SHIFT, FolderPanel.PARAM_CTRL));
            }
        }});
    }

    private void moveAll(AjaxRequestTarget target, BaseFileItem p) {
        for (Map.Entry<String, BaseFileItem> e : this.treePanel.getSelected().entrySet()) {
            this.move(target, p, e.getValue());
        }
    }

    private void move(AjaxRequestTarget target, BaseFileItem p, BaseFileItem f) {
        Long pid = p.getId();
        if (pid != null && pid.equals(f.getId())) {
            return;
        }
        f.setParentId(pid);
        f.setOwnerId(p.getOwnerId());
        f.setRoomId(p.getRoomId());
        f.setGroupId(p.getGroupId());
        if (f instanceof Recording) {
            this.recDao.update((Recording)f);
        } else {
            this.fileDao.update((FileItem)f);
        }
        this.treePanel.updateNode(target, f);
    }

    private void onClick(AjaxRequestTarget target, BaseFileItem f) {
        String mod = this.getRequest().getRequestParameters().getParameterValue(PARAM_MOD).toOptionalString();
        boolean shift = false;
        boolean ctrl = false;
        if (!Strings.isEmpty((CharSequence)mod)) {
            JSONObject o = new JSONObject(mod);
            shift = o.optBoolean(PARAM_SHIFT);
            ctrl = o.optBoolean(PARAM_CTRL);
        }
        this.treePanel.select(f, target, shift, ctrl);
        if (BaseFileItem.Type.FOLDER == f.getType() && this.treePanel.tree.getState(f) == AbstractTree.State.COLLAPSED) {
            this.treePanel.tree.expand(f);
        } else {
            this.treePanel.update(target, f);
        }
    }

    private CharSequence getItemStyle() {
        BaseFileItem f = (BaseFileItem)this.getDefaultModelObject();
        boolean open = AbstractTree.State.EXPANDED == this.treePanel.tree.getState(f);
        StringBuilder style = new StringBuilder("big om-icon ");
        if (f.getId() == null) {
            style.append(CSS_CLASS_FILE).append(f.getHash().indexOf("my") > -1 ? "my " : "public ");
        } else {
            if (BaseFileItem.Type.FOLDER != f.getType() && !f.exists()) {
                style.append("broken ");
            }
            switch (f.getType()) {
                case FOLDER: {
                    style.append(CSS_CLASS_FILE).append(open ? "folder-open " : "folder ");
                    break;
                }
                case IMAGE: {
                    style.append(CSS_CLASS_FILE).append("image ");
                    break;
                }
                case POLL_CHART: {
                    style.append(CSS_CLASS_FILE).append("chart ");
                    break;
                }
                case WML_FILE: {
                    style.append(CSS_CLASS_FILE).append("wml ");
                    break;
                }
                case VIDEO: 
                case RECORDING: {
                    this.setVideoStyle(f, style);
                    break;
                }
                case PRESENTATION: {
                    style.append(CSS_CLASS_FILE).append("doc ");
                    break;
                }
            }
        }
        if (this.treePanel.isSelected(f)) {
            style.append("active ");
        }
        String cls = f instanceof Recording ? "recorditem " : "fileitem ";
        style.append(f.isReadOnly() ? "readonlyitem " : cls);
        return style;
    }

    private void setVideoStyle(BaseFileItem f, StringBuilder style) {
        Recording.Status st;
        style.append("recording ");
        if (f instanceof Recording && (Recording.Status.RECORDING == (st = ((Recording)f).getStatus()) || Recording.Status.CONVERTING == st)) {
            style.append("processing ");
        }
    }

    public boolean isStopEventEnabled() {
        return false;
    }

    public void onDragStart(AjaxRequestTarget target, int top, int left) {
    }

    public void onDragStop(AjaxRequestTarget target, int top, int left) {
    }

    public boolean isOverEventEnabled() {
        return false;
    }

    public boolean isExitEventEnabled() {
        return false;
    }

    public void onOver(AjaxRequestTarget target, Component component) {
    }

    public void onExit(AjaxRequestTarget target, Component component) {
    }

    public void onDrop(AjaxRequestTarget target, Component component) {
        Object o = component.getDefaultModelObject();
        if (o instanceof BaseFileItem) {
            BaseFileItem p = (BaseFileItem)this.getDefaultModelObject();
            BaseFileItem f = (BaseFileItem)o;
            if (this.treePanel.isSelected(f)) {
                this.moveAll(target, p);
            } else {
                this.move(target, p, f);
            }
            this.treePanel.updateNode(target, p);
        }
        target.add(new Component[]{this.treePanel.trees});
    }

    private class StyleBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        private StyleBehavior() {
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            tag.put("class", FolderPanel.this.getItemStyle());
        }
    }
}

