/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common.datetime;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.AbstractDateTimePickerWithIcon;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerIconConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconType;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.model.ChainingModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class AbstractOmDateTimePicker<T extends Serializable>
extends FormComponentPanel<T> {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private static final ResourceReference FUNCJS = new JavaScriptResourceReference(AbstractOmDateTimePicker.class, "datepicker-functions.js");
    private final boolean dateOnly;
    private final HiddenField<T> date;
    private AbstractDateTimePickerWithIcon<T> picker;
    private String markupId;

    AbstractOmDateTimePicker(String id, IModel<T> model, boolean dateOnly) {
        super(id, model);
        this.dateOnly = dateOnly;
        this.date = this.newHidden("date", (IModel<T>)new ChainingModel(model));
    }

    protected void onInitialize() {
        super.onInitialize();
        String format = this.dateOnly ? AbstractOmDateTimePicker.getDateFormat() : AbstractOmDateTimePicker.getDateTimeFormat();
        DatetimePickerConfig config = new DatetimePickerConfig().useLocale(WebSession.get().getLocale().toLanguageTag()).withFormat(AbstractOmDateTimePicker.patch(format)).withKeepInvalid(true).with(new DatetimePickerIconConfig().useDateIcon((IconType)FontAwesome5IconType.calendar_s).useTimeIcon((IconType)FontAwesome5IconType.clock_s).useUpIcon((IconType)FontAwesome5IconType.arrow_up_s).useDownIcon((IconType)FontAwesome5IconType.arrow_down_s).usePreviousIcon((IconType)FontAwesome5IconType.arrow_left_s).useNextIcon((IconType)FontAwesome5IconType.arrow_right_s).useTodayIcon((IconType)FontAwesome5IconType.calendar_check_s).useClearIcon((IconType)FontAwesome5IconType.eraser_s).useCloseIcon((IconType)FontAwesome5IconType.times_s));
        this.picker = new AbstractDateTimePickerWithIcon<T>("picker", (IModel)new Model((Serializable)this.getModelObject()), config){
            private static final long serialVersionUID = 1L;

            protected FormComponent<T> newInput(String wicketId, String dateFormat) {
                FormComponent input = AbstractOmDateTimePicker.this.newInput(wicketId, dateFormat);
                AbstractOmDateTimePicker.this.markupId = input.getMarkupId();
                return input;
            }
        };
        this.date.setOutputMarkupId(true);
        this.add(new Component[]{this.date, this.picker.setRenderBodyOnly(false)});
    }

    public void convertInput() {
        this.date.convertInput();
        if (this.date.isValid()) {
            this.setConvertedInput((Serializable)this.date.getConvertedInput());
        } else {
            this.date.getFeedbackMessages().forEach(msg -> this.getFeedbackMessages().add(msg));
            this.date.getFeedbackMessages().clear();
        }
    }

    protected abstract FormComponent<T> newInput(String var1, String var2);

    protected abstract HiddenField<T> newHidden(String var1, IModel<T> var2);

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)FUNCJS));
        response.render((HeaderItem)new OnDomReadyHeaderItem((CharSequence)("$('#" + this.markupId + "').on('change.datetimepicker', function (e) {omDateTimeInputHasChanged(e, '" + this.date.getMarkupId() + "', " + this.dateOnly + ");});")));
    }

    public boolean processChildren() {
        return false;
    }

    public static String patch(String format) {
        return format.replaceAll("[']{1}([^']*)[']{1}", "\\[$1\\]");
    }

    public static String getDateTimeFormat() {
        return AbstractOmDateTimePicker.getDateTimeFormat(WebSession.get().getLocale());
    }

    public FormComponent<T> setLabel(IModel<String> labelModel) {
        this.date.setLabel(labelModel);
        return this;
    }

    protected void onModelChanged() {
        this.picker.setModelObject((Object)((Serializable)this.getModelObject()));
    }

    public static String getDateTimeFormat(Locale loc) {
        DateFormat fmt = DateFormat.getDateTimeInstance(3, 3, loc);
        if (fmt instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)fmt).toPattern();
        }
        return DEFAULT_DATE_TIME_FORMAT;
    }

    public static String getDateFormat() {
        DateFormat fmt = DateFormat.getDateInstance(3, Session.get().getLocale());
        if (fmt instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)fmt).toPattern();
        }
        return DEFAULT_DATE_FORMAT;
    }
}

