/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.oauth;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconType;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.openmeetings.db.dao.server.OAuth2Dao;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.web.admin.AdminBaseForm;
import org.apache.openmeetings.web.app.UserManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;

public class OAuthForm
extends AdminBaseForm<OAuthServer> {
    private static final long serialVersionUID = 1L;
    private WebMarkupContainer listContainer;
    private final WebMarkupContainer attrsContainer = new WebMarkupContainer("attrsContainer");
    private TextField<String> redirectUriText;
    private final ListView<Map.Entry<String, String>> mappingView = new ListView<Map.Entry<String, String>>("mapping", (IModel)new ListModel(new ArrayList())){
        private static final long serialVersionUID = 1L;

        protected void populateItem(ListItem<Map.Entry<String, String>> item) {
            final Map.Entry entry = (Map.Entry)item.getModelObject();
            BootstrapAjaxLink<String> del = new BootstrapAjaxLink<String>("delete", Buttons.Type.Outline_Danger){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    OAuthServer s = (OAuthServer)OAuthForm.this.getModelObject();
                    s.getMapping().remove(entry.getKey());
                    OAuthForm.this.updateMapping();
                    target.add(new Component[]{OAuthForm.this.attrsContainer});
                }
            };
            del.setIconType((IconType)FontAwesome5IconType.times_s).add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))});
            item.add(new Component[]{new Label("key", (IModel)Model.of((Serializable)((Object)((String)entry.getKey()))))}).add(new Component[]{new Label("value", (IModel)Model.of((Serializable)((Object)((String)entry.getValue()))))}).add(new Component[]{del});
        }
    };
    @SpringBean
    private OAuth2Dao oauthDao;

    public OAuthForm(String id, WebMarkupContainer listContainer, OAuthServer server) {
        super(id, new CompoundPropertyModel((Object)server));
        this.listContainer = listContainer;
        this.setOutputMarkupId(true);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new CheckBox("isEnabled")});
        this.add(new Component[]{new RequiredTextField("name").setLabel((IModel)new ResourceModel("165"))});
        this.add(new Component[]{new TextField("iconUrl").setLabel((IModel)new ResourceModel("1575"))});
        this.add(new Component[]{new RequiredTextField("clientId").setLabel((IModel)Model.of((Serializable)((Object)"client_id")))});
        this.add(new Component[]{new RequiredTextField("clientSecret").setLabel((IModel)Model.of((Serializable)((Object)"client_secret")))});
        Component[] componentArray = new Component[1];
        this.redirectUriText = (TextField)new TextField("redirectUri", (IModel)Model.of((Serializable)((Object)""))).setLabel((IModel)new ResourceModel("1587"));
        componentArray[0] = this.redirectUriText;
        this.add(componentArray);
        this.add(new Component[]{new RequiredTextField("requestKeyUrl").setLabel((IModel)new ResourceModel("1578"))});
        this.add(new Component[]{new DropDownChoice("requestTokenMethod", List.of(OAuthServer.RequestTokenMethod.values()), (IChoiceRenderer)new ChoiceRenderer("name", "name"))});
        this.add(new Component[]{new RequiredTextField("requestTokenUrl").setLabel((IModel)new ResourceModel("1579"))});
        this.add(new Component[]{new RequiredTextField("requestTokenAttributes").setLabel((IModel)new ResourceModel("1586"))});
        this.add(new Component[]{new RequiredTextField("requestInfoUrl").setLabel((IModel)new ResourceModel("1580"))});
        this.add(new Component[]{new DropDownChoice("requestInfoMethod", List.of(OAuthServer.RequestInfoMethod.values()), (IChoiceRenderer)new ChoiceRenderer("name", "name"))});
        final Form mappingForm = new Form("mappingForm");
        final TextField omAttr = new TextField("omAttr", (IModel)Model.of((Serializable)((Object)"")));
        final TextField oauthAttr = new TextField("oauthAttr", (IModel)Model.of((Serializable)((Object)"")));
        this.add(new Component[]{mappingForm.add(new Component[]{omAttr, oauthAttr, new BootstrapAjaxButton("addMapping", (IModel)new ResourceModel("1261"), mappingForm, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                if (Strings.isEmpty((CharSequence)((CharSequence)omAttr.getModelObject())) || Strings.isEmpty((CharSequence)((CharSequence)oauthAttr.getModelObject()))) {
                    return;
                }
                OAuthServer s = (OAuthServer)OAuthForm.this.getModelObject();
                s.addMapping((String)omAttr.getModelObject(), (String)oauthAttr.getModelObject());
                OAuthForm.this.updateMapping();
                target.add(new Component[]{OAuthForm.this.attrsContainer, mappingForm});
            }
        }}).setOutputMarkupId(true)});
        this.add(new Component[]{this.attrsContainer.add(new Component[]{this.updateMapping()}).setOutputMarkupId(true)});
        this.setNewRecordVisible(true);
    }

    private Component updateMapping() {
        this.mappingView.setModelObject(((OAuthServer)this.getModelObject()).getMapping().entrySet().stream().map(AbstractMap.SimpleEntry::new).collect(Collectors.toList()));
        return this.mappingView;
    }

    protected void onModelChanged() {
        super.onModelChanged();
        this.redirectUriText.setModelObject((Object)UserManager.getRedirectUri((OAuthServer)this.getModelObject()));
        this.updateMapping();
    }

    @Override
    protected void onSaveSubmit(AjaxRequestTarget target, Form<?> form) {
        this.oauthDao.update((OAuthServer)this.getModelObject(), WebSession.getUserId());
        OAuthServer oauthServer = this.oauthDao.get(((OAuthServer)this.getModelObject()).getId());
        this.setModelObject(oauthServer);
        this.setNewRecordVisible(false);
        target.add(new Component[]{this});
        target.add(new Component[]{this.listContainer});
    }

    @Override
    protected void onNewSubmit(AjaxRequestTarget target, Form<?> form) {
        this.setModelObject(new OAuthServer());
        target.add(new Component[]{this});
    }

    @Override
    protected void onRefreshSubmit(AjaxRequestTarget target, Form<?> form) {
        OAuthServer server = (OAuthServer)this.getModelObject();
        server = server.getId() != null ? this.oauthDao.get(((OAuthServer)this.getModelObject()).getId()) : new OAuthServer();
        this.setModelObject(server);
        target.add(new Component[]{this});
    }

    @Override
    protected void onDeleteSubmit(AjaxRequestTarget target, Form<?> form) {
        this.oauthDao.delete((OAuthServer)this.getModelObject(), WebSession.getUserId());
        this.setModelObject(new OAuthServer());
        target.add(new Component[]{this.listContainer});
        target.add(new Component[]{this});
    }
}

