/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.groups;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import org.apache.openmeetings.core.converter.ImageConverter;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.GroupUserDao;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.StoredFile;
import org.apache.openmeetings.web.admin.AdminBaseForm;
import org.apache.openmeetings.web.admin.AdminUserChoiceProvider;
import org.apache.openmeetings.web.admin.groups.GroupUsersPanel;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.UploadableImagePanel;
import org.apache.openmeetings.web.util.GroupLogoResourceReference;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.NumberTextField;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Select2Choice;

public class GroupForm
extends AdminBaseForm<Group> {
    private static final long serialVersionUID = 1L;
    private GroupUsersPanel usersPanel;
    private final WebMarkupContainer groupList;
    private final Select2Choice<User> userToadd;
    private final NumberTextField<Integer> maxFilesSize = new NumberTextField("maxFilesSize");
    private final NumberTextField<Integer> maxRecordingsSize = new NumberTextField("maxRecordingsSize");
    private final NumberTextField<Integer> maxRooms = new NumberTextField("maxRooms");
    private final NumberTextField<Integer> recordingTtl = new NumberTextField("recordingTtl");
    private final NumberTextField<Integer> reminderDays = new NumberTextField("reminderDays");
    private final NumberTextField<Integer> notifyInterval = new NumberTextField("notifyInterval");
    private final UploadableImagePanel logo = new UploadableImagePanel("logo", true){
        private static final long serialVersionUID = 1L;

        @Override
        protected String getImageUrl() {
            return GroupLogoResourceReference.getUrl(this.getRequestCycle(), ((Group)GroupForm.this.getModelObject()).getId());
        }

        @Override
        protected void processImage(StoredFile sf, File f) throws Exception {
            GroupForm.this.imageConverter.resize(f, OmFileHelper.getGroupLogo((Long)((Group)GroupForm.this.getModelObject()).getId(), (boolean)false), null, Integer.valueOf(28));
        }

        @Override
        protected void deleteImage() throws Exception {
            Long groupId = ((Group)GroupForm.this.getModelObject()).getId();
            File flogo = new File(OmFileHelper.getGroupLogoDir(), String.format("logo%s.png", groupId));
            if (groupId != null && flogo.exists()) {
                flogo.delete();
            }
        }

        @Override
        protected String getTitle() {
            return this.getString("admin.group.form.logo");
        }
    };
    @SpringBean
    private ImageConverter imageConverter;
    @SpringBean
    private GroupUserDao groupUserDao;
    @SpringBean
    private GroupDao groupDao;

    public GroupForm(String id, WebMarkupContainer groupList, Group group) {
        super(id, new CompoundPropertyModel((Object)group));
        this.setMultiPart(true);
        this.groupList = groupList;
        this.setOutputMarkupId(true);
        this.usersPanel = new GroupUsersPanel("users", this.getGroupId());
        this.add(new Component[]{this.usersPanel});
        Component[] componentArray = new Component[1];
        this.userToadd = new Select2Choice("user2add", (IModel)Model.of((Serializable)((User)null)), (ChoiceProvider)new AdminUserChoiceProvider(){
            private static final long serialVersionUID = 1L;

            public String getDisplayValue(User choice) {
                return GroupForm.formatUser(choice);
            }
        });
        componentArray[0] = this.userToadd;
        this.add(componentArray);
        this.userToadd.add(new Behavior[]{AjaxFormComponentUpdatingBehavior.onUpdate((String)"change", (SerializableConsumer & Serializable)target -> {
            Group o = (Group)this.getModelObject();
            User u = (User)this.userToadd.getModelObject();
            boolean found = false;
            if (o.getId() != null) {
                boolean bl = found = null != this.groupUserDao.getByGroupAndUser(o.getId(), u.getId());
            }
            if (!found && u != null) {
                for (GroupUser ou : this.usersPanel.getUsers2add()) {
                    if (!ou.getUser().getId().equals(u.getId())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    GroupUser ou = new GroupUser(o, u);
                    this.usersPanel.getUsers2add().add(ou);
                    this.userToadd.setModelObject(null);
                    target.add(new Component[]{this.usersPanel, this.userToadd});
                }
            }
        })});
    }

    static String formatUser(User choice) {
        return String.format("%s [%s]", choice.getLogin(), choice.getDisplayName());
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        boolean isGroupAdmin = AuthLevelUtil.hasGroupAdminLevel(WebSession.getRights());
        this.setNewVisible(!isGroupAdmin);
        this.setNewRecordVisible(!isGroupAdmin);
        this.userToadd.setEnabled(!isGroupAdmin);
        this.add(new Component[]{new RequiredTextField("name").setLabel((IModel)new ResourceModel("165"))});
        this.add(new Component[]{this.logo});
        this.add(new Component[]{new TextField("tag").setLabel((IModel)new ResourceModel("admin.group.form.tag"))});
        this.add(new Component[]{new CheckBox("restricted").setLabel((IModel)new ResourceModel("restricted.group.files"))});
        this.add(new Component[]{new AjaxCheckBox("limited"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{GroupForm.this.maxFilesSize.setEnabled(((Boolean)this.getModelObject()).booleanValue()), GroupForm.this.maxRecordingsSize.setEnabled(((Boolean)this.getModelObject()).booleanValue()), GroupForm.this.maxRooms.setEnabled(((Boolean)this.getModelObject()).booleanValue()), GroupForm.this.recordingTtl.setEnabled(((Boolean)this.getModelObject()).booleanValue()), GroupForm.this.reminderDays.setEnabled(((Boolean)this.getModelObject()).booleanValue())});
            }
        }.setLabel((IModel)new ResourceModel("admin.group.form.limited"))});
        this.add(new Component[]{this.maxFilesSize.setLabel((IModel)new ResourceModel("admin.group.form.maxFilesSize")).setEnabled(false).setOutputMarkupId(true)});
        this.add(new Component[]{this.maxRecordingsSize.setLabel((IModel)new ResourceModel("admin.group.form.maxRecordingsSize")).setEnabled(false).setOutputMarkupId(true)});
        this.add(new Component[]{this.maxRooms.setLabel((IModel)new ResourceModel("admin.group.form.maxRooms")).setEnabled(false).setOutputMarkupId(true)});
        this.add(new Component[]{this.recordingTtl.setLabel((IModel)new ResourceModel("admin.group.form.recordingTtl")).setEnabled(false).setOutputMarkupId(true)});
        this.add(new Component[]{this.reminderDays.setLabel((IModel)new ResourceModel("admin.group.form.reminderDays")).setEnabled(false).setOutputMarkupId(true)});
        this.add(new Component[]{this.notifyInterval.setLabel((IModel)new ResourceModel("admin.group.new.users.notification.interval"))});
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setDelVisible(!AuthLevelUtil.hasGroupAdminLevel(WebSession.getRights()));
    }

    public void updateView(AjaxRequestTarget target) {
        this.userToadd.setModelObject(null);
        this.usersPanel.update(this.getGroupId());
        this.maxFilesSize.setEnabled(((Group)this.getModelObject()).isLimited());
        this.maxRecordingsSize.setEnabled(((Group)this.getModelObject()).isLimited());
        this.maxRooms.setEnabled(((Group)this.getModelObject()).isLimited());
        this.recordingTtl.setEnabled(((Group)this.getModelObject()).isLimited());
        this.reminderDays.setEnabled(((Group)this.getModelObject()).isLimited());
        this.notifyInterval.setModelObject((Object)((Group)this.getModelObject()).getNotifyInterval());
        this.logo.update();
        target.add(new Component[]{this, this.groupList});
    }

    private long getGroupId() {
        return ((Group)this.getModelObject()).getId() != null ? ((Group)this.getModelObject()).getId() : 0L;
    }

    @Override
    protected void onNewSubmit(AjaxRequestTarget target, Form<?> f) {
        this.setModelObject(new Group());
        this.updateView(target);
    }

    @Override
    protected void onRefreshSubmit(AjaxRequestTarget target, Form<?> form) {
        Group org = (Group)this.getModelObject();
        org = org.getId() != null ? this.groupDao.get(org.getId()) : new Group();
        this.setModelObject(org);
        this.updateView(target);
    }

    @Override
    protected void onDeleteSubmit(AjaxRequestTarget target, Form<?> form) {
        this.groupDao.delete((Group)this.getModelObject(), WebSession.getUserId());
        this.setModelObject(new Group());
        this.updateView(target);
    }

    @Override
    protected void onSaveSubmit(AjaxRequestTarget target, Form<?> form) {
        Group o = (Group)this.getModelObject();
        o = this.groupDao.update(o, WebSession.getUserId());
        this.setModelObject(o);
        for (GroupUser grpUser : this.usersPanel.getUsers2add()) {
            this.usersPanel.update(grpUser);
        }
        this.logo.process(Optional.of(target));
        this.setNewRecordVisible(false);
        this.updateView(target);
    }
}

