/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.backup;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.progress.UpdatableProgressBar;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.BackgroundColorBehavior;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.openmeetings.backup.BackupExport;
import org.apache.openmeetings.backup.BackupImport;
import org.apache.openmeetings.backup.ProgressHolder;
import org.apache.openmeetings.util.CalendarPatterns;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.admin.AdminBasePanel;
import org.apache.openmeetings.web.util.ThreadHelper;
import org.apache.openmeetings.web.util.upload.BootstrapFileUploadBehavior;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.AjaxDownloadBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.resource.FileSystemResource;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthorizeInstantiation(value={"ADMIN", "ADMIN_BACKUP"})
public class BackupPanel
extends AdminBasePanel {
    private static final Logger log = LoggerFactory.getLogger(BackupPanel.class);
    private static final long serialVersionUID = 1L;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    @SpringBean
    private BackupExport backupExport;
    @SpringBean
    private BackupImport backupImport;

    public BackupPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.feedback.setOutputMarkupId(true)});
        this.add(new Component[]{new BackupForm("backupUpload")});
        this.add(new Behavior[]{BootstrapFileUploadBehavior.INSTANCE});
    }

    private class BackupForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;
        private final Model<Boolean> includeFilesInBackup;
        private final FileUploadField fileUploadField;
        private UpdatableProgressBar progressBar;
        private File backupFile;
        private Throwable th;
        private boolean modeDownload;
        private final ProgressHolder progressHolder;
        private BootstrapAjaxButton download;
        private final WebMarkupContainer upload;

        public BackupForm(String id) {
            super(id);
            this.includeFilesInBackup = Model.of((Serializable)Boolean.valueOf(true));
            this.fileUploadField = new FileUploadField("fileInput", (IModel)new IModel<List<FileUpload>>(){
                private static final long serialVersionUID = 1L;

                public void setObject(List<FileUpload> object) {
                }

                public List<FileUpload> getObject() {
                    return new ArrayList<FileUpload>();
                }
            }){
                private static final long serialVersionUID = 1L;

                protected boolean forceCloseStreamsOnDetach() {
                    return false;
                }
            };
            this.th = null;
            this.modeDownload = false;
            this.progressHolder = new ProgressHolder();
            this.upload = new WebMarkupContainer("upload");
            this.setMultiPart(true);
        }

        protected void onInitialize() {
            Long maxBytes = OpenmeetingsVariables.getMaxUploadSize();
            double megaBytes = maxBytes.doubleValue() / 1024.0 / 1024.0;
            DecimalFormat formatter = new DecimalFormat("#,###.00");
            this.add(new Component[]{new Label("MaxUploadSize", (Serializable)((Object)formatter.format(megaBytes)))});
            this.add(new Component[]{new CheckBox("includeFilesInBackup", this.includeFilesInBackup).setOutputMarkupId(true)});
            this.setMaxSize(Bytes.bytes((long)maxBytes));
            final AjaxDownloadBehavior downloader = new AjaxDownloadBehavior(new IResource(){
                private static final long serialVersionUID = 1L;

                public void respond(IResource.Attributes attributes) {
                    new FileSystemResource(BackupForm.this.backupFile.toPath()){
                        private static final long serialVersionUID = 1L;

                        protected AbstractResource.ResourceResponse createResourceResponse(IResource.Attributes attr, Path path) {
                            AbstractResource.ResourceResponse response = super.createResourceResponse(attr, path);
                            response.setCacheDuration(Duration.ZERO);
                            return response;
                        }
                    }.respond(attributes);
                }
            });
            this.add(new Behavior[]{downloader});
            Component[] componentArray = new Component[1];
            this.download = new BootstrapAjaxButton("download", (IModel)new ResourceModel("1066"), this, Buttons.Type.Outline_Primary){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    BackupForm.this.modeDownload = true;
                    String dateString = "backup_" + CalendarPatterns.getTimeForStreamId((Date)new Date());
                    BackupForm.this.backupFile = new File(OmFileHelper.getUploadBackupDir(), dateString + ".zip");
                    BackupForm.this.startWithProgress(() -> {
                        try {
                            BackupPanel.this.backupExport.performExport(BackupForm.this.backupFile, ((Boolean)BackupForm.this.includeFilesInBackup.getObject()).booleanValue(), BackupForm.this.progressHolder);
                        }
                        catch (Exception e) {
                            log.error("Exception on panel backup download ", (Throwable)e);
                            BackupForm.this.th = e;
                        }
                    }, dateString, target);
                }

                protected void onError(AjaxRequestTarget target) {
                    target.add(new Component[]{BackupPanel.this.feedback});
                }
            };
            componentArray[0] = this.download;
            this.add(componentArray);
            Component[] componentArray2 = new Component[1];
            this.progressBar = new UpdatableProgressBar("progress", (IModel)new Model((Serializable)Integer.valueOf(0)), BackgroundColorBehavior.Color.Info, true){
                private static final long serialVersionUID = 1L;

                protected IModel<Integer> newValue() {
                    return Model.of((Serializable)Integer.valueOf(BackupForm.this.progressHolder.getProgress()));
                }

                protected void onPostProcessTarget(IPartialPageRequestHandler target) {
                    if (BackupForm.this.th != null) {
                        this.stop(target);
                        BackupPanel.this.feedback.error((Serializable)((Object)BackupForm.this.th.getMessage()));
                        this.onComplete(target);
                    }
                    super.onPostProcessTarget(target);
                }

                protected void onComplete(IPartialPageRequestHandler target) {
                    BackupForm.this.progressBar.setVisible(false);
                    target.add(new Component[]{BackupPanel.this.feedback});
                    BackupForm.this.updateButtons(target, true);
                    if (BackupForm.this.modeDownload) {
                        downloader.initiate(target);
                    }
                    super.onComplete(target);
                }
            };
            componentArray2[0] = this.progressBar;
            this.add(componentArray2);
            this.progressBar.updateInterval(Duration.ofSeconds(1L)).stop(null).striped(false).setVisible(false).setOutputMarkupPlaceholderTag(true);
            this.upload.add(new Component[]{this.fileUploadField.add(new Behavior[]{new AjaxFormSubmitBehavior(this, "change"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    FileUpload upload = BackupForm.this.fileUploadField.getFileUpload();
                    BackupForm.this.modeDownload = false;
                    try {
                        BackupForm.this.startWithProgress(() -> {
                            try {
                                if (upload == null || upload.getInputStream() == null) {
                                    BackupPanel.this.feedback.error((Serializable)((Object)"File is empty"));
                                    target.add(new Component[]{BackupPanel.this.feedback});
                                    return;
                                }
                                BackupPanel.this.backupImport.performImport(upload.getInputStream(), BackupForm.this.progressHolder);
                                BackupPanel.this.feedback.success((Serializable)((Object)(BackupForm.this.getString("387") + " - " + BackupForm.this.getString("54"))));
                            }
                            catch (Exception e) {
                                log.error("Exception on panel backup download ", (Throwable)e);
                                BackupForm.this.th = e;
                            }
                            finally {
                                if (upload != null) {
                                    upload.closeStreams();
                                    upload.delete();
                                }
                            }
                        }, "Restore", target);
                    }
                    catch (Exception e) {
                        log.error("Exception on panel backup upload ", (Throwable)e);
                        BackupPanel.this.feedback.error((Serializable)e);
                    }
                    target.add(new Component[]{BackupPanel.this.feedback});
                }

                protected void onError(AjaxRequestTarget target) {
                    target.add(new Component[]{BackupPanel.this.feedback});
                }
            }})});
            this.add(new Component[]{this.upload.setOutputMarkupId(true), new Label("cmdLineDesc", (Serializable)((Object)this.getString("1505"))).setEscapeModelStrings(false).setRenderBodyOnly(true)});
            super.onInitialize();
        }

        private void updateButtons(IPartialPageRequestHandler target, boolean enabled) {
            this.download.setEnabled(enabled);
            this.upload.add(new Behavior[]{enabled ? AttributeModifier.remove((String)"disabled") : AttributeModifier.append((String)"disabled", (Serializable)((Object)"disabled"))});
            this.fileUploadField.setEnabled(enabled);
            target.add(new Component[]{this.download, this.upload});
        }

        private void startWithProgress(Runnable r, String label, AjaxRequestTarget target) {
            this.th = null;
            this.progressHolder.setProgress(0);
            ThreadHelper.startRunnable(r, "Openmeetings - " + label);
            this.updateButtons((IPartialPageRequestHandler)target, false);
            target.add(new Component[]{BackupPanel.this.feedback, ((GenericPanel)this.progressBar.restart((IPartialPageRequestHandler)target).setModelObject((Object)0)).setVisible(true)});
        }

        protected void onDetach() {
            this.includeFilesInBackup.detach();
            super.onDetach();
        }
    }
}

