/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.tika.detect.zip.StreamingDetectContext;
import org.apache.tika.detect.zip.ZipContainerDetector;
import org.apache.tika.io.BoundedInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;

public class OpenDocumentDetector
implements ZipContainerDetector {
    private static final int MAX_MIME_TYPE = 1024;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MediaType detect(ZipFile zip, TikaInputStream tis) throws IOException {
        try {
            ZipArchiveEntry mimetype = zip.getEntry("mimetype");
            if (mimetype == null) return null;
            if (mimetype.getSize() <= 0L) return null;
            try (InputStream stream = zip.getInputStream(mimetype);){
                MediaType mediaType = MediaType.parse((String)IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8));
                return mediaType;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public MediaType streamingDetectUpdate(ZipArchiveEntry zae, InputStream zis, StreamingDetectContext detectContext) throws IOException {
        String name = zae.getName();
        if ("mimetype".equals(name)) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BoundedInputStream bis = new BoundedInputStream(1024L, zis);
            IOUtils.copy((InputStream)bis, (OutputStream)bos);
            if (bos.toByteArray().length > 0) {
                return MediaType.parse((String)new String(bos.toByteArray(), StandardCharsets.UTF_8));
            }
        }
        return null;
    }

    @Override
    public MediaType streamingDetectFinal(StreamingDetectContext detectContext) {
        return null;
    }
}

