/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.sidebar;

import com.github.openjson.JSONObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.openmeetings.core.data.file.FileProcessor;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.file.FileItemLogDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.process.ProcessResult;
import org.apache.openmeetings.util.process.ProcessResultList;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.util.ThreadHelper;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoomFileUploadResourceReference
extends ResourceReference {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RoomFileUploadResourceReference.class);
    private static final String PARAM_FILE_NAME = "room-upload-file";
    private static final String PARAM_TO_WB_NAME = "room-upload-to-wb";
    private static final String PARAM_CLEAN_NAME = "room-upload-clean";
    private static final String PARAM_SID_NAME = "room-upload-sid";
    public static final String PARAM_LAST_SELECTED_ID = "room-upload-last-selected-id";
    public static final String PARAM_LAST_SELECTED_ROOM = "room-upload-last-selected-room";
    public static final String PARAM_LAST_SELECTED_OWNER = "room-upload-last-selected-pwner";
    public static final String PARAM_LAST_SELECTED_GROUP = "room-upload-last-selected-group";
    @SpringBean
    private ClientManager cm;
    @SpringBean
    private FileProcessor processor;
    @SpringBean
    private FileItemLogDao fileLogDao;
    @SpringBean
    private FileItemDao fileDao;

    public RoomFileUploadResourceReference() {
        super(RoomFileUploadResourceReference.class, "room-file-upload");
        Injector.get().inject((Object)this);
    }

    public IResource getResource() {
        return new AbstractResource(){
            private static final long serialVersionUID = 1L;

            protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
                AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
                ServletWebRequest webRequest = (ServletWebRequest)attributes.getRequest();
                try {
                    MultipartServletWebRequest multiPartRequest = webRequest.newMultipartWebRequest(Bytes.bytes((long)OpenmeetingsVariables.getMaxUploadSize()), "ignored");
                    multiPartRequest.parseFileParts();
                    String sid = multiPartRequest.getPostParameters().getParameterValue(RoomFileUploadResourceReference.PARAM_SID_NAME).toString();
                    Client c = RoomFileUploadResourceReference.this.cm.getBySid(sid);
                    long langId = RoomFileUploadResourceReference.getLangId(c);
                    if (RoomFileUploadResourceReference.isUploadAllowed(c)) {
                        Map files = multiPartRequest.getFiles();
                        List fileItems = (List)files.get(RoomFileUploadResourceReference.PARAM_FILE_NAME);
                        boolean toWb = multiPartRequest.getPostParameters().getParameterValue(RoomFileUploadResourceReference.PARAM_TO_WB_NAME).toBoolean(false);
                        boolean clean = multiPartRequest.getPostParameters().getParameterValue(RoomFileUploadResourceReference.PARAM_CLEAN_NAME).toBoolean(false);
                        long lastSelectedId = multiPartRequest.getPostParameters().getParameterValue(RoomFileUploadResourceReference.PARAM_LAST_SELECTED_ID).toLong(-1L);
                        long lastSelectedRoom = multiPartRequest.getPostParameters().getParameterValue(RoomFileUploadResourceReference.PARAM_LAST_SELECTED_ROOM).toLong(-1L);
                        long lastSelectedOwner = multiPartRequest.getPostParameters().getParameterValue(RoomFileUploadResourceReference.PARAM_LAST_SELECTED_OWNER).toLong(-1L);
                        long lastSelectedGroup = multiPartRequest.getPostParameters().getParameterValue(RoomFileUploadResourceReference.PARAM_LAST_SELECTED_GROUP).toLong(-1L);
                        String uuid = UUID.randomUUID().toString();
                        ThreadHelper.startRunnable(() -> RoomFileUploadResourceReference.this.convertAll(c, fileItems, uuid, toWb, clean, lastSelectedId, lastSelectedRoom, lastSelectedOwner, lastSelectedGroup));
                        RoomFileUploadResourceReference.prepareResponse(response, Status.SUCCESS, uuid, Application.getString("54", langId));
                    } else {
                        RoomFileUploadResourceReference.prepareResponse(response, Status.ERROR, null, Application.getString("access.denied.header", langId));
                    }
                }
                catch (Exception e) {
                    log.error("An error occurred while uploading a file", (Throwable)e);
                    RoomFileUploadResourceReference.prepareResponse(response, Status.ERROR, null, e.getMessage());
                }
                return response;
            }
        };
    }

    private static long getLangId(Client c) {
        return c == null || c.getUser() == null ? 1L : c.getUser().getLanguageId();
    }

    private static void prepareResponse(AbstractResource.ResourceResponse response, final Status status, final String uuid, final String msg) {
        response.setContentType("application/json");
        response.setWriteCallback(new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) throws IOException {
                attributes.getResponse().write((CharSequence)new JSONObject().put("status", (Object)status.name()).put("message", (Object)msg).put("uuid", (Object)uuid).toString());
            }
        });
    }

    private static boolean isUploadAllowed(Client c) {
        if (c == null || c.getRoom() == null || Room.Type.INTERVIEW == c.getRoom().getType()) {
            return false;
        }
        Room r = c.getRoom();
        return !r.isHidden(Room.RoomElement.FILES) && c.hasRight(Room.Right.PRESENTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertAll(Client c, List<org.apache.commons.fileupload.FileItem> files, String uuid, boolean toWb, boolean clean, long lastSelectedId, long lastSelectedRoom, long lastSelectedOwner, long lastSelectedGroup) {
        BaseFileItem parent = (BaseFileItem)this.fileDao.get(lastSelectedId);
        long langId = RoomFileUploadResourceReference.getLangId(c);
        long totalSize = files.stream().mapToLong(org.apache.commons.fileupload.FileItem::getSize).sum();
        AtomicInteger progress = new AtomicInteger(0);
        long currentSize = 0L;
        for (org.apache.commons.fileupload.FileItem curItem : files) {
            long size = curItem.getSize();
            try {
                FileItem f = new FileItem();
                f.setSize(Long.valueOf(size));
                f.setName(curItem.getName());
                if (parent == null || BaseFileItem.Type.RECORDING == parent.getType()) {
                    if (lastSelectedGroup > -1L) {
                        f.setGroupId(Long.valueOf(lastSelectedGroup));
                    } else if (lastSelectedRoom > -1L) {
                        f.setRoomId(Long.valueOf(lastSelectedRoom));
                    } else {
                        f.setOwnerId(Long.valueOf(lastSelectedOwner > -1L ? lastSelectedOwner : WebSession.getUserId()));
                    }
                } else {
                    f.setRoomId(parent.getRoomId());
                    f.setOwnerId(parent.getOwnerId());
                    f.setGroupId(parent.getGroupId());
                    if (parent.getId() != null) {
                        f.setParentId(BaseFileItem.Type.FOLDER == parent.getType() ? parent.getId() : parent.getParentId());
                    }
                }
                f.setInsertedBy(WebSession.getUserId());
                ProcessResultList logs = this.processor.processFile(f, curItem.getInputStream(), Optional.of(part -> this.sendProgress(c, uuid, progress, progress.get() + (int)(100.0 * part * (double)size / (double)totalSize))));
                for (ProcessResult res : logs.getJobs()) {
                    this.fileLogDao.add(res.getProcess(), (BaseFileItem)f, res);
                }
                if (logs.hasError()) {
                    this.sendError(c, uuid, Application.getString("convert.errors.file", langId));
                } else if (toWb) {
                    WebSocketHelper.sendClient((IWsClient)c, (RoomMessage)new TextRoomMessage(c.getRoomId(), c, RoomMessage.Type.WB_PUT_FILE, new JSONObject().put("fileId", (Object)f.getId()).put("clean", clean).toString()));
                    clean = false;
                }
            }
            catch (Exception e) {
                log.error("Unexpected error while processing uploaded file", (Throwable)e);
                this.sendError(c, uuid, e.getMessage() == null ? "Unexpected error" : e.getMessage());
            }
            finally {
                curItem.delete();
            }
            this.sendProgress(c, uuid, progress, (int)(100L * (currentSize += size) / totalSize));
        }
        this.sendProgress(c, uuid, progress, 100);
    }

    private JSONObject getBaseMessage(String uuid) {
        return new JSONObject().put("uuid", (Object)uuid).put("type", (Object)"room-upload");
    }

    private void sendError(Client c, String uuid, String msg) {
        WebSocketHelper.sendClient((IWsClient)c, (JSONObject)this.getBaseMessage(uuid).put("status", (Object)Status.ERROR.name()).put("message", (Object)msg));
    }

    private void sendProgress(Client c, String uuid, AtomicInteger progress, int cur) {
        if (cur > progress.get()) {
            progress.set(cur);
            WebSocketHelper.sendClient((IWsClient)c, (JSONObject)this.getBaseMessage(uuid).put("status", (Object)Status.PROGRESS.name()).put("progress", cur));
        }
    }

    private static enum Status {
        SUCCESS,
        PROGRESS,
        ERROR;

    }
}

