/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.menu;

import com.github.openjson.JSONObject;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.INavbarComponent;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.core.remote.KurentoHandler;
import org.apache.openmeetings.core.remote.StreamProcessor;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.basic.ChatDao;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.ImagePanel;
import org.apache.openmeetings.web.common.menu.MenuPanel;
import org.apache.openmeetings.web.common.menu.OmMenuItem;
import org.apache.openmeetings.web.room.OmTimerBehavior;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.room.menu.ActionsSubMenu;
import org.apache.openmeetings.web.room.menu.ExtrasSubMenu;
import org.apache.openmeetings.web.room.menu.PollsSubMenu;
import org.apache.openmeetings.web.util.GroupLogoResourceReference;
import org.apache.openmeetings.web.util.OmUrlFragment;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.flow.RedirectToUrlException;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;

public class RoomMenuPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private MenuPanel menuPanel;
    private final WebMarkupContainer shareBtn;
    private final Label roomName;
    private static final FastDateFormat df = FastDateFormat.getInstance((String)"dd.MM.yyyy HH:mm");
    private final AjaxLink<Void> askBtn = new AjaxLink<Void>("ask"){
        private static final long serialVersionUID = 1L;

        protected void onInitialize() {
            super.onInitialize();
            this.setOutputMarkupPlaceholderTag(true);
            this.setVisible(false);
        }

        public void onClick(AjaxRequestTarget target) {
            Client c = RoomMenuPanel.this.room.getClient();
            WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(c.getRoom().getId(), c, RoomMessage.Type.HAVE_QUESTION, c.getUid()));
        }
    };
    private final RoomPanel room;
    private OmMenuItem exitMenuItem;
    private final ImagePanel logo = new ImagePanel("logo"){
        private static final long serialVersionUID = 1L;

        @Override
        protected String getImageUrl() {
            return GroupLogoResourceReference.getUrl(this.getRequestCycle(), RoomMenuPanel.this.getGroup().getId());
        }
    };
    private final PollsSubMenu pollsSubMenu;
    private final ActionsSubMenu actionsSubMenu;
    private final ExtrasSubMenu extrasSubMenu;
    @SpringBean
    private ClientManager cm;
    @SpringBean
    private ConfigurationDao cfgDao;
    @SpringBean
    private ChatDao chatDao;
    @SpringBean
    private KurentoHandler kHandler;
    @SpringBean
    private StreamProcessor streamProcessor;

    public RoomMenuPanel(String id, RoomPanel room) {
        super(id);
        this.setOutputMarkupPlaceholderTag(true);
        this.room = room;
        Room r = room.getRoom();
        this.setVisible(!r.isHidden(Room.RoomElement.TOP_BAR));
        Component[] componentArray = new Component[1];
        this.roomName = new Label("roomName", (Serializable)((Object)r.getName()));
        componentArray[0] = this.roomName.setOutputMarkupPlaceholderTag(true).setOutputMarkupId(true);
        this.add(componentArray);
        String tag = this.getGroup().getTag();
        this.add(new Component[]{this.logo, new Label("tag", (Serializable)((Object)tag)).setVisible(!Strings.isEmpty((CharSequence)tag))});
        Component[] componentArray2 = new Component[1];
        this.shareBtn = new WebMarkupContainer("share");
        componentArray2[0] = this.shareBtn;
        this.add(componentArray2);
        this.shareBtn.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.pollsSubMenu = new PollsSubMenu(room, this);
        this.actionsSubMenu = new ActionsSubMenu(room, this);
        this.extrasSubMenu = new ExtrasSubMenu(room);
    }

    private Group getGroup() {
        Room r = this.room.getRoom();
        return r.getGroups() == null || r.getGroups().isEmpty() ? new Group() : ((RoomGroup)r.getGroups().get(0)).getGroup();
    }

    protected void onInitialize() {
        this.exitMenuItem = new OmMenuItem(this.getString("308"), this.getString("309"), (IconType)FontAwesome5IconType.sign_out_alt_s){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                RoomMenuPanel.this.chatDao.closeMessages(WebSession.getUserId().longValue());
                RoomMenuPanel.this.exit((IPartialPageRequestHandler)target);
            }
        };
        this.actionsSubMenu.init();
        this.pollsSubMenu.init();
        this.extrasSubMenu.init();
        Component[] componentArray = new Component[1];
        this.menuPanel = new MenuPanel("menu", this.getMenu());
        componentArray[0] = this.menuPanel.setVisible(this.isVisible());
        this.add(componentArray);
        this.add(new Component[]{this.askBtn.add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)this.getString("84")))})});
        Label demo = new Label("demo", (IModel)Model.of((Serializable)((Object)"")));
        Room r = this.room.getRoom();
        this.add(new Component[]{demo.setVisible(r.isDemoRoom() && r.getDemoTime() != null && this.room.getRoom().getDemoTime() > 0)});
        if (demo.isVisible()) {
            demo.add(new Behavior[]{new OmTimerBehavior(this.room.getRoom().getDemoTime(), "637"){
                private static final long serialVersionUID = 1L;

                @Override
                protected void onTimer(int remain) {
                    this.getComponent().add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)4.getText(RoomMenuPanel.this.getString("637"), remain)))});
                }

                @Override
                protected void onFinish(AjaxRequestTarget target) {
                    RoomMenuPanel.this.exit((IPartialPageRequestHandler)target);
                }
            }});
        }
        super.onInitialize();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        this.pollsSubMenu.renderHead(response);
    }

    private List<INavbarComponent> getMenu() {
        ArrayList<INavbarComponent> menu = new ArrayList<INavbarComponent>();
        menu.add(this.exitMenuItem);
        if (this.actionsSubMenu.isVisible()) {
            menu.add(this.actionsSubMenu.getMenu());
        }
        if (this.pollsSubMenu.isVisible()) {
            menu.add(this.pollsSubMenu.getMenu());
        }
        menu.add(this.extrasSubMenu.getMenu());
        return menu;
    }

    public void update(IPartialPageRequestHandler handler) {
        JSONObject ru;
        if (!this.isVisible()) {
            return;
        }
        Room r = this.room.getRoom();
        User u = this.room.getClient().getUser();
        boolean notExternalUser = u.getType() != User.Type.CONTACT;
        boolean moder = this.room.getClient().hasRight(Room.Right.MODERATOR);
        this.actionsSubMenu.update(moder, notExternalUser);
        this.pollsSubMenu.update(moder, notExternalUser, r);
        this.menuPanel.update(handler);
        StringBuilder roomClass = new StringBuilder("room name");
        Object roomTitle = "";
        if (this.streamProcessor.isRecording(r.getId()) && !Strings.isEmpty((CharSequence)(ru = this.kHandler.getRecordingUser(r.getId())).optString("login"))) {
            roomTitle = (String)roomTitle + this.getString("419") + " " + ru.getString("login");
            if (!Strings.isEmpty((CharSequence)ru.optString("firstName"))) {
                roomTitle = (String)roomTitle + " " + ru.getString("firstName");
            }
            if (!Strings.isEmpty((CharSequence)ru.optString("lastName"))) {
                roomTitle = (String)roomTitle + " " + ru.getString("lastName");
            }
            roomTitle = (String)roomTitle + " " + df.format(new Date(ru.getLong("started")));
            roomClass.append(" screen");
        }
        handler.add(new Component[]{this.roomName.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)roomClass), AttributeModifier.replace((String)"title", (Serializable)roomTitle)})});
        handler.add(new Component[]{this.askBtn.setVisible(!moder && r.isAllowUserQuestions())});
        handler.add(new Component[]{this.shareBtn.setVisible(this.room.screenShareAllowed())});
        handler.appendJavaScript((CharSequence)"$('#share-dlg-btn').off().click(Sharer.open);");
    }

    public void updatePoll(IPartialPageRequestHandler handler, Long createdBy) {
        this.pollsSubMenu.updatePoll(handler, createdBy);
        this.update(handler);
    }

    public void exit(IPartialPageRequestHandler handler) {
        this.cm.exitRoom(this.room.getClient());
        if (WebSession.getRights().contains(User.Right.DASHBOARD)) {
            Room r = this.room.getRoom();
            if (OpenmeetingsVariables.isMyRoomsEnabled() && r != null && WebSession.getUserId().equals(r.getOwnerId())) {
                this.room.getMainPanel().updateContents(OmUrlFragment.ROOMS_MY, handler);
            } else if (r != null && !r.getIspublic()) {
                this.room.getMainPanel().updateContents(OmUrlFragment.ROOMS_GROUP, handler);
            } else {
                this.room.getMainPanel().updateContents(OmUrlFragment.ROOMS_PUBLIC, handler);
            }
        } else {
            WebSession.get().invalidate();
            String url = this.cfgDao.getString("redirect.url.for.external.users", "");
            throw new RedirectToUrlException(Strings.isEmpty((CharSequence)url) ? OpenmeetingsVariables.getBaseUrl() : url);
        }
    }
}

