/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.menu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.GroupUserDao;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.service.room.InvitationManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.GroupChoiceProvider;
import org.apache.openmeetings.web.common.InvitationForm;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Select2MultiChoice;

public class RoomInvitationForm
extends InvitationForm {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RoomInvitationForm.class);
    private final RadioGroup<InviteeType> rdi = new RadioGroup("inviteeType", (IModel)Model.of((Serializable)((Object)InviteeType.user)));
    private final Long roomId;
    private final WebMarkupContainer groupContainer = new WebMarkupContainer("groupContainer");
    private final Select2MultiChoice<Group> groups = new Select2MultiChoice("groups", (IModel)new CollectionModel(new ArrayList()), (ChoiceProvider)new GroupChoiceProvider());
    final WebMarkupContainer sipContainer = new WebMarkupContainer("sip-container");
    @SpringBean
    private RoomDao roomDao;
    @SpringBean
    private GroupUserDao groupUserDao;
    @SpringBean
    private InvitationManager invitationManager;

    public RoomInvitationForm(String id, Long roomId, String dropDownParentId) {
        super(id, dropDownParentId);
        this.roomId = roomId;
    }

    @Override
    protected void onInitialize() {
        this.groups.setLabel((IModel)new ResourceModel("126"));
        boolean showGroups = AuthLevelUtil.hasAdminLevel(WebSession.getRights());
        this.add(new Component[]{this.rdi.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                boolean groupsEnabled = InviteeType.group == RoomInvitationForm.this.rdi.getModelObject();
                RoomInvitationForm.this.updateButtons(target);
                target.add(new Component[]{RoomInvitationForm.this.groups.setEnabled(groupsEnabled), RoomInvitationForm.this.recipients.setEnabled(!groupsEnabled)});
            }
        }})});
        this.groupContainer.add(new Component[]{this.groups.setRequired(true).add(new Behavior[]{AjaxFormComponentUpdatingBehavior.onUpdate((String)"change", (SerializableConsumer & Serializable)target -> {
            this.url.setModelObject(null);
            this.updateButtons((AjaxRequestTarget)target);
        })}).setOutputMarkupId(true), new Radio("group", (IModel)Model.of((Serializable)((Object)InviteeType.group)))});
        this.rdi.add(new Component[]{this.recipients, this.groupContainer.setVisible(showGroups)});
        this.rdi.add(new Component[]{new Radio("user", (IModel)Model.of((Serializable)((Object)InviteeType.user)))});
        this.add(new Component[]{this.sipContainer.setOutputMarkupPlaceholderTag(true).setOutputMarkupId(true)});
        this.sipContainer.add(new Component[]{new Label("room.confno", (Serializable)((Object)""))}).setVisible(false);
        if (this.dropDownParentId != null) {
            this.groups.getSettings().setDropdownParent(this.dropDownParentId);
        }
        super.onInitialize();
    }

    @Override
    protected void updateButtons(AjaxRequestTarget target) {
        if (this.rdi.getModelObject() == InviteeType.user) {
            super.updateButtons(target);
        } else {
            Collection to = (Collection)this.groups.getModelObject();
            target.add(new Component[]{this.dialog.getSend().setEnabled(!to.isEmpty()), this.dialog.getGenerate().setEnabled(false)});
        }
    }

    @Override
    public void updateModel(AjaxRequestTarget target) {
        super.updateModel(target);
        Invitation i = (Invitation)this.getModelObject();
        i.setRoom(this.roomDao.get(this.roomId));
        if (i.getRoom() != null) {
            target.add(new Component[]{this.sipContainer.replace((Component)new Label("room.confno", (Serializable)((Object)i.getRoom().getConfno()))).setVisible(i.getRoom().isSipEnabled())});
        }
        this.groups.setModelObject(new ArrayList());
        this.groups.setEnabled(false);
        this.rdi.setModelObject((Object)InviteeType.user);
    }

    @Override
    public void onClick(AjaxRequestTarget target, InvitationForm.Action action) {
        if (InvitationForm.Action.SEND == action && Strings.isEmpty((CharSequence)((CharSequence)this.url.getModelObject())) && this.rdi.getModelObject() == InviteeType.group) {
            String userbaseUrl = WebSession.get().getExtendedProperties().getBaseUrl();
            for (Group g : (Collection)this.groups.getModelObject()) {
                for (GroupUser ou : this.groupUserDao.get(g.getId().longValue(), 0L, Integer.MAX_VALUE)) {
                    Invitation i = this.create(ou.getUser());
                    try {
                        this.invitationManager.sendInvitationLink(i, Invitation.MessageType.CREATE, (String)this.subject.getModelObject(), (String)this.message.getModelObject(), false, userbaseUrl);
                    }
                    catch (Exception e) {
                        log.error("error while sending invitation by Group ", (Throwable)e);
                    }
                }
            }
        }
        super.onClick(target, action);
    }

    static enum InviteeType {
        user,
        group;

    }
}

