/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.validation.validator.RfcCompliantEmailAddressValidator;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.StringValidator;

public class NicknameDialog
extends Modal<User> {
    private static final long serialVersionUID = 1L;
    private static final FastDateFormat TIME_DF = FastDateFormat.getInstance((String)"HH:mm:ss");
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final RoomPanel room;
    private Form<User> form;
    @SpringBean
    private ClientManager cm;

    public NicknameDialog(String id, RoomPanel room) {
        super(id);
        this.room = room;
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("1287"));
        this.setBackdrop(Modal.Backdrop.STATIC);
        Component[] componentArray = new Component[1];
        this.form = new Form("form", (IModel)new CompoundPropertyModel((Object)this.room.getClient().getUser()));
        componentArray[0] = this.form;
        this.add(componentArray);
        this.addButton((Component)new BootstrapAjaxButton("button", (IModel)new ResourceModel("54"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{NicknameDialog.this.feedback});
            }

            protected void onSubmit(AjaxRequestTarget target) {
                User u = (User)NicknameDialog.this.form.getModelObject();
                Client c = NicknameDialog.this.room.getClient();
                c.getUser().setFirstname(u.getFirstname()).setLastname(u.getLastname());
                NicknameDialog.this.room.broadcast(NicknameDialog.this.cm.update(c));
                NicknameDialog.this.close((IPartialPageRequestHandler)target);
            }
        });
        this.form.add(new Component[]{this.feedback.setOutputMarkupId(true)});
        this.form.add(new Component[]{new RequiredTextField("firstname").setLabel((IModel)new ResourceModel("135")).add((IValidator)StringValidator.minimumLength((int)OpenmeetingsVariables.getMinFnameLength()))});
        this.form.add(new Component[]{new RequiredTextField("lastname").setLabel((IModel)new ResourceModel("136")).add((IValidator)StringValidator.minimumLength((int)OpenmeetingsVariables.getMinLnameLength()))});
        this.form.add(new Component[]{new RequiredTextField("address.email").setLabel((IModel)new ResourceModel("119")).add((IValidator)RfcCompliantEmailAddressValidator.getInstance())});
        super.onInitialize();
        User u = (User)this.form.getModelObject();
        boolean visible = NicknameDialog.isVisible(u);
        if (visible) {
            u.setFirstname(this.getString("433"));
            u.setLastname(String.format("%s %s", u.getFirstname(), TIME_DF.format(new Date())));
        }
        this.show(visible);
    }

    private static boolean isVisible(User u) {
        return (User.Type.CONTACT == u.getType() || User.Type.EXTERNAL == u.getType()) && Strings.isEmpty((CharSequence)u.getFirstname()) && Strings.isEmpty((CharSequence)u.getLastname());
    }
}

