/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.pages.install;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.progress.UpdatableProgressBar;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.BackgroundColorBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.spinner.SpinnerAjaxButton;
import de.agilecoders.wicket.extensions.wizard.BootstrapWizard;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.openmeetings.cli.ConnectionPropertiesPatcher;
import org.apache.openmeetings.core.converter.BaseConverter;
import org.apache.openmeetings.core.converter.DocumentConverter;
import org.apache.openmeetings.core.util.StrongPasswordValidator;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.installation.ImportInitvalues;
import org.apache.openmeetings.installation.InstallationConfig;
import org.apache.openmeetings.util.ConnectionProperties;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.process.ProcessHelper;
import org.apache.openmeetings.util.process.ProcessResult;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.ErrorMessagePanel;
import org.apache.openmeetings.web.common.OmLabel;
import org.apache.openmeetings.web.pages.install.CongratulationsPanel;
import org.apache.openmeetings.web.util.OmTooltipBehavior;
import org.apache.openmeetings.web.util.ThreadHelper;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.validation.validator.RfcCompliantEmailAddressValidator;
import org.apache.wicket.extensions.wizard.IWizard;
import org.apache.wicket.extensions.wizard.IWizardModel;
import org.apache.wicket.extensions.wizard.WizardButton;
import org.apache.wicket.extensions.wizard.WizardButtonBar;
import org.apache.wicket.extensions.wizard.dynamic.DynamicWizardModel;
import org.apache.wicket.extensions.wizard.dynamic.DynamicWizardStep;
import org.apache.wicket.extensions.wizard.dynamic.IDynamicWizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.apache.wicket.validation.validator.StringValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.LocalEntityManagerFactoryBean;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class InstallWizard
extends BootstrapWizard {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(InstallWizard.class);
    private IDynamicWizardStep welcomeStep;
    private IDynamicWizardStep dbStep;
    private ParamsStep1 paramsStep1;
    private IDynamicWizardStep paramsStep2;
    private IDynamicWizardStep paramsStep3;
    private IDynamicWizardStep paramsStep4;
    private InstallStep installStep;
    private Throwable th = null;
    private ConnectionProperties.DbType initDbType = null;
    private ConnectionProperties.DbType dbType = null;
    private NotificationPanel feedback;
    private final CompoundPropertyModel<InstallationConfig> model;
    private final List<Button> buttons = new ArrayList<Button>(4);
    private WizardButtonBar btnBar;
    @SpringBean
    private ImportInitvalues initvalues;

    public InstallWizard(String id, String title) {
        super(id);
        this.setOutputMarkupPlaceholderTag(true);
        this.setOutputMarkupId(true);
        this.model = new CompoundPropertyModel((Object)new InstallationConfig());
        this.setDefaultModel((IModel)this.model);
    }

    protected void onInitialize() {
        this.welcomeStep = new WelcomeStep();
        this.dbStep = new DbStep();
        this.paramsStep1 = new ParamsStep1();
        this.paramsStep2 = new ParamsStep2();
        this.paramsStep3 = new ParamsStep3();
        this.paramsStep4 = new ParamsStep4();
        this.installStep = new InstallStep();
        DynamicWizardModel wmodel = new DynamicWizardModel(this.welcomeStep);
        wmodel.setCancelVisible(false);
        wmodel.setLastVisible(true);
        this.init((IWizardModel)wmodel);
        super.onInitialize();
    }

    public void initTzDropDown() {
        this.paramsStep1.tzDropDown.setOption();
    }

    protected WebMarkupContainer newFeedbackPanel(String id) {
        this.feedback = (NotificationPanel)super.newFeedbackPanel(id);
        this.feedback.setEscapeModelStrings(false).setOutputMarkupId(true);
        return this.feedback;
    }

    protected Component newButtonBar(String id) {
        this.btnBar = new WizardButtonBar(id, (IWizard)this){
            private static final long serialVersionUID = 1L;

            protected WizardButton newCancelButton(String id, IWizard wizard) {
                WizardButton button = super.newCancelButton(id, wizard);
                button.add(new Behavior[]{new ButtonBehavior(Buttons.Type.Outline_Warning, Buttons.Size.Medium)});
                return button;
            }

            protected WizardButton newFinishButton(String id, IWizard wizard) {
                final WizardButton button = super.newFinishButton(id, wizard);
                button.add(new Behavior[]{new ButtonBehavior(Buttons.Type.Outline_Success, Buttons.Size.Medium)});
                button.add(new Behavior[]{new AjaxFormSubmitBehavior("click"){
                    private static final long serialVersionUID = 1L;

                    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                        super.updateAjaxAttributes(attributes);
                        attributes.setPreventDefault(true);
                    }

                    protected void onSubmit(AjaxRequestTarget target) {
                        button.onSubmit();
                    }
                }});
                InstallWizard.this.buttons.add((Button)button);
                return button;
            }

            protected WizardButton newLastButton(String id, IWizard wizard) {
                WizardButton button = super.newLastButton(id, wizard);
                button.add(new Behavior[]{new ButtonBehavior(Buttons.Type.Outline_Secondary, Buttons.Size.Medium)});
                InstallWizard.this.buttons.add((Button)button);
                return button;
            }

            protected WizardButton newNextButton(String id, IWizard wizard) {
                WizardButton button = super.newNextButton(id, wizard);
                button.add(new Behavior[]{new ButtonBehavior(Buttons.Type.Outline_Secondary, Buttons.Size.Medium)});
                InstallWizard.this.buttons.add((Button)button);
                return button;
            }

            protected WizardButton newPreviousButton(String id, IWizard wizard) {
                WizardButton button = super.newPreviousButton(id, wizard);
                button.add(new Behavior[]{new ButtonBehavior(Buttons.Type.Outline_Secondary, Buttons.Size.Medium)});
                InstallWizard.this.buttons.add((Button)button);
                return button;
            }
        };
        this.btnBar.setOutputMarkupId(true);
        return this.btnBar;
    }

    protected void onDetach() {
        this.model.detach();
        super.onDetach();
    }

    private final class LangDropDown
    extends SelectOptionDropDown {
        private static final long serialVersionUID = 1L;

        public LangDropDown(String id) {
            super(id);
            ArrayList<SelectOption> list = new ArrayList<SelectOption>();
            for (Map.Entry me : LabelDao.getLanguages()) {
                SelectOption op = new SelectOption(((Long)me.getKey()).toString(), ((Locale)me.getValue()).getDisplayName());
                if (this.getSession().getLocale().equals(me.getValue())) {
                    this.option = op;
                }
                if (this.option == null && this.getSession().getLocale().getLanguage().equals(((Locale)me.getValue()).getLanguage())) {
                    this.option = op;
                }
                list.add(op);
                if (this.option != null || ((Long)me.getKey()).intValue() != ((InstallationConfig)InstallWizard.this.model.getObject()).getDefaultLangId()) continue;
                this.option = op;
            }
            this.setChoices(list);
        }
    }

    private class SelectOptionDropDown
    extends WizardDropDown<SelectOption> {
        private static final long serialVersionUID = 1L;

        SelectOptionDropDown(String id) {
            super(id);
            this.setChoiceRenderer((IChoiceRenderer)new ChoiceRenderer("value", "key"));
        }

        protected void onModelChanged() {
            if (this.propModel != null && this.option != null) {
                this.propModel.setObject((Object)((SelectOption)this.option).key);
            }
        }
    }

    private final class TzDropDown
    extends WizardDropDown<String> {
        private static final long serialVersionUID = 1L;

        public TzDropDown(String id) {
            super(id);
            this.setChoices(WebSession.AVAILABLE_TIMEZONES);
            this.setChoiceRenderer((IChoiceRenderer)new ChoiceRenderer<String>(){
                private static final long serialVersionUID = 1L;

                public Object getDisplayValue(String object) {
                    return object;
                }

                public String getIdValue(String object, int index) {
                    return object;
                }
            });
        }

        public void setOption() {
            String tzId = WebSession.get().getClientTZCode();
            this.option = WebSession.AVAILABLE_TIMEZONE_SET.contains(tzId) ? tzId : WebSession.AVAILABLE_TIMEZONES.get(0);
        }

        protected void onModelChanged() {
            if (this.propModel != null && this.option != null) {
                this.propModel.setObject((Object)this.option);
            }
        }
    }

    private abstract class WizardDropDown<T extends Serializable>
    extends DropDownChoice<T> {
        private static final long serialVersionUID = 1L;
        T option;
        IModel<Object> propModel;

        WizardDropDown(String id) {
            super(id);
            this.propModel = InstallWizard.this.model.bind(id);
            this.setModel((IModel)new PropertyModel((Object)this, "option"));
        }

        protected void onDetach() {
            this.propModel.detach();
            super.onDetach();
        }
    }

    private static class SelectOption
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String key;
        private final String value;

        SelectOption(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    private class InstallProcess
    implements Runnable {
        private ImportInitvalues installer;

        public InstallProcess(ImportInitvalues installer) {
            this.installer = installer;
            InstallWizard.this.th = null;
        }

        @Override
        public void run() {
            try {
                this.installer.loadAll((InstallationConfig)InstallWizard.this.model.getObject(), true);
            }
            catch (Exception e) {
                InstallWizard.this.th = e;
            }
        }
    }

    private final class InstallStep
    extends BaseStep {
        private static final long serialVersionUID = 1L;
        private final CongratulationsPanel congrat;
        private final WebMarkupContainer container;
        private final UpdatableProgressBar progressBar;
        private final Label desc;
        private boolean started;

        public InstallStep() {
            super(InstallWizard.this.paramsStep4);
            this.congrat = new CongratulationsPanel("status");
            this.container = new WebMarkupContainer("container");
            this.progressBar = new UpdatableProgressBar("progress", (IModel)new Model((Serializable)Integer.valueOf(0)), BackgroundColorBehavior.Color.Info, true){
                private static final long serialVersionUID = 1L;

                protected IModel<Integer> newValue() {
                    return Model.of((Serializable)Integer.valueOf(InstallWizard.this.initvalues.getProgress()));
                }

                protected void onPostProcessTarget(IPartialPageRequestHandler target) {
                    if (!InstallStep.this.started) {
                        this.stop(target);
                        return;
                    }
                    if (InstallWizard.this.th != null) {
                        this.stop(target);
                        InstallStep.this.progressBar.setVisible(false);
                        target.add(new Component[]{InstallStep.this.container.replace((Component)new ErrorMessagePanel("status", this.getString("install.wizard.install.failed"), InstallWizard.this.th)), InstallStep.this.desc.setVisible(false)});
                    }
                    super.onPostProcessTarget(target);
                }

                protected void onComplete(IPartialPageRequestHandler target) {
                    this.stop(target);
                    InstallStep.this.progressBar.setVisible(false);
                    InstallStep.this.congrat.show(InstallWizard.this.initDbType != InstallWizard.this.dbType);
                    target.add(new Component[]{InstallStep.this.container, InstallStep.this.desc.setVisible(false), InstallWizard.this.btnBar.setVisible(false)});
                }
            };
            this.desc = new Label("desc", (Serializable)((Object)""));
            this.started = false;
        }

        public void applyState() {
            this.started = true;
            ThreadHelper.startRunnable(new InstallProcess(InstallWizard.this.initvalues), "Openmeetings - Installation");
            this.desc.setDefaultModelObject((Object)this.getString("install.wizard.install.started"));
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(target -> {
                this.progressBar.restart((IPartialPageRequestHandler)target).setModelObject((Object)0);
                InstallWizard.this.buttons.forEach(b -> target.add(new Component[]{b.setEnabled(false)}));
                target.add(new Component[]{this.desc, this.container});
            });
        }

        @Override
        protected void onInitialize() {
            super.onInitialize();
            this.progressBar.updateInterval(Duration.ofSeconds(1L)).stop(null).striped(false).setOutputMarkupId(true);
            this.container.add(new Component[]{this.progressBar, this.congrat});
            this.congrat.setVisible(false);
            this.add(new Component[]{this.container.setOutputMarkupId(true)});
            this.desc.setDefaultModelObject((Object)this.getString("install.wizard.install.desc"));
            this.add(new Component[]{this.desc.setOutputMarkupId(true)});
        }

        public boolean isLastStep() {
            return true;
        }

        public IDynamicWizardStep next() {
            return null;
        }
    }

    private final class ParamsStep4
    extends BaseStep {
        private static final long serialVersionUID = 1L;

        public ParamsStep4() {
            super(InstallWizard.this.paramsStep3);
        }

        @Override
        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{new RequiredTextField("cryptClassName")});
            this.add(new Component[]{new CheckBox("sipEnable")});
            this.add(new Component[]{new TextField("sipRoomPrefix")});
            this.add(new Component[]{new TextField("sipExtenContext")});
            this.add(new Behavior[]{new OmTooltipBehavior()});
        }

        public boolean isLastStep() {
            return false;
        }

        public IDynamicWizardStep next() {
            return InstallWizard.this.installStep;
        }

        public boolean isLastAvailable() {
            return true;
        }

        public IDynamicWizardStep last() {
            return InstallWizard.this.installStep;
        }
    }

    private final class ParamsStep3
    extends BaseStep {
        private static final long serialVersionUID = 1L;
        private static final String REGEX = "\\r\\n|\\r|\\n";
        private static final String OPT_VERSION = "-version";
        private final TextField<String> ffmpegPath;
        private final TextField<String> imageMagicPath;
        private final TextField<String> soxPath;
        private final TextField<String> officePath;
        private boolean isAllChecked;

        public ParamsStep3() {
            super(InstallWizard.this.paramsStep2);
            this.ffmpegPath = new TextField("ffmpegPath");
            this.imageMagicPath = new TextField("imageMagicPath");
            this.soxPath = new TextField("soxPath");
            this.officePath = new TextField("officePath");
            this.isAllChecked = false;
        }

        @Override
        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{this.imageMagicPath.setLabel((IModel)new ResourceModel("install.wizard.params.step3.imageMagicPath"))});
            this.add(new Component[]{this.ffmpegPath.setLabel((IModel)new ResourceModel("install.wizard.params.step3.ffmpegPath"))});
            this.add(new Component[]{this.soxPath.setLabel((IModel)new ResourceModel("install.wizard.params.step3.soxPath"))});
            this.add(new Component[]{this.officePath.setLabel((IModel)new ResourceModel("install.wizard.params.step3.officePath"))});
            this.add(new Component[]{new TextField("docDpi").setRequired(true).add((IValidator)RangeValidator.range((Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(600)))});
            this.add(new Component[]{new TextField("docQuality").setRequired(true).add((IValidator)RangeValidator.range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(100)))});
            this.add(new Component[]{new BootstrapAjaxButton("validateImageMagic", (IModel)new ResourceModel("install.wizard.db.step.check"), Buttons.Type.Outline_Primary){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    ParamsStep3.this.checkMagicPath();
                    target.add(new Component[]{InstallWizard.this.feedback});
                }
            }});
            this.add(new Component[]{new BootstrapAjaxButton("validateFfmpeg", (IModel)new ResourceModel("install.wizard.db.step.check"), Buttons.Type.Outline_Primary){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    ParamsStep3.this.checkFfmpegPath();
                    target.add(new Component[]{InstallWizard.this.feedback});
                }
            }});
            this.add(new Component[]{new BootstrapAjaxButton("validateSox", (IModel)new ResourceModel("install.wizard.db.step.check"), Buttons.Type.Outline_Primary){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    ParamsStep3.this.checkSoxPath();
                    target.add(new Component[]{InstallWizard.this.feedback});
                }
            }});
            this.add(new Component[]{new BootstrapAjaxButton("validateOffice", (IModel)new ResourceModel("install.wizard.db.step.check"), Buttons.Type.Outline_Primary){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    ParamsStep3.this.checkOfficePath();
                    target.add(new Component[]{InstallWizard.this.feedback});
                }
            }});
            this.add(new Behavior[]{new OmTooltipBehavior()});
        }

        private void reportSuccess(TextField<String> path) {
            path.success((Serializable)((Object)((String)path.getLabel().getObject() + " - " + this.getString("54"))));
        }

        private boolean checkToolPath(TextField<String> path, List<String> args) {
            ProcessResult result = ProcessHelper.exec((String)(path.getInputName() + " path:: '" + path.getValue() + "'"), args);
            if (!result.isOk()) {
                path.error((Serializable)((Object)result.getError().replaceAll(REGEX, "")));
            } else {
                this.reportSuccess(path);
            }
            return result.isOk();
        }

        private boolean checkMagicPath() {
            return this.checkToolPath(this.imageMagicPath, List.of(this.getToolPath(this.imageMagicPath.getValue(), "convert" + BaseConverter.EXEC_EXT), OPT_VERSION));
        }

        private boolean checkFfmpegPath() {
            return this.checkToolPath(this.ffmpegPath, List.of(this.getToolPath(this.ffmpegPath.getValue(), "ffmpeg" + BaseConverter.EXEC_EXT), OPT_VERSION));
        }

        private boolean checkSoxPath() {
            return this.checkToolPath(this.soxPath, List.of(this.getToolPath(this.soxPath.getValue(), "sox" + BaseConverter.EXEC_EXT), "--version"));
        }

        private boolean checkOfficePath() {
            String err = "";
            try {
                DocumentConverter.createOfficeManager((String)this.officePath.getValue(), null);
                this.reportSuccess(this.officePath);
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                err = msg == null ? "" : msg.replaceAll(REGEX, "");
                this.officePath.error((Serializable)((Object)err));
            }
            return err.isEmpty();
        }

        private boolean checkAllPath() {
            boolean result = this.checkMagicPath();
            result = this.checkFfmpegPath() && result;
            result = this.checkSoxPath() && result;
            result = this.checkOfficePath() && result;
            this.isAllChecked = true;
            return result;
        }

        public boolean isLastStep() {
            return false;
        }

        public IDynamicWizardStep next() {
            if (!this.isAllChecked && !this.checkAllPath()) {
                return this;
            }
            return InstallWizard.this.paramsStep4;
        }

        public boolean isLastAvailable() {
            return this.isAllChecked;
        }

        public IDynamicWizardStep last() {
            return InstallWizard.this.installStep;
        }

        private String getToolPath(String inPath, String app) {
            StringBuilder path = new StringBuilder();
            if (!Strings.isEmpty((CharSequence)inPath)) {
                path.append(inPath);
                if (!inPath.endsWith(File.separator)) {
                    path.append(File.separator);
                }
            }
            path.append(app);
            return path.toString();
        }
    }

    private final class ParamsStep2
    extends BaseStep {
        private static final long serialVersionUID = 1L;

        public ParamsStep2() {
            super((IDynamicWizardStep)InstallWizard.this.paramsStep1);
        }

        @Override
        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{new CheckBox("allowFrontendRegister")});
            this.add(new Component[]{new CheckBox("sendEmailAtRegister")});
            this.add(new Component[]{new CheckBox("sendEmailWithVerficationCode")});
            this.add(new Component[]{new CheckBox("createDefaultObjects")});
            this.add(new Component[]{new TextField("mailReferer")});
            this.add(new Component[]{new TextField("smtpServer")});
            this.add(new Component[]{new TextField("smtpPort").setRequired(true)});
            this.add(new Component[]{new TextField("mailAuthName")});
            this.add(new Component[]{new PasswordTextField("mailAuthPass").setResetPassword(false).setRequired(false)});
            this.add(new Component[]{new CheckBox("mailUseTls")});
            this.add(new Component[]{new CheckBox("replyToOrganizer")});
            this.add(new Component[]{new LangDropDown("defaultLangId")});
        }

        public boolean isLastStep() {
            return false;
        }

        public IDynamicWizardStep next() {
            return InstallWizard.this.paramsStep3;
        }

        public IDynamicWizardStep last() {
            return InstallWizard.this.installStep;
        }
    }

    private final class ParamsStep1
    extends BaseStep {
        private static final long serialVersionUID = 1L;
        private final TzDropDown tzDropDown;

        public ParamsStep1() {
            super(InstallWizard.this.dbStep);
            this.tzDropDown = new TzDropDown("timeZone");
        }

        @Override
        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{this.tzDropDown});
            this.add(new Component[]{new RequiredTextField("username").setLabel((IModel)new ResourceModel("install.wizard.params.step1.username")).add((IValidator)StringValidator.minimumLength((int)4))});
            this.add(new Component[]{new PasswordTextField("password").setResetPassword(false).setLabel((IModel)new ResourceModel("install.wizard.params.step1.password")).add((IValidator)new StrongPasswordValidator(new User()))});
            this.add(new Component[]{new RequiredTextField("email").setLabel((IModel)new ResourceModel("lbl.email")).add((IValidator)RfcCompliantEmailAddressValidator.getInstance())});
            this.add(new Component[]{new RequiredTextField("group").setLabel((IModel)new ResourceModel("install.wizard.params.step1.group"))});
        }

        public boolean isLastStep() {
            return false;
        }

        public boolean isLastAvailable() {
            return true;
        }

        public IDynamicWizardStep next() {
            return InstallWizard.this.paramsStep2;
        }

        public IDynamicWizardStep last() {
            return InstallWizard.this.installStep;
        }
    }

    private final class DbStep
    extends BaseStep {
        private static final long serialVersionUID = 1L;
        private final RequiredTextField<String> host;
        private final RequiredTextField<Integer> port;
        private final RequiredTextField<String> dbname;
        private final RequiredTextField<String> user;
        private final TextField<String> pass;
        private final Form<ConnectionProperties> form;

        public DbStep() {
            super(InstallWizard.this.welcomeStep);
            this.host = new RequiredTextField("host", (IModel)Model.of((Serializable)((Object)"")));
            this.port = new RequiredTextField("port", (IModel)Model.of((Serializable)Integer.valueOf(0)));
            this.dbname = new RequiredTextField("dbname", (IModel)Model.of((Serializable)((Object)"")));
            this.user = new RequiredTextField("login");
            this.pass = new TextField("password");
            this.form = new Form<ConnectionProperties>("form", (IModel)new CompoundPropertyModel((Object)this.getProps(null))){
                private static final long serialVersionUID = 1L;
                private final DropDownChoice<ConnectionProperties.DbType> db;
                {
                    this.db = new DropDownChoice("dbType", List.of(ConnectionProperties.DbType.values()), (IChoiceRenderer)new ChoiceRenderer<ConnectionProperties.DbType>(){
                        private static final long serialVersionUID = 1L;

                        public Object getDisplayValue(ConnectionProperties.DbType object) {
                            return this.getString(String.format("install.wizard.db.step.%s.name", object.dbName()));
                        }

                        public String getIdValue(ConnectionProperties.DbType object, int index) {
                            return object.name();
                        }
                    });
                }

                protected void onInitialize() {
                    super.onInitialize();
                    this.add(new Component[]{this.db.add(new Behavior[]{new OnChangeAjaxBehavior(){
                        private static final long serialVersionUID = 1L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            target.add(new Component[]{InstallWizard.this.feedback});
                            DbStep.this.initForm(true, target);
                        }
                    }})});
                    this.add(new Component[]{DbStep.this.host, DbStep.this.port, DbStep.this.dbname, DbStep.this.user, DbStep.this.pass});
                    this.add(new Component[]{new SpinnerAjaxButton("check", (IModel)new ResourceModel("install.wizard.db.step.check"), Buttons.Type.Outline_Primary){
                        private static final long serialVersionUID = 1L;

                        protected void onSubmit(AjaxRequestTarget target) {
                            target.add(new Component[]{InstallWizard.this.feedback});
                        }

                        protected void onError(AjaxRequestTarget target) {
                            target.add(new Component[]{InstallWizard.this.feedback});
                        }
                    }});
                }

                private String getDbName(ConnectionProperties props) {
                    return this.getString("install.wizard.db.step.instructions." + props.getDbType().dbName());
                }

                protected void onValidateModelObjects() {
                    ConnectionProperties props = (ConnectionProperties)this.getModelObject();
                    try {
                        Class.forName(props.getDriver());
                    }
                    catch (Exception e) {
                        DbStep.this.form.error((Serializable)new StringResourceModel("install.wizard.db.step.nodriver", (Component)InstallWizard.this).setParameters(new Object[]{this.getDbName(props)}).getObject());
                        return;
                    }
                    boolean valid = true;
                    ConnectionPropertiesPatcher.updateUrl((ConnectionProperties)props, (String)((String)DbStep.this.host.getModelObject()), (String)("" + DbStep.this.port.getModelObject()), (String)((String)DbStep.this.dbname.getModelObject()));
                    DriverManager.setLoginTimeout(3);
                    try (Connection conn = DriverManager.getConnection(props.getURL(), props.getLogin(), props.getPassword());){
                        valid = conn.isValid(0);
                        String sql = null;
                        switch (props.getDbType()) {
                            case DB2: {
                                sql = "select count(*) from systables";
                                break;
                            }
                            case ORACLE: {
                                sql = "SELECT 1 FROM DUAL";
                                break;
                            }
                            default: {
                                sql = "SELECT 1";
                            }
                        }
                        try (PreparedStatement ps = conn.prepareStatement(sql);){
                        }
                        if (!(valid &= ps.execute())) {
                            DbStep.this.form.error((Serializable)((Object)(this.getString("install.wizard.db.step.notvalid") + "<br/>" + this.getDbName(props))));
                        }
                    }
                    catch (Exception e) {
                        DbStep.this.form.error((Serializable)((Object)(e.getMessage() + "<br/>" + this.getDbName(props))));
                        log.error("error while testing DB", (Throwable)e);
                        valid = false;
                    }
                    if (valid) {
                        DbStep.this.form.success((Serializable)((Object)this.getString("install.wizard.db.step.valid")));
                    }
                }

                protected void onSubmit() {
                    try {
                        ConnectionPropertiesPatcher.patch((ConnectionProperties)((ConnectionProperties)this.getModelObject()));
                        XmlWebApplicationContext ctx = (XmlWebApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)Application.get().getServletContext());
                        if (ctx == null) {
                            DbStep.this.form.error((Serializable)new StringResourceModel("install.wizard.db.step.error.patch", (Component)InstallWizard.this).setParameters(new Object[]{"Web context is NULL"}).getObject());
                            log.error("Web context is NULL");
                            return;
                        }
                        LocalEntityManagerFactoryBean emb = (LocalEntityManagerFactoryBean)ctx.getBeanFactory().getBean(LocalEntityManagerFactoryBean.class);
                        emb.afterPropertiesSet();
                        InstallWizard.this.dbType = ((ConnectionProperties)this.getModelObject()).getDbType();
                    }
                    catch (Exception e) {
                        DbStep.this.form.error((Serializable)new StringResourceModel("install.wizard.db.step.error.patch", (Component)InstallWizard.this).setParameters(new Object[]{e.getMessage()}).getObject());
                        log.error("error while patching", (Throwable)e);
                    }
                }
            };
        }

        private ConnectionProperties getProps(ConnectionProperties.DbType type) {
            ConnectionProperties props = new ConnectionProperties();
            try {
                File conf = OmFileHelper.getPersistence((ConnectionProperties.DbType)type);
                if (!conf.exists() && type == null) {
                    return props;
                }
                props = ConnectionPropertiesPatcher.getConnectionProperties((File)conf);
                if (ConnectionProperties.DbType.H2 != props.getDbType()) {
                    props.setLogin(null);
                    props.setPassword(null);
                }
            }
            catch (Exception e) {
                this.form.warn((Serializable)((Object)this.getString("install.wizard.db.step.errorprops")));
            }
            return props;
        }

        private void initForm(boolean getProps, AjaxRequestTarget target) {
            ConnectionProperties props = getProps ? this.getProps(((ConnectionProperties)this.form.getModelObject()).getDbType()) : (ConnectionProperties)this.form.getModelObject();
            this.form.setModelObject((Object)props);
            this.host.setVisible(props.getDbType() != ConnectionProperties.DbType.H2);
            this.port.setVisible(props.getDbType() != ConnectionProperties.DbType.H2);
            this.user.setVisible(props.getDbType() != ConnectionProperties.DbType.H2);
            this.pass.setVisible(props.getDbType() != ConnectionProperties.DbType.H2);
            try {
                switch (props.getDbType()) {
                    case MSSQL: {
                        this.dbMssql(props);
                        break;
                    }
                    case ORACLE: {
                        this.dbOracle(props);
                        break;
                    }
                    case H2: {
                        this.dbH2(props);
                        break;
                    }
                    default: {
                        URI uri = URI.create(props.getURL().substring(5));
                        this.host.setModelObject((Object)uri.getHost());
                        this.port.setModelObject((Object)uri.getPort());
                        this.dbname.setModelObject((Object)uri.getPath().substring(1));
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.form.warn((Serializable)((Object)this.getString("install.wizard.db.step.errorprops")));
            }
            if (target != null) {
                target.add(new Component[]{this.form});
            }
        }

        private void dbMssql(ConnectionProperties props) {
            String url = props.getURL().substring("jdbc:sqlserver://".length());
            String[] parts = url.split(";");
            String[] hp = parts[0].split(":");
            this.host.setModelObject((Object)hp[0]);
            this.port.setModelObject((Object)Integer.parseInt(hp[1]));
            this.dbname.setModelObject((Object)parts[1].substring(parts[1].indexOf(61) + 1));
        }

        private void dbOracle(ConnectionProperties props) {
            String[] parts = props.getURL().split(":");
            this.host.setModelObject((Object)parts[3].substring(1));
            this.port.setModelObject((Object)Integer.parseInt(parts[4]));
            this.dbname.setModelObject((Object)parts[5]);
        }

        private void dbH2(ConnectionProperties props) {
            this.host.setModelObject((Object)"");
            this.port.setModelObject((Object)0);
            String[] parts = props.getURL().split(";");
            this.dbname.setModelObject((Object)parts[0].substring("jdbc:h2:".length()));
        }

        @Override
        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{this.form.setOutputMarkupId(true)});
            InstallWizard.this.initDbType = ((ConnectionProperties)this.form.getModelObject()).getDbType();
            this.initForm(false, null);
            this.add(new Component[]{new OmLabel("note", "install.wizard.db.step.note", ((InstallationConfig)InstallWizard.this.model.getObject()).getAppName(), this.getString("install.wizard.db.step.instructions.h2"), this.getString("install.wizard.db.step.instructions.mysql"), this.getString("install.wizard.db.step.instructions.postgresql"), this.getString("install.wizard.db.step.instructions.db2"), this.getString("install.wizard.db.step.instructions.mssql"), this.getString("install.wizard.db.step.instructions.oracle")).setEscapeModelStrings(false)});
        }

        public boolean isLastStep() {
            return false;
        }

        public IDynamicWizardStep next() {
            return InstallWizard.this.paramsStep1;
        }
    }

    private final class WelcomeStep
    extends BaseStep {
        private static final long serialVersionUID = 1L;

        public WelcomeStep() {
            super(null);
        }

        @Override
        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{new Label("step", (Serializable)((Object)this.getString("install.wizard.welcome.panel"))).setEscapeModelStrings(false)});
        }

        public boolean isLastStep() {
            return false;
        }

        public IDynamicWizardStep next() {
            return InstallWizard.this.dbStep;
        }
    }

    private abstract class BaseStep
    extends DynamicWizardStep {
        private static final long serialVersionUID = 1L;

        public BaseStep(IDynamicWizardStep prev) {
            super(prev);
        }

        protected void onInitialize() {
            super.onInitialize();
            this.setSummaryModel((IModel)Model.of((Serializable)((Object)"")));
            this.setTitleModel((IModel)Model.of((Serializable)((Object)(((InstallationConfig)InstallWizard.this.model.getObject()).getAppName() + " - " + this.getString("install.wizard.installation")))));
        }
    }
}

