/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import com.github.openjson.JSONObject;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.INavbarComponent;
import de.agilecoders.wicket.core.markup.html.references.BootstrapJavaScriptReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.PrivateMessage;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.BasePanel;
import org.apache.openmeetings.web.common.OmAjaxClientInfoBehavior;
import org.apache.openmeetings.web.common.OmWebSocketPanel;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.common.menu.MainMenuItem;
import org.apache.openmeetings.web.common.menu.MenuPanel;
import org.apache.openmeetings.web.common.menu.OmMenuItem;
import org.apache.openmeetings.web.pages.MainPage;
import org.apache.openmeetings.web.user.AboutDialog;
import org.apache.openmeetings.web.user.InviteUserToRoomDialog;
import org.apache.openmeetings.web.user.MessageDialog;
import org.apache.openmeetings.web.user.UserInfoDialog;
import org.apache.openmeetings.web.user.chat.ChatPanel;
import org.apache.openmeetings.web.user.rooms.RoomEnterBehavior;
import org.apache.openmeetings.web.util.CallbackFunctionHelper;
import org.apache.openmeetings.web.util.ContactsHelper;
import org.apache.openmeetings.web.util.ExtendedClientProperties;
import org.apache.openmeetings.web.util.OmUrlFragment;
import org.apache.openmeetings.web.util.ProfileImageResourceReference;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.devutils.debugbar.DebugBar;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.message.AbstractClientMessage;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.urlfragment.UrlFragment;

public class MainPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(MainPanel.class);
    private final WebMarkupContainer empty = new WebMarkupContainer("child");
    private String uid = null;
    private MenuPanel menu;
    private final WebMarkupContainer topControls = new WebMarkupContainer("topControls");
    private final WebMarkupContainer topLinks = new WebMarkupContainer("topLinks");
    private final MarkupContainer contents = new WebMarkupContainer("contents");
    private ChatPanel chat;
    private MessageDialog newMessage;
    private UserInfoDialog userInfo;
    private BasePanel panel;
    private InviteUserToRoomDialog inviteUser;
    @SpringBean
    private ClientManager cm;
    @SpringBean
    private ConfigurationDao cfgDao;
    @SpringBean
    private UserDao userDao;
    @SpringBean
    private RoomDao roomDao;

    public MainPanel(String id) {
        this(id, null);
    }

    public MainPanel(String id, BasePanel panel) {
        super(id);
        this.panel = panel;
        this.setAuto(true);
        this.setOutputMarkupId(true);
        this.setOutputMarkupPlaceholderTag(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new OmWebSocketPanel("ws-panel"){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                super.renderHead(response);
                StringBuilder handlers = new StringBuilder().append("Wicket.Event.subscribe(Wicket.Event.Topic.AJAX_CALL_FAILURE, hideBusyIndicator);").append("Wicket.Event.subscribe(Wicket.Event.Topic.AJAX_CALL_BEFORE, showBusyIndicator);").append("Wicket.Event.subscribe(Wicket.Event.Topic.AJAX_CALL_SUCCESS, hideBusyIndicator);").append("Wicket.Event.subscribe(Wicket.Event.Topic.AJAX_CALL_COMPLETE, hideBusyIndicator);").append("Wicket.Event.subscribe(Wicket.Event.Topic.WebSocket.Opened, function() { Wicket.WebSocket.send('socketConnected'); });");
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)handlers));
            }

            @Override
            protected void onConnect(ConnectedMessage msg) {
                ExtendedClientProperties cp = WebSession.get().getExtendedProperties();
                User u = MainPanel.this.userDao.get(WebSession.getUserId());
                Client client = new Client(this.getSession().getId(), msg.getKey().hashCode(), u, ProfileImageResourceReference.getUrl(this.getRequestCycle(), u));
                MainPanel.this.uid = client.getUid();
                MainPanel.this.cm.add(cp.update(client));
                log.debug("WebSocketBehavior::onConnect [uid: {}, session: {}, key: {}]", new Object[]{client.getUid(), msg.getSessionId(), msg.getKey()});
            }

            @Override
            protected void onConnect(WebSocketRequestHandler handler) {
                if (MainPanel.this.panel != null) {
                    MainPanel.this.updateContents(MainPanel.this.panel, (IPartialPageRequestHandler)handler);
                }
            }

            @Override
            protected void onMessage(WebSocketRequestHandler handler, JSONObject m) throws IOException {
                BasePanel p = MainPanel.this.getCurrentPanel();
                if (p != null) {
                    p.process((IPartialPageRequestHandler)handler, m);
                }
            }

            @Override
            protected void closeHandler(AbstractClientMessage msg) {
                log.debug("WebSocketBehavior::closeHandler uid - {}", (Object)MainPanel.this.uid);
                super.closeHandler(msg);
                if (MainPanel.this.uid != null) {
                    MainPanel.this.cm.exit(MainPanel.this.getClient());
                    MainPanel.this.uid = null;
                }
            }

            @Override
            protected IWsClient getWsClient() {
                return MainPanel.this.getClient();
            }
        }});
        this.menu = new MenuPanel("menu", this.getMainMenu());
        this.add(new Component[]{this.topControls.setOutputMarkupPlaceholderTag(true).setMarkupId("topControls")});
        this.add(new Component[]{this.contents.add(new Component[]{this.getClient() == null || this.panel == null ? this.empty : this.panel}).setOutputMarkupId(true).setMarkupId("contents")});
        this.topControls.add(new Component[]{this.menu.setVisible(false), this.topLinks.setVisible(false).setOutputMarkupPlaceholderTag(true).setMarkupId("topLinks")});
        final AboutDialog about = new AboutDialog("aboutDialog");
        this.topLinks.add(new Component[]{new AjaxLink<Void>("about"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                about.show((IPartialPageRequestHandler)target);
            }
        }});
        if (this.getApplication().getDebugSettings().isDevelopmentUtilitiesEnabled()) {
            this.add(new Component[]{new DebugBar("dev").setOutputMarkupId(true)});
        } else {
            this.add(new Component[]{new EmptyPanel("dev").setVisible(false)});
        }
        this.add(new Behavior[]{new OmAjaxClientInfoBehavior()});
        Component[] componentArray = new Component[2];
        componentArray[0] = about;
        this.chat = new ChatPanel("chatPanel");
        componentArray[1] = this.chat;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.newMessage = new MessageDialog("newMessageDialog", new CompoundPropertyModel((Object)new PrivateMessage())){
            private static final long serialVersionUID = 1L;

            @Override
            public void onSend(IPartialPageRequestHandler handler) {
                BasePanel bp = MainPanel.this.getCurrentPanel();
                if (bp != null) {
                    bp.onNewMessageClose(handler);
                }
            }
        };
        componentArray2[0] = this.newMessage;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.userInfo = new UserInfoDialog("userInfoDialog", this.newMessage);
        componentArray3[0] = this.userInfo;
        this.add(componentArray3);
        this.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                MainPanel.this.userInfo.show((IPartialPageRequestHandler)target, CallbackFunctionHelper.getParam(this.getComponent(), "userId").toLong());
            }

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CallbackFunctionHelper.getNamedFunction("showUserInfo", this, CallbackParameter.explicit((String)"userId"))));
            }
        }});
        this.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                ContactsHelper.addUserToContactList(CallbackFunctionHelper.getParam(this.getComponent(), "userId").toLong());
            }

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CallbackFunctionHelper.getNamedFunction("addContact", this, CallbackParameter.explicit((String)"userId"))));
            }
        }});
        this.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                MainPanel.this.newMessage.reset(true).show((IPartialPageRequestHandler)target, CallbackFunctionHelper.getParam(this.getComponent(), "userId").toOptionalLong());
            }

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CallbackFunctionHelper.getNamedFunction("privateMessage", this, CallbackParameter.explicit((String)"userId"))));
            }
        }});
        Component[] componentArray4 = new Component[1];
        this.inviteUser = new InviteUserToRoomDialog("invite-to-room");
        componentArray4[0] = this.inviteUser;
        this.add(componentArray4);
        this.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget target) {
                MainPanel.this.inviteUser.show((IPartialPageRequestHandler)target, CallbackFunctionHelper.getParam(this.getComponent(), "userId").toLong());
            }

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CallbackFunctionHelper.getNamedFunction("inviteUser", this, CallbackParameter.explicit((String)"userId"))));
            }
        }});
        AjaxLink<Void> logout = new AjaxLink<Void>("logout"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                this.getSession().invalidate();
                this.setResponsePage(Application.get().getSignInPageClass());
            }
        };
        logout.add(new Behavior[]{ConfirmationHelper.newOkCancelConfirm((Component)this, this.getString("634"))});
        this.topLinks.add(new Component[]{logout});
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapJavaScriptReference.instance())));
        super.renderHead(response);
    }

    private OmMenuItem getSubItem(String lbl, String title, OmUrlFragment.MenuActions action) {
        return new MainMenuItem(lbl, title, action){
            private static final long serialVersionUID = 1L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                this.onClick(MainPanel.this, target);
            }
        };
    }

    private List<INavbarComponent> getMainMenu() {
        ArrayList<INavbarComponent> mmenu = new ArrayList<INavbarComponent>();
        this.createDashboardMenu(mmenu);
        this.createRoomsMenu(mmenu);
        if (OpenmeetingsVariables.isRecordingsEnabled()) {
            mmenu.add(this.getSubItem("395", "1452", OmUrlFragment.MenuActions.RECORD));
        }
        this.createSettingsMenu(mmenu);
        Set<User.Right> r = WebSession.getRights();
        if (r.stream().anyMatch(right -> right.name().contains("ADMIN"))) {
            boolean isAdmin = AuthLevelUtil.hasAdminLevel(r);
            boolean isGrpAdmin = AuthLevelUtil.hasGroupAdminLevel(r);
            ArrayList<INavbarComponent> l = new ArrayList<INavbarComponent>();
            if (isAdmin || isGrpAdmin) {
                l.add(this.getSubItem("125", "1454", OmUrlFragment.MenuActions.ADMIN_USER));
            }
            if (isAdmin || r.contains(User.Right.ADMIN_CONNECTIONS)) {
                l.add(this.getSubItem("597", "1455", OmUrlFragment.MenuActions.ADMIN_CONNECTION));
            }
            if (isAdmin || isGrpAdmin) {
                l.add(this.getSubItem("126", "1456", OmUrlFragment.MenuActions.ADMIN_GROUP));
                l.add(this.getSubItem("186", "1457", OmUrlFragment.MenuActions.ADMIN_ROOM));
            }
            if (isAdmin || r.contains(User.Right.ADMIN_CONFIG)) {
                l.add(this.getSubItem("263", "1458", OmUrlFragment.MenuActions.ADMIN_CONFIG));
            }
            if (isAdmin || r.contains(User.Right.ADMIN_LABEL)) {
                l.add(this.getSubItem("348", "1459", OmUrlFragment.MenuActions.ADMIN_LABEL));
            }
            if (isAdmin) {
                l.add(this.getSubItem("1103", "1454", OmUrlFragment.MenuActions.ADMIN_LDAP));
                l.add(this.getSubItem("1571", "1572", OmUrlFragment.MenuActions.ADMIN_OAUTH));
            }
            if (isAdmin || r.contains(User.Right.ADMIN_BACKUP)) {
                l.add(this.getSubItem("367", "1461", OmUrlFragment.MenuActions.ADMIN_BACKUP));
            }
            if (isAdmin) {
                l.add(this.getSubItem("main.menu.admin.email", "main.menu.admin.email.desc", OmUrlFragment.MenuActions.ADMIN_EMAIL));
            }
            if (isAdmin || isGrpAdmin) {
                l.add(this.getSubItem("main.menu.admin.extra", "main.menu.admin.extra.desc", OmUrlFragment.MenuActions.ADMIN_EXTRA));
            }
            mmenu.add(new OmMenuItem(this.getString("6"), l));
        }
        return mmenu;
    }

    private void createDashboardMenu(List<INavbarComponent> mmenu) {
        ArrayList<INavbarComponent> l = new ArrayList<INavbarComponent>();
        l.add(this.getSubItem("290", "1450", OmUrlFragment.MenuActions.DASHBOARD_START));
        l.add(this.getSubItem("291", "1451", OmUrlFragment.MenuActions.DASHBOARD_CALENDAR));
        mmenu.add(new OmMenuItem(this.getString("124"), l));
    }

    private void createRoomsMenu(List<INavbarComponent> mmenu) {
        List recent;
        ArrayList<INavbarComponent> l = new ArrayList<INavbarComponent>();
        l.add(this.getSubItem("777", "1506", OmUrlFragment.MenuActions.ROOMS_PUBLIC));
        l.add(this.getSubItem("779", "1507", OmUrlFragment.MenuActions.ROOMS_GROUP));
        if (OpenmeetingsVariables.isMyRoomsEnabled()) {
            l.add(this.getSubItem("781", "1508", OmUrlFragment.MenuActions.ROOMS_MY));
        }
        if (!(recent = this.roomDao.getRecent(WebSession.getUserId())).isEmpty()) {
            l.add(new OmMenuItem(null, (String)null));
        }
        for (Room r : recent) {
            final Long roomId = r.getId();
            l.add(new OmMenuItem(r.getName(), r.getName()){
                private static final long serialVersionUID = 1L;

                @Override
                protected void onClick(AjaxRequestTarget target) {
                    RoomEnterBehavior.roomEnter((MainPage)MainPanel.this.getPage(), (IPartialPageRequestHandler)target, roomId);
                }
            });
        }
        mmenu.add(new OmMenuItem(this.getString("792"), l));
    }

    private void createSettingsMenu(List<INavbarComponent> mmenu) {
        ArrayList<INavbarComponent> l = new ArrayList<INavbarComponent>();
        l.add(this.getSubItem("1188", "1188", OmUrlFragment.MenuActions.PROFILE_MESSAGE));
        l.add(this.getSubItem("377", "377", OmUrlFragment.MenuActions.PROFILE_EDIT));
        l.add(this.getSubItem("1172", "1172", OmUrlFragment.MenuActions.PROFILE_SEARCH));
        l.add(this.getSubItem("profile.invitations", "profile.invitations", OmUrlFragment.MenuActions.PROFILE_INVITATION));
        l.add(this.getSubItem("1548", "1548", OmUrlFragment.MenuActions.PROFILE_WIDGET));
        mmenu.add(new OmMenuItem(this.getString("4"), l));
    }

    public void updateContents(OmUrlFragment f, IPartialPageRequestHandler handler) {
        this.updateContents(f, handler, true);
    }

    private BasePanel getCurrentPanel() {
        Component prev = this.contents.get("child");
        if (prev instanceof BasePanel) {
            return (BasePanel)prev;
        }
        return null;
    }

    public void updateContents(OmUrlFragment f, IPartialPageRequestHandler handler, boolean updateFragment) {
        BasePanel npanel = OmUrlFragment.getPanel(f.getArea(), f.getType());
        log.debug("updateContents:: npanels IS null ? {}, client IS null ? {}", (Object)(npanel == null ? 1 : 0), (Object)(this.getClient() == null ? 1 : 0));
        if (npanel != null) {
            if (this.getClient() != null) {
                this.updateContents(npanel, handler);
            } else {
                this.panel = npanel;
            }
            if (updateFragment) {
                UrlFragment uf = new UrlFragment(handler);
                uf.set(f.getArea().name(), (Object)f.getType());
            }
        }
    }

    private void updateContents(BasePanel inPanel, IPartialPageRequestHandler handler) {
        if (inPanel != null) {
            BasePanel prev = this.getCurrentPanel();
            if (prev != null) {
                prev.cleanup(handler);
            }
            handler.add(new Component[]{this.contents.replace((Component)inPanel)});
            handler.appendJavaScript((CharSequence)("$('#" + this.getMarkupId() + "').attr('class', 'main " + inPanel.getCssClass() + "');"));
            inPanel.onMenuPanelLoad(handler);
        }
    }

    public MenuPanel getMenu() {
        return this.menu;
    }

    public WebMarkupContainer getTopLinks() {
        return this.topLinks;
    }

    public WebMarkupContainer getTopControls() {
        return this.topControls;
    }

    public ChatPanel getChat() {
        return this.chat;
    }

    public MessageDialog getMessageDialog() {
        return this.newMessage;
    }

    public String getUid() {
        return this.uid;
    }

    public Client getClient() {
        return this.cm.get(this.uid);
    }
}

