/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Response;

public class GroupChoiceProvider
extends ChoiceProvider<Group> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private GroupDao groupDao;
    @SpringBean
    private UserDao userDao;

    public GroupChoiceProvider() {
        Injector.get().inject((Object)this);
    }

    public void query(String term, int page, Response<Group> response) {
        if (WebSession.getRights().contains(User.Right.ADMIN)) {
            List groups = this.groupDao.get(0L, Integer.MAX_VALUE);
            for (Group g : groups) {
                if (!Strings.isEmpty((CharSequence)term) && !g.getName().toLowerCase(Locale.ROOT).contains(term.toLowerCase(Locale.ROOT))) continue;
                response.add((Object)g);
            }
        } else {
            User u = this.userDao.get(WebSession.getUserId());
            for (GroupUser ou : u.getGroupUsers()) {
                if (!Strings.isEmpty((CharSequence)term) && !ou.getGroup().getName().toLowerCase(Locale.ROOT).contains(term.toLowerCase(Locale.ROOT))) continue;
                response.add((Object)ou.getGroup());
            }
        }
    }

    public Collection<Group> toChoices(Collection<String> ids) {
        ArrayList<Group> c = new ArrayList<Group>();
        for (String id : ids) {
            c.add(this.groupDao.get(Long.valueOf(id)));
        }
        return c;
    }

    public String getDisplayValue(Group choice) {
        return choice.getName();
    }

    public String getIdValue(Group choice) {
        Long id = choice.getId();
        return id == null ? null : "" + id;
    }
}

