/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.labels;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.entity.label.StringLabel;
import org.apache.openmeetings.web.admin.AdminBasePanel;
import org.apache.openmeetings.web.admin.SearchableDataView;
import org.apache.openmeetings.web.admin.labels.AddLanguageDialog;
import org.apache.openmeetings.web.admin.labels.LabelsForm;
import org.apache.openmeetings.web.admin.labels.LangForm;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.common.PagedEntityListPanel;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.data.DataViewContainer;
import org.apache.openmeetings.web.data.OmOrderByBorder;
import org.apache.openmeetings.web.data.SearchableDataProvider;
import org.apache.openmeetings.web.util.upload.BootstrapFileUploadBehavior;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.AjaxDownloadBehavior;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthorizeInstantiation(value={"ADMIN", "ADMIN_LABEL"})
public class LangPanel
extends AdminBasePanel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(LangPanel.class);
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private LangForm langForm;
    private final FileUploadField fileUploadField = new FileUploadField("fileInput");
    final WebMarkupContainer listContainer = new WebMarkupContainer("listContainer");
    Map.Entry<Long, Locale> language;

    public LangPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        this.add(new Component[]{this.feedback.setOutputMarkupId(true)});
        this.language = new AbstractMap.SimpleEntry<Long, Locale>(1L, Locale.ENGLISH);
        final LabelsForm form = new LabelsForm("form", this, new StringLabel(null, null));
        this.add(new Component[]{form});
        final SearchableDataView<StringLabel> dataView = new SearchableDataView<StringLabel>("langList", (SearchableDataProvider)new SearchableDataProvider<StringLabel>(LabelDao.class){
            private static final long serialVersionUID = 1L;

            @Override
            public long size() {
                return LabelDao.count((Locale)LangPanel.this.language.getValue(), (String)this.search);
            }

            @Override
            public Iterator<? extends StringLabel> iterator(long first, long count) {
                return LabelDao.get((Locale)LangPanel.this.language.getValue(), (String)this.search, (long)first, (long)count, (SortParam)this.getSort()).iterator();
            }
        }){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<StringLabel> item) {
                StringLabel fv = (StringLabel)item.getModelObject();
                item.add(new Component[]{new Label("key")});
                item.add(new Component[]{new Label("value")});
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    form.setModelObject(fv);
                    form.setNewRecordVisible(false);
                    target.add(new Component[]{form, LangPanel.this.listContainer});
                })});
                item.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)LangPanel.this.getRowClass(fv.getId(), ((StringLabel)form.getModelObject()).getId()))});
            }
        };
        this.add(new Component[]{this.listContainer.add(new Component[]{dataView}).setOutputMarkupId(true)});
        PagedEntityListPanel navigator = new PagedEntityListPanel("navigator", dataView){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                dataView.modelChanging();
                target.add(new Component[]{LangPanel.this.listContainer});
            }
        };
        DataViewContainer<StringLabel> container = new DataViewContainer<StringLabel>(this.listContainer, dataView, navigator);
        container.addLink(new OmOrderByBorder<StringLabel>("orderByName", "key", container)).addLink(new OmOrderByBorder<StringLabel>("orderByValue", "value", container));
        this.add((Component[])container.getLinks());
        this.add(new Component[]{navigator});
        this.langForm = new LangForm("langForm", this.listContainer, this);
        this.langForm.add(new Component[]{this.fileUploadField});
        this.fileUploadField.add(new Behavior[]{new AjaxFormSubmitBehavior(this.langForm, "change"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                FileUpload upload = LangPanel.this.fileUploadField.getFileUpload();
                try {
                    if (upload == null || upload.getInputStream() == null) {
                        LangPanel.this.feedback.error((Serializable)((Object)"File is empty"));
                        return;
                    }
                    LabelDao.upload((Locale)LangPanel.this.language.getValue(), (InputStream)upload.getInputStream());
                }
                catch (Exception e) {
                    log.error("Exception on panel language editor import ", (Throwable)e);
                    LangPanel.this.feedback.error((Serializable)e);
                }
                target.add(new Component[]{LangPanel.this.listContainer, LangPanel.this.feedback});
            }
        }});
        final AjaxDownloadBehavior download = new AjaxDownloadBehavior((IResource)new ResourceStreamResource(){
            private static final long serialVersionUID = 1L;
            {
                this.setContentDisposition(ContentDisposition.ATTACHMENT);
                this.setCacheDuration(Duration.ZERO);
            }

            protected IResourceStream getResourceStream(IResource.Attributes attributes) {
                final String name = LabelDao.getLabelFileName((Locale)LangPanel.this.language.getValue());
                this.setFileName(name);
                return new AbstractResourceStream(){
                    private static final long serialVersionUID = 1L;
                    private transient InputStream is;

                    public InputStream getInputStream() throws ResourceStreamNotFoundException {
                        try {
                            this.is = Application.class.getResourceAsStream(name);
                            return this.is;
                        }
                        catch (Exception e) {
                            throw new ResourceStreamNotFoundException((Throwable)e);
                        }
                    }

                    public void close() throws IOException {
                        if (this.is != null) {
                            this.is.close();
                            this.is = null;
                        }
                    }
                };
            }
        });
        this.langForm.add(new Behavior[]{download});
        this.langForm.add(new Component[]{new BootstrapAjaxLink<String>("export", null, Buttons.Type.Outline_Primary, (IModel)new ResourceModel("360")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                download.initiate((IPartialPageRequestHandler)target);
                target.add(new Component[]{LangPanel.this.feedback});
            }
        }});
        final AddLanguageDialog addLang = new AddLanguageDialog("addLang", this);
        this.add(new Component[]{this.langForm, addLang});
        this.langForm.add(new Component[]{new AjaxLink<Void>("addLangBtn"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                addLang.show((IPartialPageRequestHandler)target);
            }
        }});
        this.add(new Behavior[]{BootstrapFileUploadBehavior.INSTANCE});
        BootstrapAjaxButton delLngBtn = new BootstrapAjaxButton("deleteLangBtn", Buttons.Type.Outline_Danger){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                LabelDao.delete((Locale)LangPanel.this.language.getValue());
                List<Map.Entry<Long, Locale>> langs = LangForm.getLanguages();
                LangPanel.this.language = langs.isEmpty() ? null : langs.get(0);
                LangPanel.this.langForm.updateLanguages(target);
                target.add(new Component[]{LangPanel.this.listContainer});
            }
        };
        this.langForm.add(new Component[]{delLngBtn.setIconType((IconType)FontAwesome5IconType.times_s).add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))})});
        super.onInitialize();
    }

    public LangForm getLangForm() {
        return this.langForm;
    }
}

