/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.groups;

import de.agilecoders.wicket.core.markup.html.bootstrap.badge.BootstrapBadge;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.BackgroundColorBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.openmeetings.db.dao.user.GroupUserDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.web.admin.SearchableDataView;
import org.apache.openmeetings.web.admin.groups.GroupForm;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.PagedEntityListPanel;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.data.SearchableDataProvider;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class GroupUsersPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private long groupId;
    private List<GroupUser> users2add = new ArrayList<GroupUser>();
    @SpringBean
    private UserDao userDao;

    public GroupUsersPanel(String id, long groupId) {
        super(id);
        this.groupId = groupId;
        this.setOutputMarkupId(true);
        SearchableDataView<GroupUser> dataView = new SearchableDataView<GroupUser>("userList", (SearchableDataProvider)new GroupUserDataProvider()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<GroupUser> item) {
                final GroupUser grpUser = (GroupUser)item.getModelObject();
                item.add(new Component[]{new CheckBox("isModerator").add(new Behavior[]{new OnChangeAjaxBehavior(){
                    private static final long serialVersionUID = 1L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        if (grpUser.getId() != null) {
                            GroupUsersPanel.this.update(grpUser);
                        }
                    }
                }})});
                User u = grpUser.getUser();
                Label label = new Label("label", (Serializable)((Object)(u == null ? "" : GroupForm.formatUser(u))));
                item.add(new Component[]{label});
                BootstrapAjaxLink<String> del = new BootstrapAjaxLink<String>("deleteUserBtn", Buttons.Type.Outline_Danger){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        if (grpUser.getId() == null) {
                            GroupUsersPanel.this.users2add.remove(grpUser);
                        } else {
                            User u = GroupUsersPanel.this.userDao.get(grpUser.getUser().getId());
                            u.getGroupUsers().remove(grpUser);
                            GroupUsersPanel.this.userDao.update(u, WebSession.getUserId());
                        }
                        target.add(new Component[]{GroupUsersPanel.this});
                    }
                };
                del.setIconType((IconType)FontAwesome5IconType.times_s).add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("833"))});
                item.add(new Component[]{del});
                item.add(new Component[]{new BootstrapBadge("new", (IModel)new ResourceModel("lbl.new"), BackgroundColorBehavior.Color.Warning).setVisible(grpUser.getId() == null)});
            }
        };
        this.add(new Component[]{dataView}).setOutputMarkupId(true);
        this.add(new Component[]{new PagedEntityListPanel("navigator", dataView){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                target.add(new Component[]{GroupUsersPanel.this});
            }
        }});
    }

    public void update(GroupUser grpUser) {
        User u = this.userDao.get(grpUser.getUser().getId());
        int idx = u.getGroupUsers().indexOf(grpUser);
        if (idx > -1) {
            ((GroupUser)u.getGroupUsers().get(idx)).setModerator(grpUser.isModerator());
        } else {
            u.getGroupUsers().add(grpUser);
        }
        this.userDao.update(u, WebSession.getUserId());
    }

    void update(long groupId) {
        this.groupId = groupId;
        this.users2add.clear();
    }

    List<GroupUser> getUsers2add() {
        return this.users2add;
    }

    private class GroupUserDataProvider
    extends SearchableDataProvider<GroupUser> {
        private static final long serialVersionUID = 1L;

        GroupUserDataProvider() {
            super(GroupUserDao.class);
        }

        protected GroupUserDao getDao() {
            return (GroupUserDao)super.getDao();
        }

        @Override
        public long size() {
            return (long)GroupUsersPanel.this.users2add.size() + (this.search == null ? this.getDao().count(GroupUsersPanel.this.groupId) : this.getDao().count(this.search));
        }

        @Override
        public Iterator<? extends GroupUser> iterator(long first, long count) {
            ArrayList<GroupUser> list = new ArrayList<GroupUser>();
            list.addAll(GroupUsersPanel.this.users2add);
            list.addAll(this.search == null && this.getSort() == null ? this.getDao().get(GroupUsersPanel.this.groupId, first, count) : this.getDao().get(GroupUsersPanel.this.groupId, this.search, first, count, this.getSortStr()));
            return list.iterator();
        }
    }
}

