/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.cli;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.openmeetings.cli.CleanupEntityUnit;
import org.apache.openmeetings.cli.CleanupUnit;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OmFileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupHelper {
    private static final Logger log = LoggerFactory.getLogger(CleanupHelper.class);
    private static File hibernateDir = OmFileHelper.getStreamsHibernateDir();

    private CleanupHelper() {
    }

    public static CleanupEntityUnit getProfileUnit(UserDao udao) {
        File parent = OmFileHelper.getUploadProfilesDir();
        ArrayList<File> invalid = new ArrayList<File>();
        ArrayList<File> deleted = new ArrayList<File>();
        int missing = 0;
        for (File profile : CleanupHelper.list(parent, null)) {
            long userId = CleanupHelper.getUserIdByProfile(profile.getName());
            User u = (User)udao.get(userId);
            if (profile.isFile() || userId < 0L || u == null) {
                invalid.add(profile);
                continue;
            }
            if (!u.isDeleted()) continue;
            deleted.add(profile);
        }
        for (User u : udao.getAllBackupUsers()) {
            if (u.isDeleted() || u.getPictureUri() == null || new File(OmFileHelper.getUploadProfilesUserDir((Long)u.getId()), u.getPictureUri()).exists()) continue;
            ++missing;
        }
        return new CleanupEntityUnit(parent, invalid, deleted, missing);
    }

    public static CleanupUnit getImportUnit() {
        return new CleanupUnit(OmFileHelper.getUploadImportDir());
    }

    public static CleanupUnit getBackupUnit() {
        return new CleanupUnit(OmFileHelper.getUploadBackupDir());
    }

    public static CleanupEntityUnit getFileUnit(FileItemDao fileDao) {
        File parent = OmFileHelper.getUploadFilesDir();
        ArrayList<File> invalid = new ArrayList<File>();
        ArrayList<File> deleted = new ArrayList<File>();
        int missing = 0;
        for (File f : CleanupHelper.list(parent, null)) {
            FileItem item = fileDao.getByHash(f.getName());
            if (item == null) {
                invalid.add(f);
                continue;
            }
            if (!item.isDeleted()) continue;
            deleted.add(f);
        }
        for (FileItem item : fileDao.get()) {
            if (item.isDeleted() || item.exists()) continue;
            ++missing;
        }
        return new CleanupEntityUnit(parent, invalid, deleted, missing);
    }

    public static CleanupEntityUnit getRecUnit(RecordingDao recordDao) {
        File parent = OmFileHelper.getStreamsDir();
        ArrayList invalid = new ArrayList();
        ArrayList deleted = new ArrayList();
        int missing = 0;
        for (File f : CleanupHelper.list(hibernateDir, (dir, name) -> name.endsWith("mp4"))) {
            if (!f.isFile()) {
                log.warn("Recording found is not a file: {}", (Object)f);
                continue;
            }
            String hash = f.getName().substring(0, f.getName().length() - "mp4".length() - 1);
            Recording item = recordDao.getByHash(hash);
            if (item == null) {
                Collections.addAll(invalid, CleanupHelper.list(hash));
                continue;
            }
            if (!item.isDeleted()) continue;
            Collections.addAll(deleted, CleanupHelper.list(hash));
        }
        for (Recording item : recordDao.get()) {
            if (item.isDeleted() || item.getHash() == null || CleanupHelper.list(item.getHash()).length != 0) continue;
            ++missing;
        }
        return new CleanupEntityUnit(parent, (List)invalid, (List)deleted, missing){
            private static final long serialVersionUID = 1L;

            @Override
            public void cleanup() throws IOException {
                String hiberPath = hibernateDir.getCanonicalPath();
                for (File f : CleanupHelper.list(this.getParent(), null)) {
                    if (f.getCanonicalPath().equals(hiberPath)) continue;
                    FileUtils.deleteQuietly((File)f);
                }
                super.cleanup();
            }
        };
    }

    private static File[] list(File f, FilenameFilter ff) {
        File[] l = ff == null ? f.listFiles() : f.listFiles(ff);
        return l == null ? new File[]{} : l;
    }

    private static File[] list(String hash) {
        return CleanupHelper.list(hibernateDir, (dir, name) -> name.startsWith(hash));
    }

    private static long getUserIdByProfile(String name) {
        long result = -1L;
        if (name.startsWith("profile_")) {
            try {
                result = Long.parseLong(name.substring("profile_".length()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

