/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.schema.SchemaTool;
import org.apache.openjpa.lib.log.LogFactoryImpl;
import org.apache.openmeetings.backup.BackupExport;
import org.apache.openmeetings.backup.BackupImport;
import org.apache.openmeetings.backup.ProgressHolder;
import org.apache.openmeetings.cli.CleanupEntityUnit;
import org.apache.openmeetings.cli.CleanupHelper;
import org.apache.openmeetings.cli.CleanupUnit;
import org.apache.openmeetings.cli.ConnectionPropertiesPatcher;
import org.apache.openmeetings.cli.ExitException;
import org.apache.openmeetings.cli.OmHelpFormatter;
import org.apache.openmeetings.cli.OmOption;
import org.apache.openmeetings.core.ldap.LdapLoginManager;
import org.apache.openmeetings.core.util.StrongPasswordValidator;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.ApplicationHelper;
import org.apache.openmeetings.installation.ImportInitvalues;
import org.apache.openmeetings.installation.InstallationConfig;
import org.apache.openmeetings.util.CalendarPatterns;
import org.apache.openmeetings.util.ConnectionProperties;
import org.apache.openmeetings.util.ImportHelper;
import org.apache.openmeetings.util.OmException;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.mail.MailUtil;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.Validatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.web.context.WebApplicationContext;

public class Admin {
    private static final Logger log = LoggerFactory.getLogger(Admin.class);
    private static final String OPTION_EMAIL = "email";
    private static final String OPTION_GROUP = "group";
    private static final String OPTION_PWD = "password";
    private static final String OPTION_DEF_LNG = "default-language";
    private static final String OPTION_DB_TYPE = "db-type";
    private static final String OPTION_DB_HOST = "db-host";
    private static final String OPTION_DB_PORT = "db-port";
    private static final String OPTION_DB_NAME = "db-name";
    private static final String OPTION_DB_USER = "db-user";
    private static final String OPTION_DB_PASS = "db-pass";
    private static final String OPTION_MAIL_REFERRER = "system-email-address";
    private static final String OPTION_MAIL_SERVER = "smtp-server";
    private static final String OPTION_MAIL_PORT = "smtp-port";
    private static final String OPTION_MAIL_USER = "email-auth-user";
    private static final String OPTION_MAIL_PASS = "email-auth-pass";
    private static final String REP_INVALID = "\t\t\tinvalid: ";
    private static final String REP_DELETED = "\t\t\tdeleted: ";
    private static final String REP_MISSING = "\t\t\tmissing count: ";
    public static final String OM_HOME = "om_home";
    private boolean verbose = false;
    private InstallationConfig cfg = new InstallationConfig();
    private Options opts = this.buildOptions();
    private CommandLine cmdl = null;
    private WebApplicationContext context = null;
    private File home;
    private String step = "Initialization";

    Admin() {
        if (!System.getProperties().containsKey("context")) {
            Admin.doLog(String.format("System.property 'context' is not set, defaulting to %s", "openmeetings"));
        }
        String ctxName = System.getProperty("context", "openmeetings");
        OpenmeetingsVariables.setWicketApplicationName((String)ctxName);
        this.home = new File(System.getProperty(OM_HOME));
        if (OmFileHelper.getOmHome() == null) {
            OmFileHelper.setOmHome((File)new File(new File(this.home, "webapps"), ctxName));
        }
    }

    private static void doLog(CharSequence msg) {
        log.info("{}", (Object)msg);
        System.out.println(msg);
    }

    private Options buildOptions() {
        Options options = new Options();
        OptionGroup group = new OptionGroup().addOption((Option)new OmOption("h", 0, "h", "help", false, "prints this message")).addOption((Option)new OmOption("b", 1, "b", "backup", false, "Backups OM")).addOption((Option)new OmOption("r", 2, "r", "restore", false, "Restores OM")).addOption((Option)new OmOption("i", 3, "i", "install", false, "Fill DB table, and make OM usable")).addOption((Option)new OmOption("l", 3, "l", "ldap", false, "Import LDAP users into DB")).addOption((Option)new OmOption("f", 4, "f", "files", false, "File operations - statictics/cleanup"));
        group.setRequired(true);
        options.addOptionGroup(group);
        options.addOption((Option)new OmOption(null, "v", "verbose", false, "verbose error messages"));
        options.addOption((Option)new OmOption("b", null, "exclude-files", false, "should backup exclude files [default: include]", true));
        options.addOption((Option)new OmOption("b,r,i", "file", null, true, "file used for backup/restore/install", "b"));
        options.addOption((Option)new OmOption("i", "user", null, true, "Login name of the default user, minimum 4 characters (mutually exclusive with 'file')"));
        options.addOption((Option)new OmOption("i", OPTION_EMAIL, null, true, "Email of the default user (mutually exclusive with 'file')"));
        options.addOption((Option)new OmOption("i", OPTION_GROUP, null, true, "The name of the default user group (mutually exclusive with 'file')"));
        options.addOption((Option)new OmOption("i", "tz", null, true, "Default server time zone, and time zone for the selected user (mutually exclusive with 'file')"));
        options.addOption((Option)new OmOption("i", null, OPTION_PWD, true, "Password of the default user, minimum 8 characters (will be prompted if not set)", true));
        options.addOption((Option)new OmOption("i", null, OPTION_MAIL_REFERRER, true, String.format("System e-mail address [default: %s]", this.cfg.getMailReferer()), true));
        options.addOption((Option)new OmOption("i", null, OPTION_MAIL_SERVER, true, String.format("SMTP server for outgoing e-mails [default: %s]", this.cfg.getSmtpServer()), true));
        options.addOption((Option)new OmOption("i", null, OPTION_MAIL_PORT, true, String.format("SMTP server for outgoing e-mails [default: %s]", this.cfg.getSmtpPort()), true));
        options.addOption((Option)new OmOption("i", null, OPTION_MAIL_USER, true, "Email auth username (anonymous connection will be used if not set)", true));
        options.addOption((Option)new OmOption("i", null, OPTION_MAIL_PASS, true, "Email auth password (anonymous connection will be used if not set)", true));
        options.addOption((Option)new OmOption("i", null, "email-use-tls", false, "Is secure e-mail connection [default: no]", true));
        options.addOption((Option)new OmOption("i", null, "skip-default-objects", false, "Do not create default rooms and OAuth servers [created by default]", true));
        options.addOption((Option)new OmOption("i", null, "disable-frontend-register", false, "Do not allow front end register [allowed by default]", true));
        options.addOption((Option)new OmOption("i", null, OPTION_DEF_LNG, true, "Default system language as int [1 by default]", true));
        options.addOption((Option)new OmOption("i", null, OPTION_DB_TYPE, true, "The type of the DB to be used", true));
        options.addOption((Option)new OmOption("i", null, OPTION_DB_HOST, true, "DNS name or IP address of database", true));
        options.addOption((Option)new OmOption("i", null, OPTION_DB_PORT, true, "Database port", true));
        options.addOption((Option)new OmOption("i", null, OPTION_DB_NAME, true, "The name of Openmeetings database", true));
        options.addOption((Option)new OmOption("i", null, OPTION_DB_USER, true, "User with write access to the DB specified", true));
        options.addOption((Option)new OmOption("i", null, OPTION_DB_PASS, true, "Password of the user with write access to the DB specified", true));
        options.addOption((Option)new OmOption("i", null, "drop", false, "Drop database before installation", true));
        options.addOption((Option)new OmOption("i", null, "force", false, "Install without checking the existence of old data in the database.", true));
        options.addOption((Option)new OmOption("f", null, "cleanup", false, "Should intermediate files be clean up", true));
        options.addOption((Option)new OmOption("l", "d", "domain-id", true, "LDAP domain Id", false));
        options.addOption((Option)new OmOption("l", null, "print-only", false, "Print users found instead of importing", true));
        return options;
    }

    private void usage() {
        OmHelpFormatter formatter = new OmHelpFormatter();
        formatter.setWidth(100);
        formatter.printHelp("admin", "Please specify one of the required parameters.", this.opts, "Examples:\n\t./admin.sh -b\n\t./admin.sh -i -v -file backup_31_07_2012_12_07_51.zip --drop\n\t./admin.sh -i -v -user admin -email someemail@gmail.com -tz \"Asia/Tehran\" -group \"yourgroup\" --db-type mysql --db-host localhost");
    }

    private void handleError(Exception e) {
        this.handleError(e, false, true);
    }

    private void handleError(Exception e, boolean printUsage, boolean willThrow) {
        if (printUsage) {
            this.usage();
        }
        if (this.verbose) {
            String msg = String.format("%s failed", this.step);
            log.error(msg, (Throwable)e);
        } else {
            log.error("{} failed: {}", (Object)this.step, (Object)e.getMessage());
        }
        if (willThrow) {
            throw new ExitException();
        }
    }

    private WebApplicationContext getApplicationContext() {
        if (this.context == null) {
            String curStep = this.step;
            this.step = "Shutdown schedulers";
            Long lngId = this.cfg.getDefaultLangId();
            this.context = ApplicationHelper.getApplicationContext((Long)lngId);
            SchedulerFactoryBean sfb = (SchedulerFactoryBean)this.context.getBean(SchedulerFactoryBean.class);
            try {
                sfb.getScheduler().shutdown(false);
                this.step = curStep;
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }
        return this.context;
    }

    void process(String ... args) throws Exception {
        DefaultParser parser = new DefaultParser();
        try {
            this.cmdl = parser.parse(this.opts, args);
        }
        catch (ParseException e) {
            Admin.doLog(e.getMessage());
            this.usage();
            throw new ExitException();
        }
        this.verbose = this.cmdl.hasOption('v');
        Command cmd = Command.USAGE;
        if (this.cmdl.hasOption('i')) {
            cmd = Command.INSTALL;
        } else if (this.cmdl.hasOption('b')) {
            cmd = Command.BACKUP;
        } else if (this.cmdl.hasOption('r')) {
            cmd = Command.RESTORE;
        } else if (this.cmdl.hasOption('f')) {
            cmd = Command.FILES;
        } else if (this.cmdl.hasOption('l')) {
            cmd = Command.LDAP;
        }
        String file = this.cmdl.getOptionValue("file", "");
        switch (cmd) {
            case INSTALL: {
                this.step = "Install";
                this.processInstall(file);
                break;
            }
            case BACKUP: {
                this.step = "Backup";
                this.processBackup(file);
                break;
            }
            case RESTORE: {
                this.step = "Restore";
                this.processRestore(this.checkRestoreFile(file));
                break;
            }
            case FILES: {
                this.step = "Files";
                this.processFiles();
                break;
            }
            case LDAP: {
                this.step = "LDAP import";
                this.processLdap();
                break;
            }
            default: {
                this.usage();
            }
        }
    }

    private void processInstall(String file) throws Exception {
        ConnectionProperties connectionProperties;
        File conf;
        if (this.cmdl.hasOption("file") && (this.cmdl.hasOption("USER") || this.cmdl.hasOption(OPTION_EMAIL) || this.cmdl.hasOption(OPTION_GROUP))) {
            Admin.doLog("Please specify even 'file' option or 'admin USER'.");
            throw new ExitException();
        }
        boolean force = this.cmdl.hasOption("force");
        if (this.cmdl.hasOption("skip-default-objects")) {
            this.cfg.setCreateDefaultObjects(false);
        }
        if (this.cmdl.hasOption("disable-frontend-register")) {
            this.cfg.setAllowFrontendRegister(false);
        }
        if (this.cmdl.hasOption(OPTION_MAIL_REFERRER)) {
            this.cfg.setMailReferer(this.cmdl.getOptionValue(OPTION_MAIL_REFERRER));
        }
        if (this.cmdl.hasOption(OPTION_MAIL_SERVER)) {
            this.cfg.setSmtpServer(this.cmdl.getOptionValue(OPTION_MAIL_SERVER));
        }
        if (this.cmdl.hasOption(OPTION_MAIL_PORT)) {
            this.cfg.setSmtpPort(Integer.valueOf(this.cmdl.getOptionValue(OPTION_MAIL_PORT)));
        }
        if (this.cmdl.hasOption(OPTION_MAIL_USER)) {
            this.cfg.setMailAuthName(this.cmdl.getOptionValue(OPTION_MAIL_USER));
        }
        if (this.cmdl.hasOption(OPTION_MAIL_PASS)) {
            this.cfg.setMailAuthPass(this.cmdl.getOptionValue(OPTION_MAIL_PASS));
        }
        if (this.cmdl.hasOption("email-use-tls")) {
            this.cfg.setMailUseTls(true);
        }
        if (this.cmdl.hasOption(OPTION_DEF_LNG)) {
            this.cfg.setDefaultLangId(Integer.parseInt(this.cmdl.getOptionValue(OPTION_DEF_LNG)));
        }
        if (!(conf = OmFileHelper.getPersistence()).exists() || this.cmdl.hasOption(OPTION_DB_TYPE) || this.cmdl.hasOption(OPTION_DB_HOST) || this.cmdl.hasOption(OPTION_DB_PORT) || this.cmdl.hasOption(OPTION_DB_NAME) || this.cmdl.hasOption(OPTION_DB_USER) || this.cmdl.hasOption(OPTION_DB_PASS)) {
            String dbType = this.cmdl.getOptionValue(OPTION_DB_TYPE);
            connectionProperties = ConnectionPropertiesPatcher.patch(ConnectionProperties.DbType.of((String)dbType), this.cmdl.getOptionValue(OPTION_DB_HOST, "localhost"), this.cmdl.getOptionValue(OPTION_DB_PORT, null), this.cmdl.getOptionValue(OPTION_DB_NAME, null), this.cmdl.getOptionValue(OPTION_DB_USER, null), this.cmdl.getOptionValue(OPTION_DB_PASS, null));
        } else {
            connectionProperties = ConnectionPropertiesPatcher.getConnectionProperties(conf);
        }
        if (this.cmdl.hasOption("file")) {
            File backup = this.checkRestoreFile(file);
            this.dropDB(connectionProperties);
            ImportInitvalues importInit = (ImportInitvalues)this.getApplicationContext().getBean(ImportInitvalues.class);
            importInit.loadSystem(this.cfg, force);
            this.processRestore(backup);
        } else {
            this.checkAdminDetails();
            this.dropDB(connectionProperties);
            ImportInitvalues importInit = (ImportInitvalues)this.getApplicationContext().getBean(ImportInitvalues.class);
            importInit.loadAll(this.cfg, force);
        }
    }

    private void processBackup(String file) throws Exception {
        File f;
        if (!this.cmdl.hasOption("file")) {
            String fn = "backup_" + CalendarPatterns.getTimeForStreamId((Date)new Date()) + ".zip";
            f = new File(this.home, fn);
            Admin.doLog("File name was not specified, '" + fn + "' will be used");
        } else {
            f = new File(file);
        }
        boolean includeFiles = !this.cmdl.hasOption("exclude-files");
        File backupDir = new File(OmFileHelper.getUploadBackupDir(), String.valueOf(System.currentTimeMillis()));
        backupDir.mkdirs();
        BackupExport export = (BackupExport)this.getApplicationContext().getBean(BackupExport.class);
        export.performExport(f, includeFiles, new ProgressHolder());
        FileUtils.deleteDirectory((File)backupDir);
        backupDir.delete();
    }

    private void processFiles() throws IOException {
        boolean cleanup = this.cmdl.hasOption("cleanup");
        if (cleanup) {
            Admin.doLog("WARNING: all intermediate files will be clean up!");
        }
        StringBuilder report = new StringBuilder();
        this.reportUploads(report, cleanup);
        this.reportStreams(report, cleanup);
        Admin.doLog(report);
    }

    private void processLdap() throws OmException {
        if (!this.cmdl.hasOption("d")) {
            Admin.doLog("Please specify LDAP domain Id.");
            throw new ExitException();
        }
        Long domainId = Long.valueOf(this.cmdl.getOptionValue('d'));
        ((LdapLoginManager)this.getApplicationContext().getBean(LdapLoginManager.class)).importUsers(domainId, this.cmdl.hasOption("print-only"));
    }

    private void reportUploads(StringBuilder report, boolean cleanup) throws IOException {
        long sectionSize = OmFileHelper.getSize((File)OmFileHelper.getUploadDir());
        report.append("Upload totally allocates: ").append(OmFileHelper.getHumanSize((long)sectionSize)).append("\n");
        WebApplicationContext ctx = this.getApplicationContext();
        UserDao udao = (UserDao)ctx.getBean(UserDao.class);
        CleanupEntityUnit profile = CleanupHelper.getProfileUnit(udao);
        long restSize = sectionSize - profile.getSizeTotal();
        report.append("\t\tprofiles: ").append(profile.getHumanTotal()).append("\n");
        report.append(REP_INVALID).append(profile.getHumanInvalid()).append("\n");
        report.append(REP_DELETED).append(profile.getHumanDeleted()).append("\n");
        report.append(REP_MISSING).append(profile.getMissing()).append("\n");
        if (cleanup) {
            profile.cleanup();
        }
        CleanupUnit imp = CleanupHelper.getImportUnit();
        restSize -= imp.getSizeTotal();
        report.append("\t\timport: ").append(OmFileHelper.getHumanSize((long)imp.getSizeTotal())).append("\n");
        if (cleanup) {
            imp.cleanup();
        }
        CleanupUnit back = CleanupHelper.getBackupUnit();
        restSize -= back.getSizeTotal();
        report.append("\t\tbackup: ").append(OmFileHelper.getHumanSize((long)back.getSizeTotal())).append("\n");
        if (cleanup) {
            back.cleanup();
        }
        FileItemDao fileDao = (FileItemDao)ctx.getBean(FileItemDao.class);
        CleanupEntityUnit files = CleanupHelper.getFileUnit(fileDao);
        restSize -= files.getSizeTotal();
        report.append("\t\tfiles: ").append(files.getHumanTotal()).append("\n");
        report.append(REP_INVALID).append(files.getHumanInvalid()).append("\n");
        report.append(REP_DELETED).append(files.getHumanDeleted()).append("\n");
        report.append(REP_MISSING).append(files.getMissing()).append("\n");
        report.append("\t\trest: ").append(OmFileHelper.getHumanSize((long)restSize)).append("\n");
        if (cleanup) {
            files.cleanup();
        }
    }

    private void reportStreams(StringBuilder report, boolean cleanup) throws IOException {
        RecordingDao recordDao = (RecordingDao)this.getApplicationContext().getBean(RecordingDao.class);
        CleanupEntityUnit rec = CleanupHelper.getRecUnit(recordDao);
        File hibernateDir = OmFileHelper.getStreamsHibernateDir();
        report.append("Recordings allocates: ").append(rec.getHumanTotal()).append("\n");
        long size = OmFileHelper.getSize((File)hibernateDir);
        long restSize = rec.getSizeTotal() - size;
        report.append("\t\tfinal: ").append(OmFileHelper.getHumanSize((long)size)).append("\n");
        report.append(REP_INVALID).append(rec.getHumanInvalid()).append("\n");
        report.append(REP_DELETED).append(rec.getHumanDeleted()).append("\n");
        report.append(REP_MISSING).append(rec.getMissing()).append("\n");
        report.append("\t\trest: ").append(OmFileHelper.getHumanSize((long)restSize)).append("\n");
        if (cleanup) {
            rec.cleanup();
        }
    }

    private void checkAdminDetails() throws Exception {
        Validatable passVal;
        this.cfg.setUsername(this.cmdl.getOptionValue("user"));
        this.cfg.setEmail(this.cmdl.getOptionValue(OPTION_EMAIL));
        this.cfg.setGroup(this.cmdl.getOptionValue(OPTION_GROUP));
        if (this.cfg.getUsername() == null || this.cfg.getUsername().length() < 4) {
            Admin.doLog("User login was not provided, or too short, should be at least 4 character long.");
            throw new ExitException();
        }
        if (!MailUtil.isValid((String)this.cfg.getEmail())) {
            Admin.doLog(String.format("Please provide non-empty valid email: '%s' is not valid.", this.cfg.getEmail()));
            throw new ExitException();
        }
        if (Strings.isEmpty((CharSequence)this.cfg.getGroup())) {
            Admin.doLog(String.format("User group was not provided, or too short, should be at least 1 character long: %s", this.cfg.getGroup()));
            throw new ExitException();
        }
        if (this.cmdl.hasOption(OPTION_PWD)) {
            this.cfg.setPassword(this.cmdl.getOptionValue(OPTION_PWD));
        }
        StrongPasswordValidator passValidator = new StrongPasswordValidator(false, new User());
        do {
            passVal = new Validatable((Object)this.cfg.getPassword());
            passValidator.validate((IValidatable)passVal);
            if (passVal.isValid()) continue;
            Admin.doLog(String.format("Please enter password for the user '%s':", this.cfg.getUsername()));
            this.cfg.setPassword(new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8)).readLine());
        } while (!passVal.isValid());
        Map tzMap = ImportHelper.getAllTimeZones((String[])TimeZone.getAvailableIDs());
        this.cfg.setTimeZone(null);
        if (this.cmdl.hasOption("tz")) {
            String tz = this.cmdl.getOptionValue("tz");
            this.cfg.setTimeZone(tzMap.containsKey(tz) ? tz : null);
        }
        if (this.cfg.getTimeZone() == null) {
            Admin.doLog("Please enter timezone, Possible timezones are:");
            for (Map.Entry me : tzMap.entrySet()) {
                Admin.doLog(String.format("%1$-25s%2$s", "\"" + (String)me.getKey() + "\"", me.getValue()));
            }
            throw new ExitException();
        }
    }

    public void dropDB() throws Exception {
        File conf = OmFileHelper.getPersistence();
        ConnectionProperties connectionProperties = ConnectionPropertiesPatcher.getConnectionProperties(conf);
        this.immediateDropDB(connectionProperties);
    }

    private void dropDB(ConnectionProperties props) throws Exception {
        if (this.cmdl.hasOption("drop")) {
            this.immediateDropDB(props);
        }
    }

    private static LogFactoryImpl.LogImpl getLogImpl(JDBCConfiguration conf) {
        return (LogFactoryImpl.LogImpl)conf.getLog("openjpa.jdbc.Schema");
    }

    private static void runSchemaTool(JDBCConfigurationImpl conf, String action) throws Exception {
        SchemaTool st = new SchemaTool((JDBCConfiguration)conf, action);
        st.setIgnoreErrors(true);
        st.setOpenJPATables(true);
        st.setIndexes(false);
        st.setPrimaryKeys(false);
        if (!"dropDB".equals(action)) {
            st.setSchemaGroup(st.getDBSchemaGroup());
        }
        st.run();
    }

    private void immediateDropDB(ConnectionProperties props) throws Exception {
        if (this.context != null) {
            ApplicationHelper.destroyApplication();
            this.context = null;
        }
        try (JDBCConfigurationImpl conf = new JDBCConfigurationImpl();){
            conf.setPropertiesFile(OmFileHelper.getPersistence());
            conf.setConnectionDriverName(props.getDriver());
            conf.setConnectionURL(props.getURL());
            conf.setConnectionUserName(props.getLogin());
            conf.setConnectionPassword(props.getPassword());
            Admin.getLogImpl((JDBCConfiguration)conf).setLevel((short)3);
            Admin.runSchemaTool(conf, "dropDB");
            Admin.runSchemaTool(conf, "createDB");
        }
    }

    private File checkRestoreFile(String file) {
        File backup = new File(file);
        if (!(this.cmdl.hasOption("file") && backup.exists() && backup.isFile())) {
            Admin.doLog("File should be specified, and point the existent zip file");
            this.usage();
            throw new ExitException();
        }
        return backup;
    }

    private void processRestore(File backup) throws Exception {
        try (FileInputStream is = new FileInputStream(backup);){
            BackupImport importCtrl = (BackupImport)this.getApplicationContext().getBean(BackupImport.class);
            importCtrl.performImport(is, new ProgressHolder());
        }
    }

    public static void main(String[] args) {
        Admin a = new Admin();
        try {
            a.process(args);
            Admin.doLog("... Done");
            System.exit(0);
        }
        catch (ExitException e) {
            a.handleError(e, false, false);
            System.exit(1);
        }
        catch (Exception e) {
            log.error("Unexpected error", (Throwable)e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static enum Command {
        INSTALL,
        BACKUP,
        RESTORE,
        FILES,
        LDAP,
        USAGE;

    }
}

