/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.backup;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.openmeetings.db.bind.adapter.IntAdapter;
import org.apache.openmeetings.util.Version;

@XmlRootElement(name="version")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BackupVersion
implements Serializable,
Comparable<BackupVersion> {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="major")
    @XmlJavaTypeAdapter(value=IntAdapter.class, type=int.class)
    private int major;
    @XmlElement(name="minor")
    @XmlJavaTypeAdapter(value=IntAdapter.class, type=int.class)
    private int minor;
    @XmlElement(name="micro")
    @XmlJavaTypeAdapter(value=IntAdapter.class, type=int.class)
    private int micro;

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public void setMicro(int micro) {
        this.micro = micro;
    }

    public static BackupVersion get() {
        String ver = Version.getVersion();
        return BackupVersion.get(ver);
    }

    public static BackupVersion get(String ver) {
        BackupVersion bv = new BackupVersion();
        String[] dashParts = ver.split("-");
        if (dashParts.length == 0) {
            return bv;
        }
        String[] dotParts = dashParts[0].split("\\.");
        if (dotParts.length > 0) {
            bv.major = NumberUtils.toInt((String)dotParts[0]);
        }
        if (dotParts.length > 1) {
            bv.minor = NumberUtils.toInt((String)dotParts[1]);
        }
        if (dotParts.length > 2) {
            bv.micro = NumberUtils.toInt((String)dotParts[2]);
        }
        return bv;
    }

    @Override
    public int compareTo(BackupVersion o) {
        if (o == null) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        if (this.major > o.major) {
            return 1;
        }
        if (this.minor > o.minor) {
            return 1;
        }
        if (this.micro > o.micro) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.micro;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackupVersion other = (BackupVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.micro != other.micro) {
            return false;
        }
        return this.minor == other.minor;
    }

    public String toString() {
        return String.format("%s.%s.%s", this.major, this.minor, this.micro);
    }
}

