/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util.mail;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.NoSuchElementException;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.validate.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcalHandler {
    private static final Logger log = LoggerFactory.getLogger(IcalHandler.class);
    private final Calendar icsCalendar;
    private TimeZone timeZone;
    private VEvent meeting;
    private Method method;
    public static final Method ICAL_METHOD_REQUEST;
    public static final Method ICAL_METHOD_CANCEL;
    public static final Method ICAL_METHOD_REFRESH;

    public IcalHandler(Method method) {
        this.method = method;
        log.debug("Icalhandler method type : {}", (Object)method);
        this.icsCalendar = new Calendar();
        this.icsCalendar.getProperties().add((Property)new ProdId("-//Apache Openmeetings//OM Calendar//EN"));
        this.icsCalendar.getProperties().add((Property)Version.VERSION_2_0);
        this.icsCalendar.getProperties().add((Property)CalScale.GREGORIAN);
        this.icsCalendar.getProperties().add((Property)method);
    }

    public IcalHandler createVEvent(String tz, java.util.Date startDate, java.util.Date endDate, String name) {
        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        this.timeZone = registry.getTimeZone(tz);
        if (this.timeZone == null) {
            throw new NoSuchElementException("Unable to get time zone by id provided: " + tz);
        }
        DateTime start = new DateTime(startDate);
        start.setTimeZone(this.timeZone);
        DateTime end = new DateTime(endDate);
        end.setTimeZone(this.timeZone);
        this.meeting = new VEvent((Date)start, (Date)end, name);
        this.meeting.getProperties().add((Property)Transp.OPAQUE);
        this.meeting.getProperties().add((Property)Status.VEVENT_CONFIRMED);
        return this;
    }

    public IcalHandler setCreated(java.util.Date date) {
        this.meeting.getProperties().add((Property)new Created(new DateTime(date)));
        return this;
    }

    public IcalHandler setModified(java.util.Date date) {
        this.meeting.getProperties().add((Property)new LastModified(new DateTime(date == null ? new java.util.Date() : date)));
        return this;
    }

    public IcalHandler setDescription(String description) {
        this.meeting.getProperties().add((Property)new Description(description));
        return this;
    }

    public IcalHandler setLocation(String location) {
        this.meeting.getProperties().add((Property)new Location(location));
        return this;
    }

    public IcalHandler setSequence(int seq) {
        this.meeting.getProperties().add((Property)new Sequence(seq));
        return this;
    }

    public IcalHandler setUid(String uid) {
        this.meeting.getProperties().add((Property)new Uid(uid));
        return this;
    }

    private static URI getMailto(String email) {
        return URI.create("mailto:" + email);
    }

    public IcalHandler addOrganizer(String email, String name) {
        Organizer orger = new Organizer(IcalHandler.getMailto(email));
        orger.getParameters().add((Parameter)new Cn(name));
        this.meeting.getProperties().add((Property)orger);
        return this;
    }

    public IcalHandler addAttendee(String email, String display, boolean chair) {
        Attendee uno = new Attendee(URI.create("mailto:" + email));
        uno.getParameters().add((Parameter)CuType.INDIVIDUAL);
        uno.getParameters().add((Parameter)(chair ? Role.CHAIR : Role.REQ_PARTICIPANT));
        if (Method.CANCEL == this.method) {
            uno.getParameters().add((Parameter)PartStat.DECLINED);
        } else {
            uno.getParameters().add((Parameter)(chair ? PartStat.ACCEPTED : PartStat.NEEDS_ACTION));
            uno.getParameters().add((Parameter)Rsvp.TRUE);
        }
        uno.getParameters().add((Parameter)new XParameter("X-NUM-GUESTS", "0"));
        uno.getParameters().add((Parameter)new Cn(display));
        this.meeting.getProperties().add((Property)uno);
        return this;
    }

    public IcalHandler build() {
        this.icsCalendar.getComponents().add((Object)this.timeZone.getVTimeZone());
        this.icsCalendar.getComponents().add((Object)this.meeting);
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public void toFile(String inFilerPath) throws Exception {
        String filerPath = inFilerPath.endsWith(".ics") ? inFilerPath : String.format("%s.ics", inFilerPath);
        try (FileOutputStream fout = new FileOutputStream(filerPath);){
            CalendarOutputter outputter = new CalendarOutputter();
            outputter.output(this.icsCalendar, (OutputStream)fout);
        }
    }

    public byte[] toByteArray() throws ValidationException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CalendarOutputter outputter = new CalendarOutputter();
        outputter.output(this.icsCalendar, (OutputStream)bout);
        return bout.toByteArray();
    }

    public String toString() {
        return this.icsCalendar == null ? null : this.icsCalendar.toString();
    }

    static {
        System.setProperty("net.fortuna.ical4j.timezone.update.enabled", "false");
        System.setProperty("net.fortuna.ical4j.timezone.cache.impl", "net.fortuna.ical4j.util.MapTimeZoneCache");
        ICAL_METHOD_REQUEST = Method.REQUEST;
        ICAL_METHOD_CANCEL = Method.CANCEL;
        ICAL_METHOD_REFRESH = Method.REFRESH;
    }
}

