/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util;

import java.io.Serializable;
import java.util.Locale;
import org.apache.wicket.util.string.Strings;

public class ConnectionProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String driver = "org.h2.Driver";
    private String url = "jdbc:h2:./omdb";
    private String login = "user";
    private String password = "secret";
    private DbType dbType = DbType.H2;

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driverName) {
        this.driver = driverName;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String connectionURL) {
        this.url = connectionURL;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String connectionLogin) {
        this.login = connectionLogin;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String connectionPass) {
        this.password = connectionPass;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public String toString() {
        return "ConnectionProperties [type=" + this.dbType + ", driver=" + this.driver + ", url=" + this.url + ", login=" + this.login + "]";
    }

    public static enum DbType {
        DB2,
        H2,
        MSSQL,
        MYSQL,
        ORACLE,
        POSTGRESQL;


        public static DbType of(String val) {
            if (Strings.isEmpty((CharSequence)val)) {
                return H2;
            }
            return "sqlserver".equals(val) ? MSSQL : DbType.valueOf(val.toUpperCase(Locale.ROOT));
        }

        public String dbName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

