/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class CalendarHelper {
    private CalendarHelper() {
    }

    public static ZoneId getZoneId(String tzId) {
        return ZoneId.of(tzId, ZoneId.SHORT_IDS);
    }

    public static Date getDate(LocalDate d, String tzId) {
        return CalendarHelper.getDate(d.atStartOfDay(), tzId);
    }

    public static Date getDate(LocalDateTime d, String tzId) {
        return new Date(d.atZone(CalendarHelper.getZoneId(tzId)).toInstant().toEpochMilli());
    }

    public static ZonedDateTime getZoneDateTime(Date d, String tzId) {
        long milli = (d == null ? new Date() : d).getTime();
        return Instant.ofEpochMilli(milli).atZone(CalendarHelper.getZoneId(tzId));
    }

    public static LocalDate getDate(Date d, String tzId) {
        return CalendarHelper.getZoneDateTime(d == null ? new Date() : d, tzId).toLocalDate();
    }

    public static LocalDateTime getDateTime(Date d, String tzId) {
        return CalendarHelper.getZoneDateTime(d == null ? new Date() : d, tzId).toLocalDateTime();
    }

    public static String formatMillis(long millis) {
        long m = millis;
        long hours = TimeUnit.MILLISECONDS.toHours(m);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(m -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(m -= TimeUnit.MINUTES.toMillis(minutes));
        return String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, m -= TimeUnit.SECONDS.toMillis(seconds));
    }
}

