/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.util;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.CssClassNames;
import de.agilecoders.wicket.jquery.util.Generics2;
import java.util.Set;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public final class Attributes {
    public static void addClass(ComponentTag tag, String ... classNames) {
        Args.notNull((Object)classNames, (String)"classNames");
        Args.notNull((Object)tag, (String)"tag");
        Attributes.addClass(tag, Generics2.newHashSet((Object[])classNames));
    }

    public static void addClass(ComponentTag tag, Set<String> classNames) {
        Args.notNull(classNames, (String)"classNames");
        Args.notNull((Object)tag, (String)"tag");
        String classValue = CssClassNames.parse(tag.getAttribute("class")).add(classNames).asString();
        Attributes.set(tag, "class", classValue);
    }

    public static void addClass(ComponentTag tag, ICssClassNameProvider provider) {
        if (provider != null) {
            Attributes.addClass(tag, provider.cssClassName());
        }
    }

    public static void removeClass(ComponentTag tag, Set<String> classNames) {
        Args.notNull(classNames, (String)"classNames");
        Args.notNull((Object)tag, (String)"tag");
        String classValue = CssClassNames.parse(tag.getAttribute("class")).remove(classNames).asString();
        Attributes.set(tag, "class", classValue);
    }

    public static void removeClass(ComponentTag tag, String ... classNames) {
        Args.notNull((Object)classNames, (String)"classNames");
        Attributes.removeClass(tag, Set.of(classNames));
    }

    public static void removeClass(ComponentTag tag, ICssClassNameProvider provider) {
        if (provider != null) {
            Attributes.removeClass(tag, provider.cssClassName());
        }
    }

    public static void set(ComponentTag tag, String attributeName, String value) {
        Args.notNull((Object)attributeName, (String)"key");
        Args.notNull((Object)tag, (String)"tag");
        if (!Strings.isEmpty((CharSequence)value)) {
            tag.put(attributeName, (CharSequence)value);
        } else {
            tag.remove(attributeName);
        }
    }

    private Attributes() {
        throw new UnsupportedOperationException();
    }
}

