/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.dashboard.web;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.dashboard.Dashboard;
import org.wicketstuff.dashboard.DashboardContextInitializer;
import org.wicketstuff.dashboard.DashboardUtils;
import org.wicketstuff.dashboard.Widget;
import org.wicketstuff.dashboard.web.DashboardColumnPanel;
import org.wicketstuff.dashboard.web.DashboardEvent;
import org.wicketstuff.dashboard.web.DashboardResourcesBehavior;
import org.wicketstuff.dashboard.web.DashboardSettings;

public class DashboardPanel
extends GenericPanel<Dashboard> {
    private static final long serialVersionUID = 1L;
    private List<DashboardColumnPanel> columnPanels;
    private IModel<Boolean> rtlModel;

    public DashboardPanel(String id, IModel<Dashboard> model) {
        super(id, model);
        this.addColumnsPanel();
        this.add(new Behavior[]{new DashboardResourcesBehavior()});
    }

    public Dashboard getDashboard() {
        return (Dashboard)this.getModelObject();
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof DashboardEvent) {
            DashboardEvent dashboardEvent = (DashboardEvent)event.getPayload();
            DashboardEvent.EventType eventType = dashboardEvent.getType();
            if (DashboardEvent.EventType.WIDGET_ADDED == eventType) {
                this.onWidgetAdded(dashboardEvent);
            } else if (DashboardEvent.EventType.WIDGET_REMOVED == eventType) {
                this.onWidgetRemoved(dashboardEvent);
            } else if (DashboardEvent.EventType.WIDGETS_SORTED == eventType) {
                this.onWidgetsSorted(dashboardEvent);
            }
        }
    }

    public DashboardPanel setRtlModel(IModel<Boolean> rtlModel) {
        this.rtlModel = rtlModel;
        return this;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.rtlModel != null && this.rtlModel.getObject() == Boolean.TRUE) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)DashboardSettings.get().getRtlCssReference()));
        }
    }

    private void onWidgetAdded(DashboardEvent dashboardEvent) {
        Widget addedWidget = (Widget)dashboardEvent.getDetail();
        Dashboard dashboard = this.getDashboard();
        DashboardUtils.updateWidgetLocations(dashboard, dashboardEvent);
        dashboard.addWidget(addedWidget);
        DashboardContextInitializer.getDashboardContext().getDashboardPersister().save(dashboard);
    }

    private void onWidgetRemoved(DashboardEvent dashboardEvent) {
        Widget removedWidget = (Widget)dashboardEvent.getDetail();
        Dashboard dashboard = this.getDashboard();
        DashboardUtils.updateWidgetLocations(dashboard, dashboardEvent);
        dashboard.deleteWidget(removedWidget.getId());
        DashboardContextInitializer.getDashboardContext().getDashboardPersister().save(dashboard);
    }

    protected void onWidgetsSorted(DashboardEvent dashboardEvent) {
        Dashboard dashboard = this.getDashboard();
        DashboardUtils.updateWidgetLocations(dashboard, dashboardEvent);
        DashboardContextInitializer.getDashboardContext().getDashboardPersister().save(dashboard);
    }

    private void addColumnsPanel() {
        final int columnCount = this.getDashboard().getColumnCount();
        Loop columnsView = new Loop("columns", columnCount){
            private static final long serialVersionUID = 1L;

            protected void onBeforeRender() {
                if (!this.hasBeenRendered()) {
                    DashboardPanel.this.columnPanels = new ArrayList<DashboardColumnPanel>();
                }
                super.onBeforeRender();
            }

            public void renderHead(IHeaderResponse response) {
                float columnPanelWidth = 100.0f / (float)columnCount;
                response.render((HeaderItem)CssHeaderItem.forCSS((CharSequence)(".dashboard .column {width: " + columnPanelWidth + "%;}"), (String)("dashboard-column-width-" + columnPanelWidth)));
                super.renderHead(response);
            }

            protected void populateItem(LoopItem item) {
                DashboardColumnPanel columnPanel = new DashboardColumnPanel("column", (IModel<Dashboard>)DashboardPanel.this.getModel(), item.getIndex());
                columnPanel.setRenderBodyOnly(true);
                item.add(new Component[]{columnPanel});
                DashboardPanel.this.columnPanels.add(columnPanel);
            }
        };
        this.add(new Component[]{columnsView});
    }
}

