/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.label;

import java.io.Serializable;
import java.util.Locale;
import org.apache.openmeetings.db.util.FormatHelper;

public class OmLanguage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long id;
    private final Locale locale;
    private final boolean rtl;
    private String tip;
    private char rangeStart = (char)65;
    private char rangeEnd = (char)90;

    public OmLanguage(Long id, Locale locale) {
        this.id = id;
        this.locale = locale;
        this.rtl = FormatHelper.isRtlLanguage(locale.toLanguageTag());
    }

    public long getId() {
        return this.id;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isRtl() {
        return this.rtl;
    }

    public String getTip() {
        return this.tip;
    }

    public OmLanguage setTip(String tip) {
        this.tip = tip;
        return this;
    }

    public char getRangeStart() {
        return this.rangeStart;
    }

    public OmLanguage setRangeStart(char rangeStart) {
        this.rangeStart = rangeStart;
        return this;
    }

    public char getRangeEnd() {
        return this.rangeEnd;
    }

    public OmLanguage setRangeEnd(char rangeEnd) {
        this.rangeEnd = rangeEnd;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OmLanguage [id=");
        builder.append(this.id);
        builder.append(", locale=");
        builder.append(this.locale);
        builder.append(", rtl=");
        builder.append(this.rtl);
        builder.append(", rangeStart=");
        builder.append(this.rangeStart);
        builder.append(", rangeEnd=");
        builder.append(this.rangeEnd);
        builder.append("]");
        return builder.toString();
    }
}

