/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.openmeetings.webservice.util.RateLimited;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="netTestWebService")
@Tag(name="NetTestService")
@Path(value="/networktest")
public class NetTestWebService {
    private static final Logger log = LoggerFactory.getLogger(NetTestWebService.class);
    private static final int PING_PACKET_SIZE = 64;
    private static final int JITTER_PACKET_SIZE = 1024;
    private static final int MAX_DOWNLOAD_SIZE = 0x500000;
    private static final int MAX_UPLOAD_SIZE = 0x280000;
    public static final AtomicInteger CLIENT_COUNT = new AtomicInteger();
    private static int maxClients = 100;

    @PostConstruct
    private void report() {
        log.debug("MaxClients: {}", (Object)maxClients);
    }

    @RateLimited
    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="/")
    @Operation(description="Generate a sample for network test", responses={@ApiResponse(responseCode="200", description="Content as requested", content={@Content(mediaType="application/octet-stream")}), @ApiResponse(responseCode="400", description="Unkown type or exceeding Max Upload size"), @ApiResponse(responseCode="500", description="Server error")})
    public Response get(@Parameter(required=true, description="one of ping, jitter, download, upload") @QueryParam(value="type") String type, @Parameter(required=true, description="requests size of sample") @QueryParam(value="size") int inSize) {
        int size;
        final TestType testType = NetTestWebService.getTypeByString(type);
        log.debug("Network test:: get, {}, {}", (Object)testType, (Object)inSize);
        if (TestType.UNKNOWN == testType) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        switch (testType) {
            case PING: {
                size = 64;
                break;
            }
            case JITTER: {
                size = 1024;
                break;
            }
            default: {
                int count = CLIENT_COUNT.incrementAndGet();
                log.info("... download: client count: {}", (Object)count);
                size = inSize;
            }
        }
        if (size > 0x500000) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok().type("application/octet-stream").entity((Object)new InputStream(){
            int pos = 0;

            @Override
            public int read() throws IOException {
                ++this.pos;
                return this.pos > size ? -1 : ThreadLocalRandom.current().nextInt(0, 255);
            }

            @Override
            public int available() throws IOException {
                return size - this.pos;
            }

            @Override
            public void close() throws IOException {
                if (TestType.DOWNLOAD_SPEED == testType) {
                    int count = CLIENT_COUNT.decrementAndGet();
                    log.info("... close: client count: {}", (Object)count);
                }
                super.close();
            }
        }).header("Cache-Control", (Object)"no-cache, no-store, no-transform").header("Pragma", (Object)"no-cache").header("Content-Length", (Object)String.valueOf(size)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RateLimited
    @POST
    @Consumes(value={"application/octet-stream"})
    @Path(value="/")
    @Operation(description="Upload media to test upload speed", responses={@ApiResponse(responseCode="200", description="Number of bytes uploaded"), @ApiResponse(responseCode="500", description="Server error")})
    public int upload(@Parameter(required=true, description="size") @QueryParam(value="size") int size, @Parameter(required=true, description="stream to upload") InputStream stream) throws IOException {
        if (size > 0x280000) {
            return -1;
        }
        CLIENT_COUNT.incrementAndGet();
        byte[] b = new byte[1024];
        int totalCount = 0;
        try {
            int count;
            while ((count = stream.read(b)) > -1) {
                totalCount += count;
            }
            log.debug("Total bytes read {}", (Object)totalCount);
        }
        finally {
            CLIENT_COUNT.decrementAndGet();
        }
        return totalCount;
    }

    public static TestType getTypeByString(String typeString) {
        if ("ping".equals(typeString)) {
            return TestType.PING;
        }
        if ("jitter".equals(typeString)) {
            return TestType.JITTER;
        }
        if ("download".equals(typeString)) {
            return TestType.DOWNLOAD_SPEED;
        }
        if ("upload".equals(typeString)) {
            return TestType.UPLOAD_SPEED;
        }
        return TestType.UNKNOWN;
    }

    @Value(value="${nettest.max.clients}")
    private void setMaxClients(int count) {
        maxClients = count;
    }

    public static int getMaxClients() {
        return maxClients;
    }

    public static enum TestType {
        UNKNOWN,
        PING,
        JITTER,
        DOWNLOAD_SPEED,
        UPLOAD_SPEED;

    }
}

