/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.state;

import com.hazelcast.sql.impl.NodeServiceProvider;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.operation.QueryCheckOperation;
import com.hazelcast.sql.impl.operation.QueryOperationHandler;
import com.hazelcast.sql.impl.plan.cache.PlanCacheChecker;
import com.hazelcast.sql.impl.state.QueryClientStateRegistry;
import com.hazelcast.sql.impl.state.QueryState;
import com.hazelcast.sql.impl.state.QueryStateRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class QueryStateRegistryUpdater {
    private static final long DEFAULT_ORPHANED_QUERY_STATE_CHECK_FREQUENCY = 30000L;
    private final NodeServiceProvider nodeServiceProvider;
    private final QueryStateRegistry stateRegistry;
    private final QueryClientStateRegistry clientStateRegistry;
    private final QueryOperationHandler operationHandler;
    private final PlanCacheChecker planCacheChecker;
    private volatile long stateCheckFrequency;
    private volatile long orphanedQueryStateCheckFrequency = 30000L;
    private final Worker worker;

    public QueryStateRegistryUpdater(String instanceName, NodeServiceProvider nodeServiceProvider, QueryStateRegistry stateRegistry, QueryClientStateRegistry clientStateRegistry, QueryOperationHandler operationHandler, PlanCacheChecker planCacheChecker, long stateCheckFrequency) {
        if (stateCheckFrequency <= 0L) {
            throw new IllegalArgumentException("State check frequency must be positive: " + stateCheckFrequency);
        }
        this.nodeServiceProvider = nodeServiceProvider;
        this.stateRegistry = stateRegistry;
        this.clientStateRegistry = clientStateRegistry;
        this.operationHandler = operationHandler;
        this.planCacheChecker = planCacheChecker;
        this.stateCheckFrequency = stateCheckFrequency;
        this.worker = new Worker(instanceName);
    }

    public void start() {
        this.worker.start();
    }

    public void shutdown() {
        this.worker.stop();
    }

    public void setStateCheckFrequency(long stateCheckFrequency) {
        this.stateCheckFrequency = stateCheckFrequency;
        this.worker.thread.interrupt();
    }

    public void setOrphanedQueryStateCheckFrequency(long orphanedQueryStateCheckFrequency) {
        this.orphanedQueryStateCheckFrequency = orphanedQueryStateCheckFrequency;
    }

    private final class Worker
    implements Runnable {
        private final Object startMux = new Object();
        private final String instanceName;
        private Thread thread;
        private volatile boolean stopped;

        private Worker(String instanceName) {
            this.instanceName = instanceName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.startMux;
            synchronized (object) {
                if (this.stopped || this.thread != null) {
                    return;
                }
                Thread thread = new Thread(this);
                thread.setName(QueryUtils.workerName(this.instanceName, "query-state-checker"));
                thread.setDaemon(true);
                thread.start();
                this.thread = thread;
            }
        }

        @Override
        public void run() {
            while (!this.stopped) {
                long currentStateCheckFrequency = QueryStateRegistryUpdater.this.stateCheckFrequency;
                try {
                    Thread.sleep(currentStateCheckFrequency);
                    this.checkMemberState();
                    this.checkClientState();
                    this.checkPlans();
                }
                catch (InterruptedException e) {
                    if (currentStateCheckFrequency != QueryStateRegistryUpdater.this.stateCheckFrequency) continue;
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }

        private void checkMemberState() {
            Collection<UUID> activeMemberIds = QueryStateRegistryUpdater.this.nodeServiceProvider.getDataMemberIds();
            HashMap<UUID, Collection> checkMap = new HashMap<UUID, Collection>();
            for (QueryState state : QueryStateRegistryUpdater.this.stateRegistry.getStates()) {
                if (state.tryCancelOnTimeout() || state.tryCancelOnMemberLeave(activeMemberIds) || !state.requestQueryCheck(QueryStateRegistryUpdater.this.stateCheckFrequency, QueryStateRegistryUpdater.this.orphanedQueryStateCheckFrequency)) continue;
                QueryId queryId = state.getQueryId();
                checkMap.computeIfAbsent(queryId.getMemberId(), key -> new ArrayList(1)).add(queryId);
            }
            UUID localMemberId = QueryStateRegistryUpdater.this.nodeServiceProvider.getLocalMemberId();
            for (Map.Entry checkEntry : checkMap.entrySet()) {
                QueryCheckOperation operation = new QueryCheckOperation((Collection)checkEntry.getValue());
                QueryStateRegistryUpdater.this.operationHandler.submit(localMemberId, (UUID)checkEntry.getKey(), operation);
            }
        }

        private void checkClientState() {
            Set<UUID> activeClientIds = QueryStateRegistryUpdater.this.nodeServiceProvider.getClientIds();
            QueryStateRegistryUpdater.this.clientStateRegistry.update(activeClientIds);
        }

        private void checkPlans() {
            if (QueryStateRegistryUpdater.this.planCacheChecker != null) {
                QueryStateRegistryUpdater.this.planCacheChecker.check();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.startMux;
            synchronized (object) {
                if (this.stopped) {
                    return;
                }
                this.stopped = true;
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
        }
    }
}

