/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dif;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.dif.DIFContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.TaggedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DIFParser
extends AbstractParser {
    private static final long serialVersionUID = 971505521275777826L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Collections.singletonList(MediaType.application((String)"dif+xml"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.startElement("p");
        TaggedContentHandler tagged = new TaggedContentHandler(handler);
        try {
            XMLReaderUtils.parseSAX((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler((ContentHandler)new EmbeddedContentHandler(this.getContentHandler((ContentHandler)tagged, metadata, context))), (ParseContext)context);
        }
        catch (SAXException e) {
            tagged.throwIfCauseOf((Exception)e);
            throw new TikaException("XML parse error", (Throwable)e);
        }
        finally {
            xhtml.endElement("p");
            xhtml.endDocument();
        }
    }

    protected ContentHandler getContentHandler(ContentHandler handler, Metadata metadata, ParseContext context) {
        return new DIFContentHandler(handler, metadata);
    }
}

