/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.microsoft.ooxml;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.util.ZipEntrySource;
import org.apache.poi.openxml4j.util.ZipFileZipEntrySource;
import org.apache.poi.xdgf.usermodel.XDGFRelation;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.tika.detect.zip.StreamingDetectContext;
import org.apache.tika.detect.zip.ZipContainerDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.StoppingEarlyException;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OPCPackageDetector
implements ZipContainerDetector {
    static final MediaType TIKA_OOXML = MediaType.application((String)"x-tika-ooxml");
    static final MediaType DOCX = MediaType.application((String)"vnd.openxmlformats-officedocument.wordprocessingml.document");
    static final MediaType DOCM = MediaType.application((String)"vnd.ms-word.document.macroEnabled.12");
    static final MediaType DOTM = MediaType.application((String)"vnd.ms-word.template.macroenabled.12");
    static final MediaType DOTX = MediaType.application((String)"vnd.openxmlformats-officedocument.wordprocessingml.template");
    static final MediaType PPTX = MediaType.application((String)"vnd.openxmlformats-officedocument.presentationml.presentation");
    static final MediaType PPSM = MediaType.application((String)"vnd.ms-powerpoint.slideshow.macroEnabled.12");
    static final MediaType PPSX = MediaType.application((String)"vnd.openxmlformats-officedocument.presentationml.slideshow");
    static final MediaType PPTM = MediaType.application((String)"vnd.ms-powerpoint.presentation.macroEnabled.12");
    static final MediaType POTM = MediaType.application((String)"vnd.ms-powerpoint.template.macroenabled.12");
    static final MediaType POTX = MediaType.application((String)"vnd.openxmlformats-officedocument.presentationml.template");
    static final MediaType THMX = MediaType.application((String)"vnd.openxmlformats-officedocument");
    static final MediaType XLSB = MediaType.application((String)"vnd.ms-excel.sheet.binary.macroenabled.12");
    static final MediaType XLSX = MediaType.application((String)"vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    static final MediaType XLSM = MediaType.application((String)"vnd.ms-excel.sheet.macroEnabled.12");
    static final MediaType XLTM = MediaType.application((String)"vnd.ms-excel.template.macroenabled.12");
    static final MediaType XLTX = MediaType.application((String)"vnd.openxmlformats-officedocument.spreadsheetml.template");
    static final MediaType XLAM = MediaType.application((String)"vnd.ms-excel.addin.macroEnabled.12");
    static final MediaType XPS = MediaType.application((String)"vnd.ms-xpsdocument");
    static final Set<String> OOXML_HINTS = OPCPackageDetector.fillSet("word/document.xml", "_rels/.rels", "[Content_Types].xml", "ppt/presentation.xml", "ppt/slides/slide1.xml", "xl/workbook.xml", "xl/sharedStrings.xml", "xl/worksheets/sheet1.xml");
    private static final Pattern MACRO_TEMPLATE_PATTERN = Pattern.compile("macroenabledtemplate$", 2);
    private static final String XPS_DOCUMENT = "http://schemas.microsoft.com/xps/2005/06/fixedrepresentation";
    private static final String OPEN_XPS_DOCUMENT = "http://schemas.openxps.org/oxps/v1.0/fixedrepresentation";
    private static final String STAR_OFFICE_6_WRITER = "application/vnd.sun.xml.writer";
    static Map<String, MediaType> OOXML_CONTENT_TYPES = new ConcurrentHashMap<String, MediaType>();

    private static Set<String> fillSet(String ... args) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(args)));
    }

    public static MediaType detectOfficeOpenXML(OPCPackage pkg) {
        PackageRelationshipCollection core = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        if (core.size() == 0) {
            core = pkg.getRelationshipsByType("http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument");
        }
        if (core.size() == 0) {
            core = pkg.getRelationshipsByType("http://schemas.microsoft.com/visio/2010/relationships/document");
        }
        if (core.size() == 0) {
            core = pkg.getRelationshipsByType(XPS_DOCUMENT);
            if (core.size() == 1) {
                return MediaType.application((String)"vnd.ms-xpsdocument");
            }
            core = pkg.getRelationshipsByType(OPEN_XPS_DOCUMENT);
            if (core.size() == 1) {
                return MediaType.application((String)"vnd.ms-xpsdocument");
            }
        }
        if (core.size() == 0 && (core = pkg.getRelationshipsByType("http://schemas.autodesk.com/dwfx/2007/relationships/documentsequence")).size() == 1) {
            return MediaType.parse((String)"model/vnd.dwfx+xps");
        }
        if (core.size() != 1) {
            return null;
        }
        PackagePart corePart = pkg.getPart(core.getRelationship(0));
        String coreType = corePart.getContentType();
        if (coreType.contains(".xps")) {
            return MediaType.application((String)"vnd.ms-package.xps");
        }
        String docType = coreType.substring(0, coreType.lastIndexOf(46));
        if (docType.toLowerCase(Locale.ROOT).endsWith("macroenabled")) {
            docType = docType.toLowerCase(Locale.ROOT) + ".12";
        }
        if (docType.toLowerCase(Locale.ROOT).endsWith("macroenabledtemplate")) {
            docType = MACRO_TEMPLATE_PATTERN.matcher(docType).replaceAll("macroenabled.12");
        }
        return MediaType.parse((String)docType);
    }

    public static Set<String> parseOOXMLRels(InputStream is) {
        RelsHandler relsHandler = new RelsHandler();
        try {
            XMLReaderUtils.parseSAX((InputStream)is, (DefaultHandler)relsHandler, (ParseContext)new ParseContext());
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return relsHandler.rels;
    }

    private static MediaType parseOOXMLContentTypes(InputStream is) {
        ContentTypeHandler contentTypeHandler = new ContentTypeHandler();
        try {
            XMLReaderUtils.parseSAX((InputStream)is, (DefaultHandler)new OfflineContentHandler((ContentHandler)contentTypeHandler), (ParseContext)new ParseContext());
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return contentTypeHandler.mediaType;
    }

    @Override
    public MediaType detect(ZipFile zipFile, TikaInputStream stream) throws IOException {
        ZipFileZipEntrySource zipEntrySource = new ZipFileZipEntrySource(zipFile);
        OPCPackage pkg = null;
        MediaType type = null;
        try {
            pkg = OPCPackage.open((ZipEntrySource)zipEntrySource);
            type = OPCPackageDetector.detectOfficeOpenXML(pkg);
        }
        catch (SecurityException e) {
            IOUtils.closeQuietly((Closeable)zipEntrySource);
            IOUtils.closeQuietly((Closeable)zipFile);
            throw e;
        }
        catch (RuntimeException | InvalidFormatException e) {
            IOUtils.closeQuietly((Closeable)zipEntrySource);
            IOUtils.closeQuietly((Closeable)zipFile);
            return null;
        }
        stream.setOpenContainer((Object)pkg);
        return type;
    }

    @Override
    public MediaType streamingDetectUpdate(ZipArchiveEntry zae, InputStream zis, StreamingDetectContext detectContext) {
        String name = zae.getName();
        if (name.equals("[Content_Types].xml")) {
            MediaType mt = OPCPackageDetector.parseOOXMLContentTypes(zis);
            if (mt != null) {
                return mt;
            }
            return TIKA_OOXML;
        }
        if (OOXML_HINTS.contains(name)) {
            OOXMLHintCounter cnt = detectContext.get(OOXMLHintCounter.class);
            if (cnt == null) {
                cnt = new OOXMLHintCounter();
                detectContext.set(OOXMLHintCounter.class, cnt);
            }
            cnt.increment();
            if (cnt.getCount() > 2) {
                return TIKA_OOXML;
            }
        }
        return null;
    }

    @Override
    public MediaType streamingDetectFinal(StreamingDetectContext detectContext) {
        return null;
    }

    static {
        OOXML_CONTENT_TYPES.put(XWPFRelation.DOCUMENT.getContentType(), DOCX);
        OOXML_CONTENT_TYPES.put(XWPFRelation.MACRO_DOCUMENT.getContentType(), DOCM);
        OOXML_CONTENT_TYPES.put(XWPFRelation.MACRO_TEMPLATE_DOCUMENT.getContentType(), DOTM);
        OOXML_CONTENT_TYPES.put(XWPFRelation.TEMPLATE.getContentType(), DOTX);
        OOXML_CONTENT_TYPES.put(XSSFRelation.WORKBOOK.getContentType(), XLSX);
        OOXML_CONTENT_TYPES.put(XSSFRelation.MACROS_WORKBOOK.getContentType(), XLSM);
        OOXML_CONTENT_TYPES.put(XSSFRelation.XLSB_BINARY_WORKBOOK.getContentType(), XLSB);
        OOXML_CONTENT_TYPES.put(XSSFRelation.TEMPLATE_WORKBOOK.getContentType(), XLTX);
        OOXML_CONTENT_TYPES.put(XSSFRelation.MACRO_TEMPLATE_WORKBOOK.getContentType(), XLTM);
        OOXML_CONTENT_TYPES.put(XSSFRelation.MACRO_ADDIN_WORKBOOK.getContentType(), XLAM);
        OOXML_CONTENT_TYPES.put(XSLFRelation.MAIN.getContentType(), PPTX);
        OOXML_CONTENT_TYPES.put(XSLFRelation.MACRO.getContentType(), PPSM);
        OOXML_CONTENT_TYPES.put(XSLFRelation.MACRO_TEMPLATE.getContentType(), POTM);
        OOXML_CONTENT_TYPES.put(XSLFRelation.PRESENTATIONML_TEMPLATE.getContentType(), PPTM);
        OOXML_CONTENT_TYPES.put(XSLFRelation.PRESENTATIONML.getContentType(), PPSX);
        OOXML_CONTENT_TYPES.put(XSLFRelation.PRESENTATION_MACRO.getContentType(), PPTM);
        OOXML_CONTENT_TYPES.put(XSLFRelation.PRESENTATIONML_TEMPLATE.getContentType(), POTX);
        OOXML_CONTENT_TYPES.put(XSLFRelation.THEME_MANAGER.getContentType(), THMX);
        OOXML_CONTENT_TYPES.put("application/vnd.ms-visio.drawing.macroEnabled.main+xml", MediaType.application((String)"vnd.ms-visio.drawing.macroEnabled.12"));
        OOXML_CONTENT_TYPES.put(XDGFRelation.DOCUMENT.getContentType(), MediaType.application((String)"vnd.ms-visio.drawing"));
        OOXML_CONTENT_TYPES.put("application/vnd.ms-visio.stencil.macroEnabled.main+xml", MediaType.application((String)"vnd.ms-visio.stencil.macroenabled.12"));
        OOXML_CONTENT_TYPES.put("application/vnd.ms-visio.stencil.main+xml", MediaType.application((String)"vnd.ms-visio.stencil"));
        OOXML_CONTENT_TYPES.put("application/vnd.ms-visio.template.macroEnabled.main+xml", MediaType.application((String)"vnd.ms-visio.template.macroenabled.12"));
        OOXML_CONTENT_TYPES.put("application/vnd.ms-visio.template.main+xml", MediaType.application((String)"vnd.ms-visio.template"));
        OOXML_CONTENT_TYPES.put("application/vnd.ms-package.xps-fixeddocumentsequence+xml", XPS);
    }

    private static class OOXMLHintCounter {
        private int cnt = 0;

        private OOXMLHintCounter() {
        }

        private void increment() {
            ++this.cnt;
        }

        private int getCount() {
            return this.cnt;
        }
    }

    private static class ContentTypeHandler
    extends DefaultHandler {
        private MediaType mediaType = null;

        private ContentTypeHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String contentType;
                String attrName = attrs.getLocalName(i);
                if (!attrName.equals("ContentType") || !OOXML_CONTENT_TYPES.containsKey(contentType = attrs.getValue(i))) continue;
                this.mediaType = OOXML_CONTENT_TYPES.get(contentType);
                throw new StoppingEarlyException();
            }
        }
    }

    private static class RelsHandler
    extends DefaultHandler {
        Set<String> rels = new HashSet<String>();
        private MediaType mediaType = null;

        private RelsHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getLocalName(i);
                if (!attrName.equals("Type")) continue;
                String contentType = attrs.getValue(i);
                this.rels.add(contentType);
                if (!OOXML_CONTENT_TYPES.containsKey(contentType)) continue;
                this.mediaType = OOXML_CONTENT_TYPES.get(contentType);
            }
        }
    }
}

