/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;

public class MultipartFormComponentListener
implements AjaxRequestTarget.IListener {
    static final String ENCTYPE_URL_ENCODED = "application/x-www-form-urlencoded";

    @Override
    public void onBeforeRespond(Map<String, Component> map, AjaxRequestTarget target) {
        target.getPage().visitChildren(FormComponent.class, (formComponent, visit) -> {
            if (formComponent.isMultiPart()) {
                Form<?> form = formComponent.getForm();
                boolean multiPart = form.isMultiPart();
                String enctype = multiPart ? "multipart/form-data" : ENCTYPE_URL_ENCODED;
                target.appendJavaScript(String.format("Wicket.$('%s').form.enctype='%s'", formComponent.getMarkupId(), enctype));
                visit.stop();
            }
        });
    }
}

