/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.File;
import org.apache.wicket.Application;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.PageManager;
import org.apache.wicket.pageStore.AsynchronousPageStore;
import org.apache.wicket.pageStore.CachingPageStore;
import org.apache.wicket.pageStore.CryptingPageStore;
import org.apache.wicket.pageStore.DiskPageStore;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.pageStore.InSessionPageStore;
import org.apache.wicket.pageStore.RequestPageStore;
import org.apache.wicket.pageStore.SerializingPageStore;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.settings.StoreSettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;

public class DefaultPageManagerProvider
implements IPageManagerProvider {
    protected final Application application;

    public DefaultPageManagerProvider(Application application) {
        this.application = (Application)Args.notNull((Object)application, (String)"application");
    }

    @Override
    public IPageManager get() {
        IPageStore store = this.newPersistentStore();
        store = this.newCryptingStore(store);
        store = this.newAsynchronousStore(store);
        store = this.newSerializingStore(store);
        store = this.newCachingStore(store);
        store = this.newRequestStore(store);
        return new PageManager(store);
    }

    protected ISerializer getSerializer() {
        return this.application.getFrameworkSettings().getSerializer();
    }

    protected IPageStore newRequestStore(IPageStore pageStore) {
        return new RequestPageStore(pageStore);
    }

    protected IPageStore newCachingStore(IPageStore pageStore) {
        return new CachingPageStore(pageStore, new InSessionPageStore(1));
    }

    protected IPageStore newAsynchronousStore(IPageStore pageStore) {
        StoreSettings storeSettings = this.application.getStoreSettings();
        if (storeSettings.isAsynchronous()) {
            int capacity = storeSettings.getAsynchronousQueueCapacity();
            pageStore = new AsynchronousPageStore(pageStore, capacity);
        }
        return pageStore;
    }

    protected IPageStore newSerializingStore(IPageStore pageStore) {
        return new SerializingPageStore(pageStore, this.getSerializer());
    }

    protected IPageStore newCryptingStore(IPageStore pageStore) {
        StoreSettings storeSettings = this.application.getStoreSettings();
        if (storeSettings.isEncrypted()) {
            pageStore = new CryptingPageStore(pageStore, this.application);
        }
        return pageStore;
    }

    protected IPageStore newPersistentStore() {
        StoreSettings storeSettings = this.application.getStoreSettings();
        Bytes maxSizePerSession = storeSettings.getMaxSizePerSession();
        File fileStoreFolder = storeSettings.getFileStoreFolder();
        return new DiskPageStore(this.application.getName(), fileStoreFolder, maxSizePerSession);
    }
}

