/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.util;

import java.util.Locale;
import java.util.Map;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrongPasswordValidator
implements IValidator<String> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(StrongPasswordValidator.class);
    private final boolean web;
    private User u;

    public StrongPasswordValidator(User u) {
        this(true, u);
    }

    public StrongPasswordValidator(boolean web, User u) {
        this.web = web;
        this.u = u;
    }

    private static boolean noDigit(String password) {
        return password == null || OpenmeetingsVariables.isPwdCheckDigit() && !password.matches(".*\\d+.*");
    }

    private static boolean noSymbol(String password) {
        return password == null || OpenmeetingsVariables.isPwdCheckSpecial() && !password.matches(".*[!@#$%^&*\\]\\[]+.*");
    }

    private static boolean noUpperCase(String password) {
        return password == null || OpenmeetingsVariables.isPwdCheckUpper() && password.equals(password.toLowerCase(Locale.ROOT));
    }

    private static boolean noLowerCase(String password) {
        return password == null || password.equals(password.toUpperCase(Locale.ROOT));
    }

    private static boolean badLength(String password) {
        return password == null || password.length() < OpenmeetingsVariables.getMinPasswdLength();
    }

    private static boolean checkWord(String password, String word) {
        if (Strings.isEmpty((CharSequence)password) || Strings.isEmpty((CharSequence)word) || word.length() < 3) {
            return false;
        }
        for (int i = 0; i < word.length() - 3; ++i) {
            String substr = word.toLowerCase(Locale.ROOT).substring(i, i + 3);
            if (password.toLowerCase(Locale.ROOT).indexOf(substr) <= -1) continue;
            return true;
        }
        return false;
    }

    private boolean hasStopWords(String password) {
        String email;
        if (StrongPasswordValidator.checkWord(password, this.u.getLogin())) {
            return true;
        }
        if (this.u.getAddress() != null && !Strings.isEmpty((CharSequence)(email = this.u.getAddress().getEmail()))) {
            for (String part : email.split("[.@]")) {
                if (!StrongPasswordValidator.checkWord(password, part)) continue;
                return true;
            }
        }
        return false;
    }

    private void error(IValidatable<String> pass, String key) {
        this.error(pass, key, null);
    }

    private void error(IValidatable<String> pass, String key, Map<String, Object> params) {
        if (this.web) {
            ValidationError err = new ValidationError().addKey(key);
            if (params != null) {
                err.setVariables(params);
            }
            pass.error((IValidationError)err);
        } else {
            String msg = LabelDao.getString((String)key, (long)1L);
            if (params != null && !params.isEmpty() && !Strings.isEmpty((CharSequence)msg)) {
                for (Map.Entry<String, Object> e : params.entrySet()) {
                    msg = msg.replace(String.format("${%s}", e.getKey()), "" + e.getValue());
                }
            }
            log.warn(msg);
            pass.error((IValidationError)new ValidationError(msg));
        }
    }

    public void validate(IValidatable<String> pass) {
        if (StrongPasswordValidator.badLength((String)pass.getValue())) {
            this.error(pass, "bad.password.short", Map.of("0", OpenmeetingsVariables.getMinPasswdLength()));
        }
        if (StrongPasswordValidator.noLowerCase((String)pass.getValue())) {
            this.error(pass, "bad.password.lower");
        }
        if (StrongPasswordValidator.noUpperCase((String)pass.getValue())) {
            this.error(pass, "bad.password.upper");
        }
        if (StrongPasswordValidator.noDigit((String)pass.getValue())) {
            this.error(pass, "bad.password.digit");
        }
        if (StrongPasswordValidator.noSymbol((String)pass.getValue())) {
            this.error(pass, "bad.password.special");
        }
        if (this.hasStopWords((String)pass.getValue())) {
            this.error(pass, "bad.password.stop");
        }
    }

    public void setUser(User u) {
        this.u = u;
    }
}

