/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.converter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.openmeetings.core.converter.BaseConverter;
import org.apache.openmeetings.core.converter.ConversionException;
import org.apache.openmeetings.core.converter.IRecordingConverter;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.record.RecordingChunk;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.process.ProcessResultList;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RecordingConverter
extends BaseConverter
implements IRecordingConverter {
    private static final Logger log = LoggerFactory.getLogger(RecordingConverter.class);

    @Override
    public void startConversion(Recording r) {
        if (r == null) {
            log.warn("Conversion is NOT started. Recording passed is NULL");
            return;
        }
        ProcessResultList logs = new ProcessResultList();
        ArrayList<File> waveFiles = new ArrayList<File>();
        try {
            log.debug("recording {}", (Object)r.getId());
            File streamFolder = this.getStreamFolder(r);
            RecordingChunk screenChunk = this.chunkDao.getScreenByRecording(r.getId());
            if (screenChunk == null) {
                throw new ConversionException("screenMetaData is Null recordingId " + r.getId());
            }
            if (screenChunk.getStreamStatus() == RecordingChunk.Status.NONE) {
                RecordingConverter.printChunkInfo(screenChunk, "StartConversion");
                throw new ConversionException("Stream has not been started, error in recording");
            }
            if (Strings.isEmpty((CharSequence)r.getHash())) {
                r.setHash(UUID.randomUUID().toString());
            }
            r.setStatus(Recording.Status.CONVERTING);
            r = this.recordingDao.update(r);
            screenChunk = this.waitForTheStream(screenChunk.getId());
            File wav = new File(streamFolder, screenChunk.getStreamName() + "_FINAL_WAVE.wav");
            this.createWav(r, logs, streamFolder, waveFiles, wav, null);
            this.chunkDao.update(screenChunk);
            String inputScreenFullFlv = OmFileHelper.getRecordingChunk((Long)r.getRoomId(), (String)screenChunk.getStreamName()).getCanonicalPath();
            String mp4path = this.convertToMp4(r, List.of("-itsoffset", CalendarHelper.formatMillis((long)this.diff(screenChunk.getStart(), r.getRecordStart())), "-i", inputScreenFullFlv, "-i", wav.getCanonicalPath()), false, logs);
            BaseConverter.Dimension dim = RecordingConverter.getDimension(logs.getLast().getError(), null);
            if (dim != null) {
                r.setWidth(Integer.valueOf(dim.getWidth()));
                r.setHeight(Integer.valueOf(dim.getHeight()));
            }
            this.finalizeRec(r, mp4path, logs);
        }
        catch (Exception err) {
            log.error("[startConversion]", (Throwable)err);
            r.setStatus(Recording.Status.ERROR);
        }
        this.postProcess(r, logs);
        this.postProcess(waveFiles);
        this.recordingDao.update(r);
    }
}

