/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.converter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.openmeetings.core.converter.BaseConverter;
import org.apache.openmeetings.core.converter.ConversionException;
import org.apache.openmeetings.core.converter.IRecordingConverter;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.record.RecordingChunk;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.process.ProcessHelper;
import org.apache.openmeetings.util.process.ProcessResult;
import org.apache.openmeetings.util.process.ProcessResultList;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InterviewConverter
extends BaseConverter
implements IRecordingConverter {
    private static final Logger log = LoggerFactory.getLogger(InterviewConverter.class);
    private static final int WIDTH = 320;
    private static final int HEIGHT = 260;
    private String interviewCam;
    private String interviewBlank;

    private void init() throws ConversionException, IOException {
        File interviewCamFile = new File(OmFileHelper.getImagesDir(), "interview_webcam.png");
        if (!interviewCamFile.exists()) {
            throw new ConversionException("defaultInterviewImageFile does not exist!");
        }
        this.interviewCam = interviewCamFile.getCanonicalPath();
        File interviewBlankFile = new File(OmFileHelper.getImagesDir(), "blank.png");
        if (!interviewBlankFile.exists()) {
            throw new ConversionException("defaultInterviewImageFile does not exist!");
        }
        this.interviewBlank = interviewBlankFile.getCanonicalPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startConversion(Recording r) {
        if (r == null) {
            log.warn("Conversion is NOT started. Recording passed is NULL");
            return;
        }
        ProcessResultList logs = new ProcessResultList();
        ArrayList<File> waveFiles = new ArrayList<File>();
        try {
            log.debug("recording {}", (Object)r.getId());
            if (this.interviewCam == null) {
                this.init();
            }
            if (Strings.isEmpty((CharSequence)r.getHash())) {
                r.setHash(UUID.randomUUID().toString());
            }
            r.setStatus(Recording.Status.CONVERTING);
            r = this.recordingDao.update(r);
            File streamFolder = this.getStreamFolder(r);
            List chunks = this.chunkDao.getByRecording(r.getId());
            File wav = new File(streamFolder, String.format("INTERVIEW_%s_FINAL_WAVE.wav", r.getId()));
            this.createWav(r, logs, streamFolder, waveFiles, wav, chunks);
            Map cunksBySid = chunks.stream().collect(Collectors.groupingBy(RecordingChunk::getSid, LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), l -> l.stream().sorted(Comparator.comparing(RecordingChunk::getStart)).collect(Collectors.toList()))));
            ArrayList<String> pods = new ArrayList<String>();
            for (Map.Entry e : cunksBySid.entrySet()) {
                int podIdx = pods.size();
                Date pStart = r.getRecordStart();
                ArrayList<PodPart> parts = new ArrayList<PodPart>();
                pStart = this.processParts(r.getRoomId(), (List)e.getValue(), logs, podIdx, parts, pStart);
                if (parts.isEmpty()) continue;
                String podX = new File(streamFolder, String.format("rec_%s_pod_%s.%s", r.getId(), podIdx, "mp4")).getCanonicalPath();
                long diff = this.diff(r.getRecordEnd(), pStart);
                PodPart.add(parts, diff);
                this.createPod(podX, this.interviewCam, podIdx, parts, logs);
                pods.add(podX);
            }
            int numPods = pods.size();
            if (numPods == 0) {
                ProcessResult res = new ProcessResult();
                res.setProcess("CheckStreamFilesExists");
                res.setError("No valid pods found");
                res.setExitCode(Integer.valueOf(-1));
                logs.add(res);
                return;
            }
            double ratio = Math.sqrt((double)numPods / Math.sqrt(2.0));
            int w = ratio < 1.0 ? numPods : (int)Math.round(ratio);
            w = Math.max(w, (int)Math.round(1.0 * (double)numPods / (double)w));
            ArrayList<PodPart> missingParts = new ArrayList<PodPart>();
            PodPart.add(missingParts, this.diff(r.getRecordEnd(), r.getRecordStart()));
            String missingPod = new File(streamFolder, String.format("rec_%s_pod_%s.%s", r.getId(), numPods, "mp4")).getCanonicalPath();
            this.createPod(missingPod, this.interviewBlank, numPods, missingParts, logs);
            for (int i = numPods % w; i < w; ++i) {
                pods.add(missingPod);
            }
            r.setWidth(Integer.valueOf(w * 320));
            r.setHeight(Integer.valueOf(numPods / w * 260));
            String mp4path = this.convertToMp4(r, InterviewConverter.getFinalArgs(pods, wav, w), numPods != 1, logs);
            this.finalizeRec(r, mp4path, logs);
        }
        catch (Exception err) {
            log.error("[startConversion]", (Throwable)err);
            r.setStatus(Recording.Status.ERROR);
        }
        finally {
            if (Recording.Status.CONVERTING == r.getStatus()) {
                r.setStatus(Recording.Status.ERROR);
            }
            this.postProcess(r, logs);
            this.postProcess(waveFiles);
            this.recordingDao.update(r);
        }
    }

    private void createPod(String podX, String image, int podIdx, List<PodPart> parts, ProcessResultList logs) throws ConversionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getPathToFFMPEG());
        args.add("-y");
        StringBuilder videos = new StringBuilder();
        StringBuilder concat = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            PodPart p = parts.get(i);
            if (p.getFile() == null) {
                args.add("-loop");
                args.add("1");
                args.add("-t");
                args.add(CalendarHelper.formatMillis((long)p.getDuration()));
                args.add("-i");
                args.add(image);
            } else {
                args.add("-t");
                args.add(CalendarHelper.formatMillis((long)p.getDuration()));
                args.add("-i");
                args.add(p.getFile());
            }
            videos.append('[').append(i).append(']').append("scale=").append(320).append(':').append(260).append(",setsar=1:1").append("[v").append(i).append("]; ");
            concat.append("[v").append(i).append(']');
        }
        args.add("-filter_complex");
        args.add(concat.insert(0, videos).append("concat=n=").append(parts.size()).append(":v=1:a=0").toString());
        args.add("-an");
        args.add(podX);
        ProcessResult res = ProcessHelper.exec((String)("Full video pod_" + podIdx), args, (boolean)true);
        logs.add(res);
        if (res.isWarn()) {
            throw new ConversionException("Fail to create pod");
        }
    }

    private Date processParts(Long roomId, List<RecordingChunk> chunks, ProcessResultList logs, int numPods, List<PodPart> parts, Date pStart) throws IOException {
        for (RecordingChunk chunk : chunks) {
            File chunkStream = OmFileHelper.getRecordingChunk((Long)roomId, (String)chunk.getStreamName());
            if (!chunkStream.exists()) {
                log.debug("Chunk stream doesn't exist: {}", (Object)chunkStream);
                continue;
            }
            String path = chunkStream.getCanonicalPath();
            List<String> args = List.of(this.getPathToFFMPEG(), "-y", "-i", path, "-v", "error", "-f", "null", "file.null");
            ProcessResult res = ProcessHelper.exec((String)String.format("Check chunk pod video_%s_%s", numPods, parts.size()), args, (boolean)true);
            logs.add(res);
            if (res.isWarn()) continue;
            long diff = this.diff(chunk.isAudioOnly() ? chunk.getEnd() : chunk.getStart(), pStart);
            PodPart.add(parts, diff);
            if (!chunk.isAudioOnly()) {
                parts.add(new PodPart(path, this.diff(chunk.getEnd(), chunk.getStart())));
            }
            pStart = chunk.getEnd();
        }
        return pStart;
    }

    private static List<String> getFinalArgs(List<String> pods, File wav, int w) throws IOException {
        int numPods = pods.size();
        ArrayList<String> args = new ArrayList<String>();
        if (numPods == 1) {
            args.add("-i");
            args.add(pods.get(0));
            args.add("-i");
            args.add(wav.getCanonicalPath());
            args.add("-map");
            args.add("0:v");
        } else {
            StringBuilder cols = new StringBuilder();
            StringBuilder rows = new StringBuilder();
            int colCount = 0;
            int j = 0;
            for (int i = 0; i < numPods; ++i) {
                ++colCount;
                args.add("-i");
                args.add(pods.get(i));
                cols.append('[').append(i).append(":v]");
                if (i != 0 && colCount % w == 0) {
                    cols.append("hstack=inputs=").append(colCount);
                    if (j == 0 && i == numPods - 1) {
                        cols.append("[v]");
                    } else {
                        cols.append("[c").append(j).append("];");
                    }
                    rows.append("[c").append(j).append(']');
                    ++j;
                    colCount = 0;
                }
                if (i != numPods - 1) continue;
                if (j > 1) {
                    rows.append("vstack=inputs=").append(j).append("[out];[out]pad=ceil(iw/2)*2:ceil(ih/2)*2[v]");
                    continue;
                }
                rows.setLength(0);
            }
            args.add("-i");
            args.add(wav.getCanonicalPath());
            args.add("-filter_complex");
            args.add(cols.append((CharSequence)rows).toString());
            args.add("-map");
            args.add("[v]");
        }
        args.add("-map");
        args.add(numPods + ":a");
        args.add("-qmax");
        args.add("1");
        args.add("-qmin");
        args.add("1");
        return args;
    }

    @Override
    protected List<String> additionalMp4OutParams(Recording r) {
        return List.of("-s", this.getDimensions(r));
    }

    private static class PodPart {
        final String file;
        final long duration;

        public PodPart(String file, long duration) {
            this.file = file;
            this.duration = duration;
        }

        public PodPart(long duration) {
            this(null, duration);
        }

        public String getFile() {
            return this.file;
        }

        public long getDuration() {
            return this.duration;
        }

        public static void add(List<PodPart> parts, long duration) {
            if (duration > 19L) {
                parts.add(new PodPart(duration));
            } else {
                log.warn("PodPart with duration less than 19ms found: {}", (Object)duration);
            }
        }
    }
}

